/**
 * Provides a way for plugins to register hooks to the sortable tables
 * @since 6.1.2
 */
define('confluence-sortable-tables/hooks', [], function() {
    'use strict';

    var beforeInit = [];
    return {
        /**
         * Registers a function to run before the sortable tables are activated.
         * @param {function} callback   The function to register. It receives $.tablesorter as its only argument.
         */
        onBeforeInit: function(callback) {
            beforeInit.push(callback);
        },
        beforeInitHooks: function() {
            return beforeInit;
        }
    };
});
