/**
 * @module confluence-a11y-help-page/header-highlights
 */
// disable confluence-amd-module-names because it requires AMD module name to be "confluence-a/header-highlights", which doesn't make sense
// tests can be found in confluence-frontend-tools/test/a11y-help-page
/* eslint-disable @atlassian/confluence-server/confluence-amd-module-names, @atlassian/confluence-server/matching-tests */
define('confluence-a11y-help-page/header-highlights', [
    'window',
    'document',
    'jquery',
], function(
    window,
    document,
    $
) {
    'use strict';

    var clearHighlights = function() {
        Array.from(document.querySelectorAll('.a11y-rule-highlighted')).forEach(function(el) {
            el.classList.remove('a11y-rule-highlighted');
        });
    };

    var addHighlight = function(hash) {
        var id;
        var el;
        if (hash) {
            // CONFSRVDEV-17344: #D5, #D5A, #D5B, #D5C all reference rule D5
            id = (hash.substring(0, 3) === '#D5') ? 'D5' : hash.substring(1);
            el = document.getElementById(id);
            if (el) {
                el.classList.add('a11y-rule-highlighted');
            }
            el = document.getElementById('a11y-help-toc-' + id);
            if (el) {
                el.classList.add('a11y-rule-highlighted');
            }
        }
    };

    $(document).ready(function() {
        addHighlight(window.location.hash);
    });

    window.addEventListener('hashchange', function() {
        clearHighlights();
        addHighlight(window.location.hash);
    }, false);

    return {
        // Exposed for testing
        _clearHighlights: clearHighlights,
        _addHighlight: addHighlight
    };
});

require('confluence/module-exporter').safeRequire('confluence-a11y-help-page/header-highlights');
