define('confluence/share-page/autocomplete/setup-autocomplete', [
    'jquery',
    'confluence/templates',
    'confluence/dropdown'
], function($, Templates, Dropdown) {
    /**
     * Sets up the controls for the user autocomplete
     * @param $contents     jQuery dialog contents
     * @param trigger       The DOM element trigger that controls this dialog
     * @param parameters    Parameters passed-through from the dialog controller.
     */
    return function setupAutocomplete($contents, trigger, parameters) {
        var $input = $contents.find("#share-invite-users-input");
        var $shareButton = $contents.find("input.submit");

        $input.bind("selected.autocomplete-sharepage", function (e, data) {
            var addItem = function (type, template, data) {
                var $recipients = $contents.find(".recipients");
                var recipientSelector;
                var $item;

                $recipients.show();
                $contents.find('.autocomplete-user-target').nextAll('.recipientSelectionError').remove();
                $input.removeClass('field-error');

                recipientSelector = "li[data-" + type + "=\"" + data.content[type] + "\"]";
                if ($recipients.find(recipientSelector).length > 0) {
                    $recipients.find(recipientSelector).hide();
                } else {
                    $recipients.append(template(data.content));
                }
                $item = $recipients.find(recipientSelector);

                const removeRecipient = function () {
                    $item.remove();
                    if ($recipients.find("li").length == 0) {
                        $shareButton.addClass("disabled");
                        $shareButton.attr('aria-disabled', true);
                        $recipients.hide();
                    }
                    $(trigger).data('dialog').refresh();
                    $input.focus();
                    return false;
                }

                $item.find(".remove-recipient").click(removeRecipient);
                $item.find(".remove-recipient").on('keydown', function (e) {
                    if (e.keyCode === $.ui.keyCode.ENTER) {
                        removeRecipient()
                    }
                });
                $item.fadeIn(200);
            };

            if (data.content.email) {
                addItem("email", Templates.Share.Dialog.recipientEmail, data);
            } else if (data.content.type == "group") {
                addItem("group", Templates.Share.Dialog.recipientGroup, data);
            } else {
                addItem("userKey", Templates.Share.Dialog.recipientUser, data);
            }

            $(trigger).data('dialog').refresh();
            $shareButton.removeClass("disabled");
            $shareButton.attr('aria-disabled', false);
            $input.val("");
            $input.focus();

            return false;
        });

        $input.bind("open.autocomplete-sharepage", function (e, data) {
            if ($("a:not(.no-results)", Dropdown.current.links).length > 0)
                Dropdown.current.moveDown();
        });

        $input.keypress(function (e) {
            return e.keyCode != 13;
        });
    }
});