require([
    'ajs',
    'confluence/meta',
    'confluence/share-page/service/share-page',
    'confluence/share-page/service/share-dialog-loader',
    'confluence/dark-features'
], function (
    AJS,
    Meta,
    SharePage,
    ShareDialogLoader,
    DarkFeatures) {
    // We only have invite to edit in collaborative editing mode, excluding anonymous users
    if (Meta.get('edit-mode') !== 'collaborative' || !Meta.get('remote-user')) {
        return;
    }

    if (AJS.Rte.getEditor() && AJS.Rte.getEditor().initialized) {
        _init();
    } else {
        AJS.bind('rte-collab-ready', _init);
    }

    function _init() {
        // No comments or funny business
        if (Meta.get('content-type') !== 'page' && Meta.get('content-type') !== 'blogpost') {
            return;
        }
        var $ = AJS.$;
        var focusableNeedle = 'a[href]:visible, input:visible, button:not([disabled]):visible, textarea:visible, select:visible, details:visible,[tabindex]:not([tabindex="-1"]):visible';

        // load the legacy invite to edit dialog
        // FIXME CONFSRVDEV-10460: Remove this logic when shipping the new share dialog

        // Insert the invite button into the editor
        // Styling for this button is controlled by the collaborative-editor-plugin
        var selector = '#inviteToEditLink';
        $('#rte-toolbar').append(
            $(document.createElement('button'))
                .prop('id', selector.replace('#', ''))
                .attr('aria-label', AJS.I18n.getText('share.invite.to.edit.tooltip'))
                .attr('aria-haspopup', true)
                .attr('aria-expanded', false)
                .addClass('aui-button')
                .addClass('invite-to-edit-button')
                .html('<span class="invite-plus-icon"></span>')
                .tooltip({
                    title: function () {
                        return AJS.I18n.getText('share.invite.to.edit.tooltip')
                    },
                    gravity: 'ne'
                }));
        var $trigger = $(selector);

        var notePlaceholder = Meta.get('content-type') === 'page'
            ? AJS.I18n.getText('share.invite.to.edit.message.placeholder.page')
            : AJS.I18n.getText('share.invite.to.edit.message.placeholder.blogpost');

        var setFocus = function() {
            var focusableElements = $('#inline-dialog-inviteToEditPopup').find(focusableNeedle);
            var firstElement = focusableElements.first();
            if (firstElement) {
                firstElement.focus();
            }
        };

        var trapFocus = function() {
            var capture = $("#inline-dialog-inviteToEditPopup .share-content-popup");
            var tabbable = $()
                .add( capture.find( "button, input, select, textarea" ) )
                .add( capture.find( "[href]" ) )
                .add( capture.find( "[tabindex]:not([tabindex='-1'])" ) );
            capture.focus()
                .keydown(
                    function handleKeydown(event) {
                        if ( event.key.toLowerCase() !== "tab" ) {
                            return;
                        }
                        var target = $( event.target );
                        if ( event.shiftKey ) {
                            if ( target.is( capture ) || target.is( tabbable.first() ) ) {
                                event.preventDefault();
                                tabbable.last().focus();
                            }
                        } else {
                            if ( target.is( tabbable.last() ) ) {
                                event.preventDefault();
                                tabbable.first().focus();
                            }
                        }
                    });
        }

        var isOpen = false;

        SharePage.initDialog(selector, "inviteToEditPopup", {}, {
            heading: AJS.I18n.getText('share.invite.to.edit.title'),
            notePlaceholder: notePlaceholder,
            link: function () {
                return require('confluence/share-page/fetch/content-info')(Meta.get('content-id'), 'draft')
                    .then(function (response) {
                        return Meta.get('base-url') + response._links.edit;
                    });
            },
            entityId: function () {
                return Meta.get('draft-id');
            },
            restriction: function() {
                return require('confluence/share-page/fetch/content-restrictions')(Meta.get('content-id'))
                    .then(function (response) {
                        var isRestricted = response.read.restrictions.user.size
                            || response.read.restrictions.group.size
                            || response.update.restrictions.user.size
                            || response.update.restrictions.group.size;
                        var restrictionWarning = {};
                        if (isRestricted) {
                            restrictionWarning.type = "restrict";
                            restrictionWarning.message = AJS.I18n.getText("share.restriction.page.restrict");
                        }
                        return restrictionWarning;

                    });
            },
            copyOption: 'invite',
            shareType: 'edit',
            contentType: Meta.get('content-type'),
            errorText: AJS.I18n.getText('share.dialog.error'),
            beforeLoad: function () {
                $trigger.find('.invite-plus-icon').css('visibility', 'hidden'); // hide current icon
                $trigger.spin();
            },
            afterLoad: function () {
                $trigger.find('.invite-plus-icon').css('visibility', 'visible'); // show current icon
                $trigger.spinStop();
            },
            onShow: function () {
                $trigger.attr('aria-expanded', true);
                setFocus();
                trapFocus();
                isOpen = true;
            },
            onHide: function() {
                if (isOpen) {
                    $trigger.attr('aria-expanded', false);
                    $(document).off('keyup').on('keyup', function(e) {
                        if (e.keyCode === 27) {
                            $trigger.focus();
                        }
                    });
                }
                isOpen = false;
            }
        });
    }
});
