define('confluence/share-page/util/show-message', [
    'jquery',
    'confluence/legacy'
], function ($, Confluence) {
    /**
     * Creates an announcement element that will be used to announce the message to the user
     * @returns {HTMLDivElement}
     */
    function _createAnnouncement() {
        const announcement = document.createElement('div');

        announcement.setAttribute('role', 'alert');
        announcement.className = 'assistive';
        announcement.textContent = AJS.I18n.getText('share.invite.to.edit.copied');

        return announcement;
    }
    /**
     * Shows a message on the screen after the provided element. If the same message already exists,
     * it will use a slide effect to hide and show the message to draw the attention to the message.
     *
     * @param $afterRow         the jQuery element after which the message should be inserted
     * @param templateName      the templateName for the message. Also also double's as as the className for the message element.
     *                          These must match.
     * @param parameters        Parameters to pass to the SOY template
     * @param persistent        true if the message should be persistently shown. Otherwise, it will hide after a set duration
     * @param beforeExisting    function to run if an existing message with the same class is found before removing
     *                          the existing message
     * @param afterExisting     function to run once the existing element is removed.
     */
    return function showMessage($afterRow, templateName, parameters, persistent, beforeExisting, afterExisting) {
        var $existingMessage = $afterRow.next('.' + templateName);
        var $newMessage = $(Confluence.Templates.Share.Dialog[templateName](parameters));
        var $message;
        var announcement = _createAnnouncement();

        if ($existingMessage.length) {
            beforeExisting && typeof beforeExisting === 'function' && beforeExisting();
            if ($existingMessage.hasClass('show')) {
                $existingMessage.addClass('existing');

                setTimeout(function () {
                    $existingMessage.removeClass('existing');
                    afterExisting && typeof afterExisting === 'function' && afterExisting();
                }, 200);
            } else {
                $existingMessage.addClass('show');
                $(announcement).appendTo('body');
                afterExisting && typeof afterExisting === 'function' && afterExisting();
            }

            $message = $existingMessage;
        } else {
            $afterRow.after($newMessage);
            setTimeout(function () {
                $newMessage.addClass('show');
                $(announcement).appendTo('body');
            }, 5);

            $message = $newMessage;
        }

        if (!persistent) {
            clearTimeout($message.data('timeout'));
            var timeout = setTimeout(function () {
                $message.removeClass('show');
                $(announcement).remove();
            }, 2000);
            $message.data('timeout', timeout);
        }
    }
});