require([
    'ajs',
    'confluence/meta',
    'confluence/share-page/service/share-page',
    'confluence/share-page/service/share-dialog-loader',
    'confluence/dark-features'
], function (
    AJS,
    Meta,
    SharePage,
    ShareDialogLoader,
    DarkFeatures) {
    var heading = Meta.get('content-type') === 'page'
        ? AJS.I18n.getText('share.dialog.heading.page')
        : AJS.I18n.getText('share.dialog.heading.blogpost');
    var notePlaceholder = Meta.get('content-type') === 'page'
        ? AJS.I18n.getText('share.dialog.message.placeholder.page')
        : AJS.I18n.getText('share.dialog.message.placeholder.blogpost');

    AJS.toInit(function ($) {
        // FIXME CONFSRVDEV-10460: Remove this logic once react share dialog is undarkened and shipped. We won't need it anymore.
        var legacySelector = "#shareContentLink";
        var $trigger = $(legacySelector);
        if (!$(legacySelector).length) { // avoid duplicated initialization in Edit mode
            return;
        }
        $trigger.attr('aria-expanded', false);
        SharePage.initDialog(legacySelector, "shareContentPopup", {}, {
            heading: heading,
            notePlaceholder: notePlaceholder,
            link: function () {
                return $('link[rel="shortlink"]').prop('href');
            },
            entityId: function () {
                return Meta.get('page-id');
            },
            restriction: function () {
                return require('confluence/share-page/fetch/content-restrictions')(Meta.get('content-id'))
                    .then(function (response) {
                        var isRestricted = response.read.restrictions.user.size
                            || response.read.restrictions.group.size
                            || response.update.restrictions.user.size
                            || response.update.restrictions.group.size;
                        var restrictionWarning = {};
                        if (isRestricted) {
                            restrictionWarning.type = "restrict";
                            restrictionWarning.message = AJS.I18n.getText("share.restriction.page.restrict");
                        }
                        return restrictionWarning;
                    });
            },
            copyOption: 'share',
            shareType: 'view',
            contentType: Meta.get('content-type'),
            errorText: AJS.I18n.getText('share.dialog.error'),
            beforeLoad: function () {
                $trigger.find('.aui-icon').css('visibility', 'hidden'); // hide current icon
                $trigger.spin();
            },
            afterLoad: function () {
                $trigger.find('.aui-icon').css('visibility', 'visible'); // show current icon
                $trigger.spinStop();
            },
            onShow: function () {
                $trigger.attr('aria-expanded', true);
            },
            onHide: function () {
                $(".dashboard-actions .explanation").hide();
                $trigger.attr('aria-expanded', false);
            }
        });
    });
});
