/**
 * @module confluence-page-restrictions-dialog/dialog
 */
define('confluence-page-restrictions-dialog/dialog', [
    'jquery',
    'ajs',
    'aui/dialog2',
    'confluence-page-restrictions-dialog/dialog-model',
    'confluence-page-restrictions-dialog/dialog-view',
    'confluence/legacy',
    'confluence/meta',
    'confluence/templates'
],
function(
    $,
    AJS,
    auiDialog,
    DialogModel,
    DialogView,
    Confluence,
    Meta,
    Templates
) {
    'use strict';

    var dialog2;

    var Dialog = {
        show: function() {
            var dialogModel = new DialogModel({
                // CONFDEV-33892 - Here we need to cast the return value as a string to avoid passing an integer into the model.
                // CONF-43710 - Try page-id if no content-id is available until CONFDEV-41174 is tackled
                contentId: Meta.get('content-id') || Meta.get('page-id'),
                parentPageId: Meta.get('parent-page-id'),
                spaceKey: Meta.get('space-key'),
                contextPath: Meta.get('context-path')
            });
            dialogModel.fetch().done(function(data) {
                dialog2 = auiDialog(
                    Templates.Restrictions.pageRestrictionsDialog()
                );
                dialog2.show();
                var dialogView = new DialogView({ model: dialogModel, el: dialog2.$el, dialog2: dialog2 });
                dialogView.triggerRestrictionsUpdateEvent(data.restrictionsHash);

                function dialogUpdate() {
                    dialogView.disableApply();

                    dialogModel.fetch().done(function() {
                        dialogModel.populateWithCurrentUser();
                        dialogView.notifyUserOfExternalChange();
                    });
                }

                $.extend(AJS.PagePermissions, {
                    updateRestrictionsDialog: dialogUpdate
                });
            });
            Confluence.Analytics.publish('confluence.restrictions.dialog.open');
        },

        reloadIcon: function() {
            var dialogModel = new DialogModel({
                // CONFDEV-33892 - Here we need to cast the return value as a string to avoid passing an integer into the model.
                contentId: Meta.get('content-id'),
                parentPageId: Meta.get('parent-page-id'),
                spaceKey: Meta.get('space-key'),
                contextPath: Meta.get('context-path')
            });
            dialogModel.fetch().done(function(data) {
                data.hasExplicitRestrictions = dialogModel.hasExplicitViewRestrictions();
                data.hasInheritedRestrictions = dialogModel.hasInheritedViewRestrictions();
                data.hasAnyExplicitRestrictions = dialogModel.hasExplicitRestrictions();
                AJS.trigger('edit-page-restrictions-updated', data);
            });
        }
    };

    return Dialog;
});

require('confluence/module-exporter').safeRequire('confluence-page-restrictions-dialog/dialog', function(Dialog) {
    'use strict';

    var AJS = require('ajs');
    // Bind to the event triggered by page-permissions-deferred-loader.js
    AJS.bind('deferred.page.permissions', function() {
        Dialog.show();
    });
    // Bind the reload icon method to a move page event
    AJS.bind('editor-page-moved', function() {
        Dialog.reloadIcon();
    });
});
