/**
 * @module confluence-page-restrictions-dialog/inherited-view
 */
define('confluence-page-restrictions-dialog/inherited-view', [
    'ajs',
    'backbone',
    'aui/inline-dialog2',
    'confluence/templates'
],
function(
    AJS,
    Backbone,
    InlineDialog2,
    Templates
) {
    'use strict';

    var InheritedView = Backbone.View.extend({
        initialize: function() {
            this.render();
        },

        render: function() {
            var entities = this.collection.formatForPresentation();

            // TODO Fix this when AUI is upgraded, this uses the older InlineDialog2 implementation from 5.7.26.
            this.$el.html(Templates.Restrictions.inheritedRestrictionsPopup({
                entities: entities
            }));
        }
    });

    return InheritedView;
});
