/**
 * @module confluence-page-restrictions-dialog/restriction-model
 */
define('confluence-page-restrictions-dialog/restriction-model', [
    'ajs',
    'backbone',
    'confluence/meta'
],
function(
    AJS,
    Backbone,
    Meta
) {
    'use strict';

    var RestrictionModel = Backbone.Model.extend({
        initialize: function(options) {
            this.set('id', options.id);
            this.set('entityType', options.entity.type);
            this.set('permission', options.permission);
            this.set('owningContentId', options.owningContentId);
            this.set('owningContentTitle', options.owningContentTitle);

            // The page permissions backend returns a different format to the API for user/group searches.
            if (options.isClientModel) {
                this.set('fullName', this.isUser() ? options.entity.title : options.entity.name);
                this.set('entityName', this.isUser() ? options.entity.username : options.entity.name);
                this.set('pictureUrl', this.isUser() ? options.entity.thumbnailLink.href : Meta.get('context-path') + '/images/icons/avatar_group_48.png');
            } else {
                this.set('fullName', this.isUser() ? options.entity.fullName : options.entity.name);
                this.set('entityName', options.entity.name);
                this.set('pictureUrl', Meta.get('context-path')
                    + (this.isUser() ? options.entity.profilePictureDownloadPath : '/images/icons/avatar_group_48.png'));
            }

            // This entity is removable if it is not representative of the current user.
            this.set('canRemove', !this.isCurrentUser());
        },

        changeEntityPermission: function(permissionType) {
            this.set('permission', permissionType);
        },

        isUser: function() {
            return this.get('entityType') === 'user';
        },

        isCurrentUser: function() {
            return this.isUser() && this.get('id') === Meta.get('remote-user-key');
        }
    });

    return RestrictionModel;
});
