/* eslint-disable vars-on-top */
/**
 * LinkAdapter is an adapter between the RTE and a Link object.
 *
 * It should not know about the Link Browser or how the internals of a Link object work.
 * Any interaction with RTE nodes and Links should be via this object.
 *
 * @module confluence-link-browser/link-adapter
 */
define('confluence-link-browser/link-adapter', [
    'ajs',
    'jquery',
    'confluence/legacy',
    'tinymce'
], function(
    AJS,
    $,
    Confluence,
    tinymce
) {
    'use strict';

    return {

        /**
         * Inserts a link at the position of the current range.
         * @param linkObj a Confluence.Link instance
         */
        setLink: function(linkObj) {
            var ed = AJS.Rte.getEditor();
            var newLinkNode = $(ed.dom.create('a'), ed.getDoc());

            linkObj.fillNode(newLinkNode);
            var insertedNode = tinymce.confluence.NodeUtils.replaceSelection(newLinkNode);

            return insertedNode;
        },

        /**
         * Constructs a javascript object containing link information.
         * Invoked when the user tries to edit an existing link or make a piece of selected content into a link.
         *
         * Returns a new or existing link based on the current Editor selection.
         */
        getLink: function() {
            var ed = AJS.Rte.getEditor();
            var selectionContent = ed.selection.getContent();
            var editorContent = ed.getContent();
            var selection = ed.selection;

            // Checks if the selection is in the editor as a string
            var hasSelectionInEditor = editorContent.includes(selectionContent);

            // CONFSERVER-90745
            // If the selection goes outside of block, we need to ensure it stays within the block
            if (!hasSelectionInEditor) {
                var nativeSelection = selection.win.getSelection();
                var currentRng = selection.getRng();
                if (typeof nativeSelection.setBaseAndExtent === 'function') { // Current QUnit Firefox version don't have this function - remove this once on atleast 53
                    if (currentRng.commonAncestorContainer.outerHTML === currentRng.endContainer.outerHTML) { // User selected to the end
                        nativeSelection.setBaseAndExtent(currentRng.startContainer, currentRng.startOffset, currentRng.startContainer, currentRng.startContainer.length);
                    } else { // User selected to the start
                        nativeSelection.setBaseAndExtent(currentRng.endContainer, 0, currentRng.endContainer, currentRng.endOffset);
                    }
                }
            }

            var selectedNode = selection.getNode();
            var linkNode = $(selectedNode).parents().addBack().filter('a[href]')[0];

            if (linkNode) {
                selection.select(linkNode);
                return Confluence.Link.fromSelectedAnchor(linkNode, selection.getContent({ format: 'text' }));
            }

            var rng = selection.getRng();
            var selectedText = selection.getContent({ format: 'text' });
            var selectedHtml = selection.getContent();
            return Confluence.Link.fromSelection(rng, selectedNode, selectedHtml, selectedText);
        }

    };
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence-link-browser/link-adapter', 'Confluence.Editor.LinkAdapter');
