const OAUTH2_RESOURCE_PATH = "/rest/nativemobile/1.0/oauth2/";
const OAUTH2_CACHE_ENDPOINT_PATH = OAUTH2_RESOURCE_PATH + "cache/";

const OAUTH2_TOGGLE_SELECTOR = '#oauth2-toggle';
const OAUTH2_TOGGLE_CACHE_SELECTOR = '#oauth2-cache-toggle';

const OAUTH2_TOGGLE_LABEL_SELECTOR = '#oauth2-toggle-label';
const OAUTH2_CACHE_TOGGLE_LABEL_SELECTOR = '#oauth2-cache-toggle-label';

const OAUTH2_CONFIGURATION_SECTION_SELECTOR = '#oauth2-configuration-section';

$(function() {
   var restUrl = AJS.Meta.get("context-path") + "/rest/nativemobile/1.0/push-notification/status/";
   var toggle = document.getElementById('push-notification-status');
   toggle.addEventListener('change', function() {
      var isChecked = toggle.checked;
      var status = isChecked ? "enabled" : "disabled";
      toggle.busy = true;

      $.ajax({
         type: "POST",
         url: restUrl + status,
         contentType: "application/json"
      })
         .fail(function () {
            toggle.checked = !isChecked;
         })
         .always(function () {
            toggle.busy = false;
         });
   });

   let changeOauth2CacheLabelToOn = function () {
      $(OAUTH2_CACHE_TOGGLE_LABEL_SELECTOR).html(AJS.I18n.getText('mobile.admin.page.oauth2.cache.toggle.text.on'));
   };

   let changeOauth2CacheLabelToOff = function () {
      $(OAUTH2_CACHE_TOGGLE_LABEL_SELECTOR).html(AJS.I18n.getText('mobile.admin.page.oauth2.cache.toggle.text.off'));
   };

   let changeOauth2LabelToOn = function () {
      $(OAUTH2_TOGGLE_LABEL_SELECTOR).html(AJS.I18n.getText('mobile.admin.page.oauth2.toggle.text.on'));
   };

   let changeOauth2LabelToOff = function () {
      $(OAUTH2_TOGGLE_LABEL_SELECTOR).html(AJS.I18n.getText('mobile.admin.page.oauth2.toggle.text.off'));
   };

   let onOauth2ToggleReadyAction = function () {
      if ($(OAUTH2_TOGGLE_SELECTOR).prop('checked')) {
         changeOauth2LabelToOn();
         $(OAUTH2_CONFIGURATION_SECTION_SELECTOR).show();
      } else {
         changeOauth2LabelToOff();
         $(OAUTH2_CONFIGURATION_SECTION_SELECTOR).hide();
      }
   };

   let onOauth2CacheToggleReadyAction = function () {
      changeOauth2CacheLabelText($(OAUTH2_TOGGLE_CACHE_SELECTOR).prop('checked'));
   };

   let changeOauth2CacheLabelText = function (toggleEnabled) {
      if (toggleEnabled) {
         $(changeOauth2CacheLabelToOn)
      } else {
         $(changeOauth2CacheLabelToOff)
      }
   };

   let disableOAuth2CacheToggle = function() {
      changeOauth2CacheLabelToOff();
      $(OAUTH2_TOGGLE_CACHE_SELECTOR).prop('checked',false);
   }

   let onOauth2AjaxSuccess = function (toggleEnabled) {
      if (toggleEnabled) {
         changeOauth2LabelToOn();
         $(OAUTH2_CONFIGURATION_SECTION_SELECTOR).show();
         disableOAuth2CacheToggle();
      } else {
         changeOauth2LabelToOff();
         $(OAUTH2_CONFIGURATION_SECTION_SELECTOR).hide();
         disableOAuth2CacheToggle();
      }
   };

   let disableOAuth2Toggle = function(){
      $(OAUTH2_TOGGLE_SELECTOR).prop('checked', false);
      changeOauth2LabelToOff();
   };

   let onSwitchCacheToggleNotFound = function () {
      disableOAuth2Toggle();
      $(OAUTH2_CONFIGURATION_SECTION_SELECTOR).hide();
      $(OAUTH2_TOGGLE_CACHE_SELECTOR).prop('checked', false);
   };

   let onResetButtonNotFound = function () {
      disableOAuth2Toggle();
      $(OAUTH2_CONFIGURATION_SECTION_SELECTOR).hide();
   };

   let onOauth2ToggleChange = function () {
      let oauth2ToggleEnabled = $(OAUTH2_TOGGLE_SELECTOR).prop('checked');
      let oauthUrl = AJS.Meta.get("context-path") + OAUTH2_RESOURCE_PATH + (oauth2ToggleEnabled ? "enable" : "disable");
      $.ajax({
         type: "POST",
         url: oauthUrl,
         contentType: "application/json"
      }).fail(function(){

      }).always(function () {
         onOauth2AjaxSuccess(oauth2ToggleEnabled);
      });
   };

   let onCacheToggleChange = function () {
      let cacheToggleEnabled = $(OAUTH2_TOGGLE_CACHE_SELECTOR).prop('checked');
      let oauthCacheURL = AJS.Meta.get("context-path") + OAUTH2_CACHE_ENDPOINT_PATH + (cacheToggleEnabled ? "enable" : "disable")
      $.ajax({
         type: "POST",
         url: oauthCacheURL,
         contentType: "application/json"
      }).always(function () {
         changeOauth2CacheLabelText(cacheToggleEnabled);
      }).fail(function () {
      });
   };

   let initialiseEvents = function () {
      $(OAUTH2_TOGGLE_SELECTOR).on('change', onOauth2ToggleChange);
      $(OAUTH2_TOGGLE_SELECTOR).ready(onOauth2ToggleReadyAction);
      $(OAUTH2_TOGGLE_CACHE_SELECTOR).on('change', onCacheToggleChange);
      $(OAUTH2_TOGGLE_CACHE_SELECTOR).ready(onOauth2CacheToggleReadyAction);
   };

   $(initialiseEvents);
});