@ECHO OFF

rem
rem check for correct java version by running the version checker jar
rem

set min_conf_jvm_version=17

for /f "tokens=*" %%i in ('""%JRE_HOME%\bin\java.exe" -jar "%CATALINA_HOME%\bin\confluence-jvm-version-checker.jar" %min_conf_jvm_version%"') do set CONFLUENCE_JVM_CHECK=%%i

if not "%CONFLUENCE_JVM_CHECK%" == "true" goto wrong_version
exit /b 0

:wrong_version
echo ****************************************************************************
echo *******                  Wrong JVM version detected!                 *******
echo ****************************************************************************
echo ***
echo *** %CONFLUENCE_JVM_CHECK%
echo ***
if "%ignore_jvm_version%" == "true" (
    echo *** Environment variable 'ignore_jvm_version' is set to 'true'
    echo *** Confluence is going to bypass restriction and run using existing JVM version
    echo ***
    echo ****************************************************************************
    exit /b 0
)
echo *** If you want Confluence to start using this JVM
echo *** set environment variable 'ignore_jvm_version' to 'true'
echo ***
echo ****************************************************************************
exit /b 1