#!/bin/sh

#
# check for correct java version by running the version checker jar
#

min_conf_jvm_version=17

confluence_jvm_check=`$JRE_HOME/bin/java -jar $CATALINA_HOME/bin/confluence-jvm-version-checker.jar $min_conf_jvm_version`

if [ "$confluence_jvm_check" != "true" ]
then
    echo "****************************************************************************"
    echo "*******                 Wrong JVM version detected!                  *******"
    echo "****************************************************************************"
    echo "***"
    echo "*** $confluence_jvm_check"
    echo "***"
    if [ "$ignore_jvm_version" = "true" ]
    then
        echo "*** Environment variable 'ignore_jvm_version' is set to 'true'"
        echo "*** Confluence is going to bypass restriction and run using existing JVM version"
        echo "***"
        echo "****************************************************************************"
    else
        echo "*** If you want Confluence to start using this JVM"
        echo "*** set environment variable 'ignore_jvm_version' to 'true'"
        echo "***"
        echo "****************************************************************************"
        exit 1
    fi
fi