<%@ page import="com.atlassian.config.util.BootstrapUtils,
                 com.atlassian.confluence.cluster.ClusterInformation,
                 com.atlassian.confluence.cluster.ClusterManager,
                 com.atlassian.confluence.impl.core.persistence.hibernate.ExceptionMonitorPredicates,
                 com.atlassian.confluence.jmx.RequestMetrics,
                 com.atlassian.confluence.plugin.persistence.PluginDataDao,
                 com.atlassian.confluence.plugin.persistence.PluginDataWithoutBinary,
                 com.atlassian.confluence.status.SystemErrorInformationLogger,
                 com.atlassian.confluence.status.service.SystemInformationService,
                 com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo,
                 com.atlassian.confluence.status.service.systeminfo.DatabaseInfo" %>
<%@ page import="com.atlassian.confluence.status.service.systeminfo.MemoryInfo"%>
<%@ page import="com.atlassian.confluence.util.GeneralUtil"%>
<%@ page import="com.atlassian.confluence.util.HtmlUtil"%>
<%@ page import="com.atlassian.core.logging.DatedLoggingEvent"%>
<%@ page import="com.atlassian.core.logging.ThreadLocalErrorCollection"%>
<%@ page import="com.atlassian.plugin.Plugin"%>
<%@ page import="com.atlassian.plugin.PluginInformation"%>
<%@ page import="com.atlassian.seraph.auth.DefaultAuthenticator"%>
<%@ page import="com.atlassian.spring.container.ContainerManager"%>
<%@ page import="org.apache.commons.lang3.StringUtils" %>
<%@ page import="org.apache.log4j.spi.LoggingEvent" %>
<%@ page import="java.io.PrintWriter"%>
<%@ page import="java.security.Principal" %>
<%@ page import="java.text.DateFormat" %>
<%@ page import="java.util.Date" %>
<%@ page import="java.util.Enumeration" %>
<%@ page import="java.util.Iterator" %>
<%@ page import="java.util.List" %>
<%@ page import="java.util.Locale" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.UUID" %>
<%@ page import="com.atlassian.confluence.core.ConfluenceSystemProperties" %>
<%@ page import="com.atlassian.confluence.impl.logging.ConfluenceStackTraceRenderer" %>
<%@ page import="jakarta.servlet.RequestDispatcher" %>
<%@ page import="com.atlassian.confluence.impl.i18n.DefaultI18NBeanFactory" %>
<%@ page import="com.atlassian.confluence.util.i18n.I18NBean" %>
<%@ page isErrorPage="true" %>
<% String context = request.getContextPath(); %>
<% I18NBean i18n = DefaultI18NBeanFactory.getDefaultI18NBean(); %>
<% try { %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>Oops - an error has occurred</title>
</head>
<body>
<div id="PageContent">
<h1>
    <img src="<%= context %>/images/logo/confluence-logo-adg3.svg" style="height:24px;" alt="logo" title="Confluence">
    System Error
</h1>

<div id="sysErrPanel" class="panel">
    <p>
        A system error has occurred &mdash; our apologies!
    </p>
    <p>
        For immediate troubleshooting, consult our <strong><a href="<%= i18n.getText("url.confluence.knowledge.base") %>">knowledge base</a></strong> for a solution.
    </p>
    <p>
        If you would like to receive support from Atlassian's support team, ask your
        <strong><a href="<%= context %>/contactadministrators.action">Confluence administrator</a></strong> to create a support issue on <a href="<%= i18n.getText("url.support") %>">Atlassian's support system</a> with the following information:
    </p>
    <ol>
        <li>a description of your problem and what you were doing at the time it occurred</li>
        <li>a copy of the error and system information found below</li>
        <li>a copy of the application logs (if possible).</li>
    </ol>
    <p>
        Your Confluence administrator can use the
        <strong><a href="<%= context %>/admin/raisesupportrequest.action">support request form</a></strong>
        to create a support ticket which will include this information.
    </p>
    <p>
        We will respond as promptly as possible.<br>
        Thank you!
    </p>
    <p>
        <a href="<%= context %>/"><strong>Return to site homepage&hellip;</strong></a>
    </p>
</div>

        <%
        	UUID uniqueID = UUID.randomUUID();  // enable an easy mapping between this page and the error log.
        	SystemErrorInformationLogger logAction = new SystemErrorInformationLogger(uniqueID, pageContext.getServletContext(), request, exception);
            logAction.writeToLog(false);
            logAction.logException();
            RequestMetrics.incrementErrorCount();


            SystemInformationService sysInfoService = null;
            PluginDataDao pluginDataDao = null;
            Throwable sysInfoRetrievalFailure = null;
            try
            {
                sysInfoService = ((SystemInformationService) ContainerManager.getInstance().getContainerContext().getComponent("systemInformationService"));
                pluginDataDao = (PluginDataDao) ContainerManager.getInstance().getContainerContext().getComponent("pluginDataDao");
            }
            catch (Throwable t)
            {
                sysInfoRetrievalFailure = t;
            }

        	if (sysInfoService == null)
        	{
        		out.println("The SystemInformationService could not be retrieved from the container.");
        		out.println("Therefore very limited information is available in this error report. <br>");
                if (sysInfoRetrievalFailure != null)
                {%>The SystemInformationService could not be retrieved due to the following error:
                   <%= HtmlUtil.htmlEncode(String.valueOf(sysInfoRetrievalFailure)) %><br><%
                }
            }
        %>

    <%
        String uri = (String)request.getAttribute(RequestDispatcher.ERROR_REQUEST_URI);
        if(uri != null && uri.contains("editpage"))
        {
            String editDraft = context + "/pages/editpage.action?useDraft=true&pageId=" + HtmlUtil.htmlEncode(request.getParameter("pageId"));
            %>
            <div class="panel warning">
                <img id="draftNote" alt="" src="<%= context %>/images/icons/emoticons/warning.png">
                You can <a href="<%= editDraft %>">resume editing</a> the most recently saved draft of your page.
            </div>
        <%
        }
    %>

    <h3>Cause</h3>
    <%
        if (exception == null) {
    %>
            <p>Unknown</p>
    <%
        } else if (ConfluenceSystemProperties.isDevMode()) {
    %>
            <h4>Stack Trace (Dev Mode):<span class="switch" id="stacktrace-switch" onclick="toggle('stacktrace')">[hide]</span></h4>
            <pre id="stacktrace">
                <%= HtmlUtil.htmlEncode(ConfluenceStackTraceRenderer.renderStackTrace(exception).toString()) %>
            </pre>
    <%
        } else {
    %>
            <p>
                <strong>Exception Request Unique ID:</strong> <%= logAction.getUniqueID() %>
            </p>
    <%
        }
    %>

        <h3>Referer URL</h3>
        <p><%= request.getHeader("Referer") != null ? HtmlUtil.htmlEncode(request.getHeader("Referer")) : "Unknown" %></p>

        <% if ((sysInfoService != null) && !ExceptionMonitorPredicates.shortCircuitRequestTester().test(request) && sysInfoService.isShowInfoOn500()) {%>
            <h3>Confluence Application Information</h3>
            <h4>Build Information</h4>
            <p>
            <%
                ConfluenceInfo confluenceInfo = sysInfoService.getConfluenceInfo();
                if (confluenceInfo != null) {

                    Map buildstats = GeneralUtil.convertBeanToMap(confluenceInfo);

                    // remove the properties that we don't want to display in the maps
                    buildstats.remove("enabledPlugins");
                    buildstats.remove("startTime");
                    buildstats.remove("globalSettings");


                    for (Iterator it = buildstats.entrySet().iterator(); it.hasNext();)
                    {
                        Map.Entry entry = (Map.Entry) it.next();
            %>
                    <%= entry.getKey() %>: <%= entry.getValue() %><br>
            <%      }
                } else { %>
                No build information available.
            <%  } %>
                Unique ID: <%= uniqueID.toString()%>
            </p>

            <h4>Server information</h4>
            <p>
                Application Server: <%= application.getServerInfo() %><br>
                Servlet Version: <%= application.getMajorVersion() %>.<%= application.getMinorVersion() %><br>
                <%
                    DatabaseInfo dbInfo = sysInfoService.getSafeDatabaseInfo();
                    if (dbInfo != null) { %>
                    Database Dialect: <%= dbInfo.getDialect() %><br>
                    Database Driver Name: <%= dbInfo.getDriverName() %><br>
                <% } else { %>
                    No database information available.
                <% } %>
            </p>

            <h4>Memory Information</h4>
            <p>
            <%
                MemoryInfo memoryInfo = sysInfoService.getMemoryInfo();
                if (memoryInfo != null) { %>
                Maximum Heap: <%= memoryInfo.getMaxHeap().megabytes() %> MB<br>
                Allocated Heap: <%= memoryInfo.getAllocatedHeap().megabytes() %> MB<br>
                Used Memory: <%= memoryInfo.getUsedHeap().megabytes() %> MB<br>
                Unused Allocated Memory: <%= memoryInfo.getFreeAllocatedHeap().megabytes() %> MB<br>
                Available Memory: <%= memoryInfo.getAvailableHeap().megabytes() %> MB<br>
            <% } else { %>
                No memory information available.
            <%	} %>
            </p>

            <h4>System Information</h4>
            <p>
            <%
                    Map sysinfo = GeneralUtil.convertBeanToMap(sysInfoService.getSystemProperties());
                    for (Iterator it = sysinfo.entrySet().iterator(); it.hasNext();)
                    {
                        Map.Entry entry = (Map.Entry) it.next();
                    %>
                        <%= entry.getKey() %>: <%= entry.getValue() %><br>
            <%      } %>
            </p>

            <% if (BootstrapUtils.getBootstrapManager().getHibernateConfig().isHibernateSetup()) {%>
                <h4>Cluster Information</h4>
                <% try { %>
                    <% ClusterManager clusterManager = (ClusterManager) ContainerManager.getComponent("clusterManager"); %>
                    <% if (!clusterManager.isClustered()) { %>
                            <p>Not clustered.</p>
                    <% } else { %>
                        <% ClusterInformation clusterInformation = clusterManager.getClusterInformation(); %>
                        <p>
                            Name: <%= HtmlUtil.htmlEncode(clusterInformation.getName())%> <br>
                            Description: <%= HtmlUtil.htmlEncode(clusterInformation.getDescription())%> <br>
                            Members:<br>
                            <%
                                for (Iterator it = clusterInformation.getMembers().iterator(); it.hasNext();)
                                {
                            %>
                                    - <%= HtmlUtil.htmlEncode(String.valueOf(it.next())) %><br>
                            <%  } %>
                        </p>
                   <% } %>
                <% } catch (Throwable t) { %>
                    <p>Error reporting cluster information: <%= HtmlUtil.htmlEncode(t.toString()) %></p>
                <% } %>
            <% } %>

            <h3>Plugins</h3>
            <ul class="plugins">
            <%  if (confluenceInfo != null) {
                    DateFormat format = DateFormat.getDateInstance(DateFormat.MEDIUM, Locale.US);
                    try
                    {
                        for (Iterator it = confluenceInfo.getEnabledPlugins().iterator(); it.hasNext();)
                        {
                            Plugin plugin = (Plugin) it.next();
                            PluginInformation pluginInfo = plugin.getPluginInformation();
                            String pluginName = plugin.getName();
                            String pluginKey = plugin.getKey();
                            String pluginVersion = pluginInfo == null ? "N/A" : pluginInfo.getVersion();
                            if (pluginVersion == null) // sometimes the version isn't defined by the plugin
                                pluginVersion = "N/A";

                            String lastModifiedStr = pluginDataDao == null ? "unknown" : "bundled";
                            if (pluginDataDao != null && pluginDataDao.pluginDataExists(pluginKey))
                            {
                                PluginDataWithoutBinary pluginData = pluginDataDao.getPluginDataWithoutBinary(pluginKey);
                                Date lastModified = pluginData != null ? pluginData.getLastModificationDate() : null;
                                if (lastModified != null)
                                {
                                    lastModifiedStr = format.format(lastModified);
                                }
                            }
            %>
                            <li><%= HtmlUtil.htmlEncode(pluginName) %> (<%= HtmlUtil.htmlEncode(pluginKey) %>, Version: <%= pluginVersion %>, Installed: <%= lastModifiedStr %>) </li>
            <%          }
                    } catch (Exception e) { %>
                        <li>Error retrieving plugin information: <%= HtmlUtil.htmlEncode(e.toString()) %></li>
            <%      }
                } else { %>
                    <li>No plugin information available.</li>
            <%  } %>
            </ul>

            <h3>Request</h3>
            <%
                try {
            %>
            <h4>Information</h4>
            <dl>
                <dt>URL</dt><dd><%= HtmlUtil.htmlEncode(request.getRequestURL().toString()) %>
                <dt>URI</dt><dd><%= HtmlUtil.htmlEncode(request.getRequestURI()) %>
                <dt>Context Path</dt><dd><%= request.getContextPath() %></dd>
                <dt>Servlet Path</dt><dd><%= request.getServletPath() %></dd>
                <% if (StringUtils.isNotBlank(request.getPathInfo())) { %>
                    <dt>Path Info</dt><dd><%= HtmlUtil.htmlEncode(request.getPathInfo()) %></dd>
                <% } %>
                <% if (StringUtils.isNotBlank(request.getQueryString())) { %>
                <dt>Query String</dt><dd><%= HtmlUtil.htmlEncode(request.getQueryString()) %></dd>
                <% } %>
            </dl>
            <h4>Headers (Limited subset)</h4>
            <dl>
            <%
                String[] headers = new String[]{"host", "x-forwarded-for", "user-agent", "keep-alive",
                    "connection", "cache-control", "if-modified-since", "if-none-match"};
                for (int i = 0; i < headers.length; i++)
                {
                    String name = headers[i];
                    Enumeration headerValues = request.getHeaders(name);
                    if (headerValues == null || !headerValues.hasMoreElements()) continue;
            %>
                    <dt><%= HtmlUtil.htmlEncode(name) %></dt>
            <%
                    while (headerValues.hasMoreElements())
                    {
            %>
                    <dd><%= HtmlUtil.htmlEncode(String.valueOf(headerValues.nextElement()))%></dd>
            <%
                    }
                }
            %>
            </dl>
            <h4>Attributes</h4>
            <dl>
            <%
                for (Enumeration attributeNames = request.getAttributeNames(); attributeNames.hasMoreElements();)
                {
                    String name = String.valueOf(attributeNames.nextElement());
                %>
                    <dt><%= HtmlUtil.htmlEncode(name) %></dt>
                    <dd><%= HtmlUtil.htmlEncode(String.valueOf(request.getAttribute(name)))%></dd>
                <%
                }
            %>
            </dl>
            <h4>Parameters (Limited subset)</h4>
            <dl>
            <%
                for (Enumeration parameterNames = request.getParameterNames(); parameterNames.hasMoreElements();)
                {
                    String name = String.valueOf(parameterNames.nextElement());
                    if (name.contains("pass")) continue;
                %>
                <dt><%= HtmlUtil.htmlEncode(name) %></dt>
                <%
                    String[] parameterValues = request.getParameterValues(name);
                    for (int i = 0; i < parameterValues.length; i++)
                    {
                        %>
                        <dd><%= HtmlUtil.htmlEncode(parameterValues[i]) %></dd>
                        <%
                    }
                }
            %>
            </dl>
            <h3>Confluence User</h3>
            <%
                Object loggedInValue = session.getAttribute(DefaultAuthenticator.LOGGED_IN_KEY);
                String username;
                if (loggedInValue instanceof Principal)
                {
                    username = ((Principal)loggedInValue).getName();
                }
                else
                {
                    username = "unknown";
                }
            %>
            <p>
                <%= username %>
            </p>

            <%
                }
                catch (Throwable t)
                {
                    out.println("Error rendering logging information - uh oh.");
                    if (ConfluenceSystemProperties.isDevMode()) {
                        t.printStackTrace(new PrintWriter(out));
                    }
                }
            %>

        <%  List events = ThreadLocalErrorCollection.getList();
            if (events != null && !events.isEmpty()) { %>
            <h3>Logging:</h3>
            <%  try { %>
                <p><%= events.size() %> log statements generated by this request:</p>
                <%
                    for (Iterator it = events.iterator(); it.hasNext();)
                    {
                        Object event = it.next();
                        if (event instanceof DatedLoggingEvent) {
                            DatedLoggingEvent dle = (DatedLoggingEvent) event;
                            LoggingEvent loggingEvent = dle.getEvent();
                            Date date = dle.getDate();
                    %>
                        <div class="logStatement">
                            <em class="bad">[<%= HtmlUtil.htmlEncode(loggingEvent.getLevel().toString()) %>]</em>
                            <%= HtmlUtil.htmlEncode(date.toString()) %>
                            [<%= HtmlUtil.htmlEncode(loggingEvent.getLoggerName()) %>]
                            <%= HtmlUtil.htmlEncode(loggingEvent.getRenderedMessage()) %>
                            <br>
                            <% if (loggingEvent.getThrowableInformation() != null) { %>
                                <div class="logThrowable">
                                    <strong>Throwable:</strong><br>
                                    <%
                                        for (int i = 0; i < loggingEvent.getThrowableStrRep().length && i < 20; i++)
                                        {
                                            String s = loggingEvent.getThrowableStrRep()[i];
                                            out.println("" + HtmlUtil.htmlEncode(s) + "<br>");
                                        }
                                    %>
                                </div>
                        <% } %>
                        </div>
                    <%} else { %>
                        <%= HtmlUtil.htmlEncode(event.getClass().toString()) %>: <%= HtmlUtil.htmlEncode(event.toString()) %>
                    <% } %>
                <% } %>
            <% } catch (Throwable t) { %>
                <div class="error">
                    <div class="errorMessage" style="font-weight: bold;">Error rendering logging information - uh oh.</div>
                    <pre>
                        <% if (ConfluenceSystemProperties.isDevMode())
                            t.printStackTrace(new PrintWriter(out));
                        %>
                        </pre>
                </div>
            <% } %>
        <% } %>
    <% } %>
</div>
</body>
</html>
<%
    }
    finally
    {
        out.flush();
    }
%>
