function pad(value) {
  return value < 10 ? '0' + value : value;
}

function getCurrentDate() {
  try {
    var date = new Date();
    var day = date.getDate();
    var month = pad(date.getMonth() + 1);
    var year = date.getFullYear().toString();
    return (
      year +
      '-' +
      month +
      '-' +
      day +
      ' ' +
      pad(date.getHours()) +
      ':' +
      pad(date.getMinutes()) +
      ':' +
      pad(date.getSeconds())
    );
  } catch (e) {
    return new Date().toString();
  }
}

document.addEventListener('DOMContentLoaded', function () {
  var timestampElement = document.getElementById('js-current-timestamp');
  if (timestampElement) timestampElement.innerText = 'Date: ' + getCurrentDate();
});
