require([
            'ajs', 'underscore'
        ],
        function (AJS, _) {
            AJS.toInit(function ($) {
                $("div.contributors-macro-ajax-container").each(function () {
                    var $container = $(this);

                    // The macro parameters are encoded as JSON in the DOM
                    var macroParameters = _.unescape($container.find(".contributors-macro-parameters")[0].innerHTML)?JSON.parse(_.unescape($container.find(".contributors-macro-parameters")[0].innerHTML)): null;

                    $container.text(AJS.I18n.getText("macro.fetching.wait"));

                    $.ajax({
                        dataType: 'json',
                        url: Confluence.getContextPath() + "/rest/com.atlassian.confluence.contributors/1.0/contributors",
                        data: macroParameters,
                        success: function (data) {
                            if (data.errorMessage) {
                                $container.text(data.errorMessage);
                            } else {
                                $container.html(Confluence.ContributorsMacro.renderContent(data));

                                $container.find(".show-hidden-contributors").click(function () {
                                    $container.find(".hidden-contributor").removeClass("hidden");
                                    $(this).parent().remove();
                                    return false;
                                });
                            }
                        },
                        error: function (xhr, status, error) {
                            $container.text(AJS.I18n.getText("macro.fetching.error") + ": " + error);
                        }
                    });
                });
            });
        }
);
