/* jshint ignore: start */
let themeSwitcher = null;
let originTarget = window.location.protocol + '//' + window.location.host;
try {
    themeSwitcher = require("confluence/theme-switcher");
}
catch (e) {
    console.debug(e);
}
/* jshint ignore: end */

var MW = MW || { $ : jQuery };
MW.MV = {};
AJS.toInit(function () {
    // Only show the anchor if the user is logged in.
    if (AJS.Meta && !AJS.Meta.get("remote-user")) {
        return;
    }

    MW.MV.AnchorManager = function () {
        var xpxBaseUrl = contextPath,
            notificationsIframeUrl = xpxBaseUrl + "/plugins/servlet/notifications-miniview",
            displayNumber = 0,
            showMiniview = /[?&]show-miniview/.test(window.location.search);

        function getParameterByName(name) {
            name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
            var regexS = "[\\?\\#&]" + name + "=([^&#]*)";
            var regex = new RegExp(regexS);
            var results = regex.exec(window.location.search);
            if(results !== null) {
                return decodeURIComponent(results[1].replace(/\+/g, " "));
            }
        }

        var aggregateKey = getParameterByName('show-miniview');
        if (aggregateKey) {
            notificationsIframeUrl += '#notification/' + encodeURI(aggregateKey);
        }

        function makeAnchor() {
            var iconClass = "badge-i aui-icon aui-icon-small aui-iconfont-notification";
            MW.$('#notifications-anchor')
                .html('<div class="' + iconClass + '"></div><span class="badge-w"><span class="badge" aria-hidden="true"></span></span>')
                .attr({
                    "title": AJS.I18n.getText("com.atlassian.mywork.anchor.tooltip.open"),
                    "role": "button",
                    "aria-label": AJS.I18n.getText("com.atlassian.mywork.anchor.text.open"),
                    "aria-expanded": "false"
                });
        }

        function once(f) {
            var b = false, result;
            return function () {
                if (b) {
                    return result;
                }
                b = true;
                result = f.apply(this, arguments);
                return result;
            };
        }

        var preloadIFrame = once(function() {
            // setting closeOthers to false here because preloading the iframe will close any feature discovery
            // dialogs which are open
            MW.Dialog.getOptions().closeOthers = false;
            MW.Dialog.preload = true;
            MW.Dialog.show();
            MW.Dialog.hide();
            // setting closeOthers to true, which is the default, because once the iframe is preloaded, we always
            // want opening the workbox to close any open inline dialogs
            MW.Dialog.getOptions().closeOthers = true;
        });

        function getFormattedNumber(number) {
            return number <= 9 ? number : '9+';
        }

        function updateNotificationCount(newNotificationCount) {
            // Notifications
            var $notificationsAnchor = MW.$("#notifications-anchor"),
                $notificationsBadge = $notificationsAnchor.find(".badge"),
                $notificationsIcon = $notificationsAnchor.find('.aui-icon');
            $notificationsBadge.html(getFormattedNumber(newNotificationCount));
            displayNumber = newNotificationCount;
            if (newNotificationCount > 0) {
                $notificationsAnchor.addClass("unread").removeClass("read").attr("aria-label", AJS.I18n.getText("com.atlassian.mywork.anchor.text.new", newNotificationCount));
                if ($notificationsAnchor.is(":visible") && !showMiniview) {
                    preloadIFrame();
                }
            } else {
                $notificationsAnchor.addClass("read").removeClass("unread").attr("aria-label", AJS.I18n.getText("com.atlassian.mywork.anchor.text.open"));
            }
        }

        function createIFrame()
        {
            addMiniPopup("notifications", notificationsIframeUrl);
            escapeHidesDialog();
        }

        function escapeHidesDialog() {
            MW.$(document).keydown(function(e) {
                if (AJS.InlineDialog.current && e.which == 27 && !MW.$(e.target).is(":input")) {
                    AJS.InlineDialog.current.hide();
                }
            });
        }

        function hideOpenMenuItems() {
            MW.$("#header-menu-bar").find(".ajs-drop-down").each(function() {
                this.hide();
            });
        }

        function getFocusableElements(contentWindow) {
            var body = MW.$('body', contentWindow.document);
            return body.find("a[href]:visible, button:not([disabled]), input, textarea, select, details,[tabindex]:not([tabindex='-1']):visible");
        }
        /**
         * @param  {} element element to check visibility change
         * @param  {} callback that triggers when element became visible in scope of documentElement
         */
        function respondToVisibility(element, callback) {
            var observer = new IntersectionObserver(function(entries) {
              entries.forEach(function(entry) {
                entry.intersectionRatio > 0 && callback();
              });
            });

            observer.observe(element);
        }

        function addMiniPopup(id, url)
        {
            var popupFunctions;
            var initCallback = function() {
                popupFunctions = this;
                MW.$('#notifications-anchor').attr("aria-expanded", "true");
                var contentWindow = MW.$('#' + id + '-miniview-iframe')[0].contentWindow;
                respondToVisibility(
                    MW.$("#inline-dialog-notifications-miniview")[0],
                    function() {
                        var focusableElements = getFocusableElements(contentWindow);
                        var firstElement = focusableElements[0];
                        if (firstElement) {
                            firstElement.focus();
                        } else {
                            contentWindow.focus();
                        }
                    }
                );
            };

            var hideCallback = function() {
                // Mark all notifications as read when user dismisses the Workbox
                if (this.preload !== true) {
                    var markAllReadMsg = JSON.stringify({markAllRead: true});
                    MW.$('#' + id + '-miniview-iframe')[0].contentWindow.postMessage(markAllReadMsg, originTarget);
                    MW.$('#notifications-anchor').attr("aria-expanded", "false");
                }
            };

            // Listen for messages from the child iframe
            // escKey: Check if the esc key was pressed from within the iframe
            if (!window.addEventListener) {
                window.attachEvent("onmessage", handleEvent);
            } else {
                window.addEventListener("message", handleEvent, false);
            }

            function handleEvent(e) {
                function sameOrigin(origin) {
                    return origin === location.protocol + '//' + location.host;
                }

                if ("escKey" === e.data) {
                    hideAndManageFocus();
                } else if ("getParentConfig" === e.data && sameOrigin(e.origin)) {
                    var getParentConfigMsg = JSON.stringify({
                        parentConfig: {
                            parentUrl: location.href,
                            preload: MW.Dialog.preload,
                            unread: displayNumber
                        }
                    }),
                        contentWindow = MW.$('#' + id + '-miniview-iframe')[0].contentWindow;
                    contentWindow.postMessage(getParentConfigMsg, originTarget);
                    contentWindow.document.addEventListener("keydown", getKeydownEventListener(contentWindow));
                    if (MW.Dialog.preload) {
                        MW.Dialog.preload = false;
                    }
                }
            }

            /**
             * @param  {Object} contentWindow iframe's contentWindow
             * @returns {Function} keydown event listener that keeps natural focus order on a page
             */
            function getKeydownEventListener(contentWindow) {
                return function (e) {
                    if (e.key != "Tab") {
                        return;
                    }
                    var focusableElements = getFocusableElements(contentWindow);
                    var firstElement = focusableElements[0];
                    var lastElement = focusableElements[focusableElements.length - 1];

                    if(!focusableElements.length) {
                        hideAndManageFocus();
                        return;
                    }

                    // if user press Shift+Tab
                    if (e.shiftKey && contentWindow.document.activeElement === firstElement) {
                        hideAndManageFocus();
                        return;
                    }

                    // if user press Tab
                    if (contentWindow.document.activeElement === lastElement) {
                        hideAndManageFocus();
                        return;
                    }
                };
            }

            function hideAndManageFocus() {
                MW.$("#notifications-anchor").focus();
                popupFunctions.hide();
            }

            MW.Dialog = AJS.InlineDialog(MW.$("#" + id + "-anchor"), id + '-miniview', function(content, trigger, showPopup) {

                if (MW.$(content).children().length === 0) {
                   var notificationsMiniviewIframe = MW.$('<iframe id="' + id + '-miniview-iframe" src="" frameborder="0"></iframe>');
                   notificationsMiniviewIframe.attr("src", themeSwitcher ? themeSwitcher.toThemeUrl(url, window.location.origin) : url); // jshint ignore:line
                    MW.$(content).append(notificationsMiniviewIframe);
                } else {
                    var unreadMsg = JSON.stringify({unread: displayNumber}),
                        contentWindow = MW.$('#' + id + '-miniview-iframe')[0].contentWindow;
                    contentWindow.postMessage(unreadMsg, originTarget);

                }

                hideOpenMenuItems();
                showPopup();

            }, {
                width: 500,
                height: 520,
                hideDelay: null,
                initCallback: initCallback,
                hideCallback: hideCallback,
                noBind: true,
                container: MW.$('#' + id + '-anchor').parent(),
                calculatePositions: function() {
                    var $anchor = MW.$('#' + id + '-anchor');
                    var $nav = $anchor.closest('nav');
                    var $popup = MW.$('#inline-dialog-' + id + '-miniview');
                    var navPaddings = parseInt($nav.css('padding-top')) + parseInt($nav.css('padding-bottom'));

                    var arrowPosition = {
                        left: ($anchor.offset().left - $popup.offset().left) + ($anchor.outerWidth() / 2),
                        top: -8
                    };

                    var popupPosition = {
                        top: $nav.outerHeight() - navPaddings,
                        right: 0,
                        left: 'auto'
                    };

                    return {
                        popupCss: popupPosition,
                        arrowCss: arrowPosition
                    };
                }
            });

            MW.Tasks = (function() {

                var dialogWidth = 300;
                var dialogPadding = 20;
                var arrowWidth = 16;
                var flyout;

                var $userMenuTrigger = $("#user-menu-link");
                var userMenuSelector = "#user-menu-link-content";
                var $userMenu = $(userMenuSelector);
                var myTaskLinkSelector = "#view-mytasks-link";
                var $myTasksLink = $userMenu.find(myTaskLinkSelector);
                var myTasksLinkFullSelector = userMenuSelector + ' ' + myTaskLinkSelector;
                if(!$myTasksLink.selector) {
                    $myTasksLink.selector = myTasksLinkFullSelector;
                    // selector property has been removed in jquery version 3 and inlineDialog uses it internally.
                    // this can be removed when we start using inlineDialog2 or some other method which does not rely on
                    // this property.
                }

                var dialogLoadOverride = function (content, trigger, showPopup) {
                    var html = MyWork.Templates.Anchor.tasksFeatureDiscovery({
                        tasksUrl: AJS.contextPath() + "/plugins/inlinetasks/mytasks.action"
                    });
                    content.html(html);
                    content.find("#mw-tasks-discovery-dismiss").click(function (){
                        flyout.hide();
                    });
                    showPopup();
                };

                var closeAndDiscoverMyTasks = function() {
                    MW.Dialog.hide();

                    var isProfileMenuOpen = function () {
                        return $userMenu.is(":visible");
                    };

                    if (!isProfileMenuOpen()) {
                        $userMenuTrigger.trigger("aui-button-invoke");
                    }

                    var closeFeatureDiscovery = function () {
                        flyout.hide();
                    };

                    $userMenu.one("aui-dropdown2-hide", closeFeatureDiscovery);

                    flyout = AJS.InlineDialog($myTasksLink, 'my-tasks-discovery', dialogLoadOverride, {
                        hideCallback:function() {
                            flyout.unbind("click focusin mousedown", preventUserProfileClose);
                            $userMenu.unbind("aui-dropdown2-hide", closeFeatureDiscovery);
                            if (isProfileMenuOpen()) {
                                $userMenuTrigger.trigger("aui-button-invoke");
                            }
                            MW.$("#inline-dialog-my-tasks-discovery").remove();
                        },
                        gravity: 'w',
                        useLiveEvents:true,
                        width: dialogWidth,
                        noBind: true
                    });

                    $userMenu.find(".user-item.active").removeClass("active");
                    $myTasksLink.addClass("active");
                    $myTasksLink.focus();

                    var preventUserProfileClose = function (e) {
                        // For the time being, this is the only way to prevent
                        // clicks inside the flyout from closing the user menu dialog2
                        e.stopPropagation();
                    };

                    flyout.on("click focusin mousedown", preventUserProfileClose);

                    flyout.show();
                };

                return {
                    closeAndDiscoverMyTasks: closeAndDiscoverMyTasks
                };
            })();

            // Handle opening the dialog ourselves so the trigger can act as a toggle
            MW.$("#" + id + "-anchor").click(function(e) {
                e.preventDefault();
                if (MW.$('#' + id + '-miniview-iframe').is(':visible')) {
                    MW.Dialog.hide();
                } else {
                    MW.Dialog.show();
                }
            });

            if (showMiniview) {
                MW.$("#" + id + "-anchor").click();
            }
        }

        function setupAnchors()
        {
            makeAnchor();
            createIFrame();
        }

        return {
            setupAnchors: setupAnchors,
            updateNotificationCount: updateNotificationCount
        };
    }();

    MW.MV.AnchorManager.setupAnchors();
    var anchorUtil = new MW.AnchorUtil(MW.$, contextPath, MW.MV.AnchorManager.updateNotificationCount);
    anchorUtil.setupAnchors();

    MW.$("#notifications-anchor").click(function () {
        AJS.trigger('analytics', { name: 'mywork.host.button.clicked.notifications', data: {} });
        MW.MV.AnchorManager.updateNotificationCount(0);
    });

    var handleVisibilityChange = function () {
        if (document.hidden) {
            anchorUtil.stopRequests(true);
        } else  {
            anchorUtil.startRequests();
        }
    };
    document.addEventListener("visibilitychange", handleVisibilityChange, false);

    MW.$('body').click(function () {
        anchorUtil.startRequests();
    });
});
