AJS.EventQueue = AJS.EventQueue || [];
MW.MAX_RESULTS = parseInt(MW.getParameterByNameFromHash("max") || "0", 10) || 30;

MW.$(function () {
    // We bind global events across cards to this object.
    var globalEvents = _.extend({}, Backbone.Events);
    MW.globalEvents = globalEvents;

    MW.contextPath = MW.$('meta[name=context-path]').attr("content");
    MW.configurationVersion = MW.$("meta[name='mw-configuration-version']").attr('content');
    MW.setRequestTime(MW.$("meta[name='mw-request-time']").attr('content'));

    // Initialize our collections.
    MW.Configurations = new MW.ConfigurationCollection();
    MW.Notifications = new MW.NotificationCollection([], {globalEvents: globalEvents, config: MW.Configurations});
    MW.Tasks = new MW.TaskCollection([]);
    MW.KeyboardShortcuts = new MW.KeyboardShortcuts(globalEvents);

    MW.CardAnimation = new MW.CardTransitions({globalEvents: globalEvents});

    MW.AppView = Backbone.View.extend({
        el: MW.$("#mw-container"),
        count: 0,

        render: function() {},

        initialize: function(options) {
            var that = this;
            this.globalEvents = options.globalEvents;

            this.renderNotificationMain();

            var userHasInteractedWithTaskWB = (MW.$("meta[name='mw-user-has-interacted-with-deprecated-task-mw']").attr('content') === 'true');
            var userHasTasksToMigrate = (MW.$("meta[name='mw-user-has-tasks-to-migrate']").attr('content') === 'true');
            if (!userHasTasksToMigrate || userHasInteractedWithTaskWB) {
                MW.$(".mw-toggles.aui-toolbar2-inner").remove();
            } else {
                this.renderDeprecatedTaskMain();
            }

            MW.Notifications.bind('all', this.render, this);
            MW.Notifications.bind('open', this.openNotification, this);
            MW.Tasks.bind('all', this.render, this);

            MW.onJsonMessage(function(data) {
                if (data.unread) {
                    fetchAll(data.unread);
                } else if (data.markAllRead) {
                    that.globalEvents.trigger("markAllRead");
                }
            });

            function fetchAll(unread) {
                // When we open the miniview, fetch ALL of the notifications as we want to re-render the entire div
                MW.Notifications.fetcher({
                    success: function() {

                        AJS.EventQueue.push({name:'notificationtabopened',
                            properties:{'tasks': MW.Tasks.length, 'unread': unread, 'loadedBy': MW.App.parseView()}});

                        that.gotoInitial(unread);
                    }
                });
                MW.Tasks.fetchOnce();
                that.globalEvents.trigger("reopenMiniview");
            }

            MW.Configurations.fetchOnce().done(function() {
                if (MW.parentConfig.preload) return;
                MW.Notifications.fetcher();
                MW.Tasks.fetchOnce();
            });

            MW.Tasks.bind('destroy', function(task) {
                MW.Notifications.setStatusByGlobalId(task.get('globalId'), '');
            });
        },

        renderNotificationMain: function() {
          var notificationMainView = new MW.NotificationMainView({globalEvents: this.globalEvents});
            MW.$("#mw-container").append(notificationMainView.render().el);
        },

        renderDeprecatedTaskMain: function() {
            var taskMainView = new MW.DeprecatedTasksView({globalEvents: globalEvents});
            MW.$("#mw-container").append(taskMainView.render().el);
        },

        gotoInitial: function() {
            if (MW.parentConfig.unread == "0" && MW.Cookie.load()) {
                if (!MW.$('.mw-tasks').is(':visible')) {
                    MW.App.gotoTasks(1);
                }
            } else {
                if (!MW.$('.mw-notifications').is(':visible')) {
                    MW.App.gotoMain(1);
                }
            }
        },

        gotoTasks: function() {
            MW.Router.navigateToTasks();
            this.globalEvents.trigger("showTaskCard", 1);

            if (!this.gotoTasksOnce) {
                AJS.EventQueue.push({name:'tasktabopened', 'loadedBy': MW.App.parseView() });
                this.gotoTasksOnce = true;
            }
            MW.Cookie.save(true);
        },

        gotoMain: function() {
            MW.Router.navigateToMain();
            this.globalEvents.trigger("showNotificationCard", 1);
            MW.Cookie.save(false);
        },

        parseView: function() {
            if (window.top === window.self) {
                return "homepage";
            }
            else if (window.location.href.indexOf("anchorTarget=_blank") != -1) {
                return "chrome";
            }
        },

        scrollToFocusedElement: function(container, parent, focusedElemOverride) {
            var mainContainer = MW.$(container),
                $parent = MW.$(parent || container);
            var focusedElem = focusedElemOverride || MW.$(mainContainer).find(".focused");

            if (!!focusedElem.length) {
                var offset = mainContainer.scrollTop() + focusedElem.position().top - $parent.position().top;
                mainContainer.scrollTop(Math.max(mainContainer.scrollTop(), offset - mainContainer.height() + focusedElem.outerHeight(true)));
                mainContainer.scrollTop(Math.min(mainContainer.scrollTop(), offset));
            }
        },

        scrollToFocusedDrilldown: function() {
            this.scrollToFocusedElement(".mw-drilldown-container", ".mw-notification-drilldown");
        },

        scrollToFocusedMain: function() {
            this.scrollToFocusedElement(".mw-notifications-list");
        },

        scrollToDrilldownHeader: function() {
            // Note: 2nd argument ('parent') is redundant...but we need to pass in "focusedElemOverride"
            this.scrollToFocusedElement(".mw-drilldown-container", ".mw-drilldown-container", MW.$(".mw-drilldown-header"));
        },

        openNotification: function(notification) {
            AJS.EventQueue.push({name:'mywork.notificationlinkopened', properties: notification.toEventJSON()});
        }
    });

    var startApp = function() {
        MW.App = new MW.AppView({globalEvents: globalEvents});

        MW.Router = new MW.Router({globalEvents: globalEvents});

        // This must be done _after_ constructing the router
        Backbone.history.start({
            // pushState: true, // Can't use push state here as it causes multiple histories :(
            // This _must_ end in a slash
            // (?:\/m)? is there to match for mobile routes
            root: MW.contextPath + '/plugins/servlet/' +
                window.location.pathname.match(/servlet\/([^\/]*(?:\/m)?)?\/?/)[1] + "/"
        });
    };

    MW.parentConfig = {};

    if (window.top != window.self) {
        MW.$(".miniview-page").addClass("iframe");
        MW.$("body").bind("click", function(event) {
            event.stopPropagation(); // stops the event bubbling to the parent window
        });

        MW.onJsonMessage(function(data, event) {
            if (data.parentConfig && event.source === parent) {
                MW.parentConfig = data.parentConfig;
                startApp();
            }
        });
        parent.postMessage("getParentConfig", "*");
    } else {
        startApp();
    }
});
