MW.AnchorUtil = function ($, contextPath, callback) {
    var initialRefreshInterval = 30000, // millis
        refreshInterval = initialRefreshInterval,
        intervalId,
        newNotificationCountUrl = contextPath + "/rest/mywork/latest/status/notification/count";

    var lastActivityMs = new Date().getTime();
    var maxTimeout = 5 * 60 * 1000;
    var inactivity = 1000 * 60 * 5;
    var multiplier = 1.25;
    var pollingDelay = 0;

    function stopRequests(resetRefreshInterval) {
        window.clearInterval(intervalId);
        intervalId = undefined;
        if (resetRefreshInterval === true) {
           refreshInterval = initialRefreshInterval;
        }
    }

    /**
     * Has the user interacted with the page in the last 5 minutes.
     */
    function isActive() {
        return (new Date().getTime() - lastActivityMs) < inactivity;
    }

    function startRequests() {
        if (!isActive() || !intervalId) {
            resetTimeout();
        }
        lastActivityMs = new Date().getTime();
    }

    function resetTimeout() {
        if (intervalId) {
            clearTimeout(intervalId);
        }
        intervalId = setTimeout(function() {
            updateAnchors();
        }, pollingDelay = calcTimeout(pollingDelay));
    }

    function updateTimeout(timeout, newMaxTimeout) {
        var newTimeout = timeout * 1000;
        maxTimeout = newMaxTimeout * 1000 || maxTimeout;

        if (newTimeout && newTimeout != refreshInterval) {
            refreshInterval = newTimeout;
            startRequests();
        }
    }

    /**
     * Calculate a timeout, depending on whether the page is 'active' or not.
     * We can/should possibly use the number of messages the user has received to feed into the multiplier.
     */
    function calcTimeout(pollingDelay) {
        return Math.min(isActive() ? refreshInterval : pollingDelay * multiplier, maxTimeout);
    }

    function updateAnchors(pageId)
    {
        //console.log("Updating anchors");
        MW.$.getJSON(newNotificationCountUrl + ((pageId) ? "?pageid=" + pageId : ""), function(countJson) {
            updateTimeout(countJson.timeout, countJson.maxTimeout);
            var newNotificationCount = countJson.count;
            callback(newNotificationCount);
        });
        resetTimeout();
    }

    function setupAnchors()
    {
        var isDocumentAPageOrBlogPost = AJS && AJS.Meta && AJS.Meta.get && (AJS.Meta.get('content-type') === 'page' || AJS.Meta.get('content-type') === 'blogpost');
        if (isDocumentAPageOrBlogPost) {
            updateAnchors(AJS.Meta.get('page-id'));
        } else {
            updateAnchors();
        }
        startRequests();
    }

    return {
        setupAnchors: setupAnchors,
        startRequests: startRequests,
        stopRequests: stopRequests,
        updateAnchors: updateAnchors
    };
};
