var MW = MW || { $ : jQuery };

MW.Cookie = (function() { return {
    name: 'mywork.tab.tasks',
    save: function(tasksOn) {
        this.setCookie(this.name, tasksOn, 7);
    },
    load: function() {
        return this.getCookie(this.name) == 'true';
    },
    setCookie: function(name, value, days) {
        var expires = "";
        if (days) {
            var date = new Date();
            date.setTime(date.getTime()+ (days * 24 * 60 * 60 * 1000));
            expires = "; expires=" + date.toGMTString();
        }
        document.cookie = name + "=" + value + expires + "; path=/";
    },
    getCookie: function(name) {
        var nameEQ = name + "=";
        var ca = document.cookie.split('; ');
        for(var i=0; i < ca.length; i++) {
            if (ca[i].indexOf(nameEQ) === 0) {
                return ca[i].substring(nameEQ.length, ca[i].length);
            }
        }
        return null;
    }
};})();


MW.Slide = {
    FROM_RIGHT : "from-right",
    FROM_LEFT : "from-left"
};

MW.CardTransitions = (function(options){
    var globalEvents;

    var initialize = function(options) {
        globalEvents = options.globalEvents;
    };

    var showCard = function(cardToShow, slideType, slideTime, callback){
        slideTime = slideTime || 300;
        var showDirection, hideDirection;
        if (slideType === MW.Slide.FROM_RIGHT) {
            showDirection = "right";
            hideDirection = "left";
        } else if (slideType === MW.Slide.FROM_LEFT) {
            showDirection = "left";
            hideDirection = "right";
        } else {
            showDirection = hideDirection = "";
        }

        var cardToHide = MW.$(".showing");
        MW.$(".transition-finished").removeClass("transition-finished");
        setTimeout(function(){
            globalEvents.trigger('blockKeyboardShortcut');

            // Transition classes for webdriver tests
            cardToShow.addClass("showing");
            cardToShow.show();
            setTimeout(function(){
                globalEvents.trigger('unblockKeyboardShortcut');
                // MW.App.scrollToFocusedMain(); for notifications!
                cardToShow.addClass('transition-finished');
            }, slideTime);

            // This can happen in Firefox on initial double-load
            if (cardToHide.length > 0 && cardToHide[0] == cardToShow[0]) {
                if (callback) {
                    callback();
                }
                return;
            }
            // Hide the currently visible card
            cardToHide.removeClass("showing");
            cardToHide.hide();
            setTimeout(function(){
                globalEvents.trigger('cleanupNestedCard');

                if (callback) {
                    callback();
                }
            }, slideTime);
        });
    };

    initialize(options);

    return {
        showCard: showCard
    };
});