var MW = MW || { $ : jQuery };
/**
 * Most of the animation/slidy stuff for the mobile cards/overlays
 * Seems like we need to setTimeout 100ms for animations to work
 */
MW.Slide = {
    FROM_RIGHT : "from-right",
    FROM_LEFT : "from-left"
};

MW.CardTransitions = (function(options){
    var globalEvents;

    var initialize = function(options) {
        globalEvents = options.globalEvents;
    };

    var showCard = function(cardToShow, slideType, callback){

        var cardToHide = $(".showing");
        if (cardToHide[0] === cardToShow[0]) {
            // We're trying to go from a card to itself...
            callback && callback();
            return;
        }

        var showCardClass, hideCardClass;
        if (slideType === MW.Slide.FROM_RIGHT) {
            showCardClass = "off-right";
            hideCardClass = "off-left";
        } else if (slideType === MW.Slide.FROM_LEFT) {
            showCardClass = "off-left";
            hideCardClass = "off-right";
        } else {
            showCardClass = hideCardClass = "";
        }

        if(cardToHide.length > 0) {
            cardToShow.removeClass('transition-finished');
            cardToShow.addClass(showCardClass);
        }
        cardToHide.removeClass("showing");
        cardToShow.removeClass("hidden");
        setTimeout(function(){
            // Transition classes for webdriver tests
            cardToShow.addClass("showing").removeClass('hiding');
            cardToShow.one('webkitTransitionEnd', function(){
                cardToShow.addClass('transition-finished');
            });

            // Hide the currently visible card
            cardToHide.addClass("hiding").removeClass('transition-finished');
            cardToHide.one('webkitTransitionEnd', function(){

                cardToHide.addClass("hidden");
                // If going from nested to nested (atm drilldown -> taskdetail)
                // assume the main cards need to be hidden, and "swap" which one is off-left and which one is just hidden
                if (cardToHide.hasClass("nested-card") && cardToShow.hasClass("nested-card")) {
                    MW.$(".mw-list-container").removeClass("showing").toggleClass("off-left").hide();
                }

                if (cardToHide.hasClass("nested-card")) {
                    globalEvents.trigger("cleanupNestedCard");
                }

                if (callback) {
                    callback();
                }
            });

            // Actual transition
            cardToShow.removeClass(showCardClass);
            cardToHide.addClass(hideCardClass);
            if(cardToHide.length === 0) {
                if (callback) {
                    callback();
                }
            }
        },100);
    };

    initialize(options);

    return {
        showCard: showCard,
        showCardInstant: function(cardToShow, slideType, slideTime) {
            return showCard(cardToShow, slideType, function() {
                if (slideTime === 0) {
                    cardToShow.addClass('transition-finished');
                }
            });
        }
    };
});

// Show/Hide the respective cards - all the slide logic above does not guarantee that the cards are visible
MW.showTaskMainCard = function() {
    MW.$("#inner-container .mw-list-container.mw-task").show();
    MW.$("#inner-container .mw-list-container.mw-notification").hide();
};

MW.showNotificationMainCard = function() {
    MW.$("#inner-container .mw-list-container.mw-notification").show();
    MW.$("#inner-container .mw-list-container.mw-task").hide();
};

// Slide the top overlay (eg. add/delete task) from the top
MW.showTopOverlay = function(name){
    setTimeout(function(){
        var $topOverlay = MW.$(".mw-mobile-overlay." + name);
        $topOverlay.removeClass("completely-hidden");
        $topOverlay.one('webkitTransitionEnd', function(){
            $topOverlay.addClass('completely-visible');
        });
        // Now kick off the transition
        $topOverlay.removeClass("off-top");

        // Make sure overlay is visible
        MW.$('body').scrollTop(0);

        // Add overlay to make overlay modal
        MW.$('#inner-container').append('<div id="mw-modal-overlay"></div>');
    }, 100);
};

// Remove top overlays (optionally specify a specific one by classname)
MW.removeTopOverlay = function(name){
    var className = ".mw-mobile-overlay";
    if (name) {
        className = className + "." + name;
    }
    var $overlay = MW.$(className);
    $overlay.find('textarea').blur();
    // Without the timeout the page still goes white
    setTimeout(function() {
        $overlay.remove();
    }, 0);
    MW.$("#mw-modal-overlay").remove();
};

// Slide the top overlay off the top
MW.hideTopOverlay = function(name, isRemove){
    setTimeout(function(){
        var $topOverlay = MW.$(".mw-mobile-overlay." + name);
        $topOverlay.removeClass("completely-visible");
        $topOverlay.one('webkitTransitionEnd', function(){
            $topOverlay.addClass('completely-hidden');
        });
        // Now kick off the transition
        $topOverlay.addClass("off-top");
        MW.$("#mw-modal-overlay").remove();
        if (isRemove) {
            $topOverlay.bind("webkitTransitionEnd", function(){
                $topOverlay.unbind("webkitTransitionEnd");
                MW.removeTopOverlay();
            });
        }
    }, 100);
};

// Slide the top overlay off the top, and then remove when transition ends
// Note: if you just want to remove the top overlay without first sliding, call MW.removeTopOverlay() instead
MW.hideThenRemoveTopOverlay = function(name){
    MW.hideTopOverlay(name, true);
};

// Hide the Confluence container as we want our own containers to be visible
MW.hideConfluenceMobileDashboard = function(){
    MW.$("#inner-container .container").hide();

    // Add a class to indicate that we are now dealing with "my work" containers
    MW.$("#inner-container").addClass("mw-mobile-container");
};

// Cleanup all of the containers and classes we've added
MW.cleanupMWElements = function(){
    // TODO - this line can be removed once we're on the Confluence version of the CONFDEV-9960 fix.
    // Show confluence stuff
    MW.$("#inner-container .container").show();

    // Remove our own containers
    MW.$("#inner-container .mw-list-container").remove();
    MW.$("#inner-container .nested-card").remove();
    MW.$("#inner-container .mw-mobile-overlay").remove();
    MW.$("#inner-container").removeClass("mw-mobile-container");
};

/**
 * Overrides a function on an object, and passing a callback to the new version to be invoked at will.
 */
MW.hackFunction = function(that, f, override) {
    var old = that[f];
    that[f] = function() {
        var args = arguments;
        var context = this;
        override.call(context, function() {
            old.apply(context, args);
        });
    };
};

// Mobile has no concept of shortcuts, so provide dummy object
MW.KeyboardShortcuts = {
    changeContext: function(){},
    setupContext: function(){
        return {
            cleanup: function(){},
            addShortcut: function(){}
        };
    }
};
