/**
 * Dark features are features that can enabled and disabled per user via a feature key. Their main use is to allow
 * in-development features to be rolled out to production in a low-risk fashion.
 * @module confluence/dark-features
 */
define('confluence/dark-features', [
    'confluence/meta',
    'jquery'
], function(
    Meta,
    $
) {
    'use strict';

    var featuresStr = Meta.get('enabled-dark-features');
    var featuresArr = featuresStr ? featuresStr.split(',') : [];
    var features = {};
    var SUFFIX_DISABLE = '.disable';

    $.each(featuresArr, function() {
        features[this] = true;
    });

    return {
        isEnabled: function(key) {
            return !!features[key] && !features[key + SUFFIX_DISABLE];
        },

        enable: function(key) {
            if (!key) {
                return;
            }

            features[key] = true;
            features[key + SUFFIX_DISABLE] && delete features[key + SUFFIX_DISABLE];
        },

        disable: function(key) {
            if (!key) {
                return;
            }

            features[key] !== undefined && delete features[key];
            features[key + SUFFIX_DISABLE] !== undefined && delete features[key + SUFFIX_DISABLE];
        },

        getAllEnabled: function() {
            return featuresArr;
        }
    };
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence/dark-features', 'AJS.DarkFeatures');
