/* eslint-disable @atlassian/confluence-server/matching-tests, @atlassian/confluence-server/web-resource-audit */
/**
 * @module confluence/captcha-handler
 */
define('confluence/captcha-handler', [
    'jquery',
    'ajs'
], function(
    $,
    AJS
) {
    'use strict';

    // Function to update errors
    function updateErrors(message) {
        var errorMessageItem;
        var actionErrorsElement = document.querySelector('.aui-message-error ul');

        if (actionErrorsElement) {
            actionErrorsElement.innerHTML = '';
            errorMessageItem = document.createElement('li');
            errorMessageItem.textContent = message;
            actionErrorsElement.appendChild(errorMessageItem);
        }
    }

    // Function to handle captcha load
    function handleCaptchaLoad() {
        updateErrors(AJS.I18n.getText('login.elevatedsecuritycheck.required'));
    }

    // Function to handle captcha error
    function handleCaptchaError() {
        updateErrors(AJS.I18n.getText('login.elevatedsecuritycheck.retry.later'));
    }

    // Function to bind error and load events to captchaImg
    function bindingEvent(captchaImg) {
        $(captchaImg).on('error', handleCaptchaError);
        $(captchaImg).on('load', handleCaptchaLoad);
    }

    // Return public methods
    return {
        bindingEvent: bindingEvent
    };
});
