/*!
 * jsUri
 * https://github.com/derek-watson/jsUri
 *
 * Copyright 2012, Derek Watson
 * Released under the MIT license.
 *
 * Includes parseUri regular expressions
 * http://blog.stevenlevithan.com/archives/parseuri
 * Copyright 2007, Steven Levithan
 * Released under the MIT license.
 *
 * Modified by Atlassian
 */
!function(){function decode(s){return s=(s=decodeURIComponent(s)).replace("+"," ")}function parseQuery(str){var i,ps,p,kvp,k,v,pairs=[];if(null==str||""===str)return pairs;for(0===str.indexOf("?")&&(str=str.substring(1)),ps=str.toString().split(/[&;]/),i=0;i<ps.length;i++)k=(kvp=(p=ps[i]).split("="))[0],v=-1===p.indexOf("=")?null:null===kvp[1]?"":kvp[1],pairs.push([k,v]);return pairs}function Uri(str){this.uriParts=function(str){var m=/^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@\/]*)(?::([^:@\/]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/.exec(str||""),parts={};return["source","protocol","authority","userInfo","user","password","host","port","relative","path","directory","file","query","anchor"].forEach(function(key,i){parts[key]=m[i]||""}),parts}(str),this.queryPairs=parseQuery(this.uriParts.query),this.hasAuthorityPrefixUserPref=null}Array.prototype.forEach||(Array.prototype.forEach=function(fn,scope){for(var i=0,len=this.length;i<len;++i)fn.call(scope||this,this[i],i,this)}),["protocol","userInfo","host","port","path","anchor"].forEach(function(key){Uri.prototype[key]=function(val){return void 0!==val&&(this.uriParts[key]=val),this.uriParts[key]}}),Uri.prototype.hasAuthorityPrefix=function(val){return void 0!==val&&(this.hasAuthorityPrefixUserPref=val),null===this.hasAuthorityPrefixUserPref?-1!==this.uriParts.source.indexOf("//"):this.hasAuthorityPrefixUserPref},Uri.prototype.query=function(val){var i,param,s="";for(void 0!==val&&(this.queryPairs=parseQuery(val)),i=0;i<this.queryPairs.length;i++)param=this.queryPairs[i],s.length>0&&(s+="&"),null===param[1]?s+=param[0]:s+=param.join("=");return s.length>0?"?"+s:s},Uri.prototype.getQueryParamValue=function(key){var param,i;for(i=0;i<this.queryPairs.length;i++)if(param=this.queryPairs[i],decode(key)===decode(param[0]))return param[1]},Uri.prototype.getQueryParamValues=function(key){var i,param,arr=[];for(i=0;i<this.queryPairs.length;i++)param=this.queryPairs[i],decode(key)===decode(param[0])&&arr.push(param[1]);return arr},Uri.prototype.deleteQueryParam=function(key,val){var i,param,keyMatchesFilter,valMatchesFilter,arr=[];for(i=0;i<this.queryPairs.length;i++)keyMatchesFilter=decode((param=this.queryPairs[i])[0])===decode(key),valMatchesFilter=decode(param[1])===decode(val),(1===arguments.length&&!keyMatchesFilter||2===arguments.length&&!keyMatchesFilter&&!valMatchesFilter)&&arr.push(param);return this.queryPairs=arr,this},Uri.prototype.addQueryParam=function(key,val,index){return 3===arguments.length&&-1!==index?(index=Math.min(index,this.queryPairs.length),this.queryPairs.splice(index,0,[key,val])):arguments.length>0&&this.queryPairs.push([key,val]),this},Uri.prototype.replaceQueryParam=function(key,newVal,oldVal){var i,param,index=-1;if(3===arguments.length){for(i=0;i<this.queryPairs.length;i++)if(decode((param=this.queryPairs[i])[0])===decode(key)&&decodeURIComponent(param[1])===decode(oldVal)){index=i;break}this.deleteQueryParam(key,oldVal).addQueryParam(key,newVal,index)}else{for(i=0;i<this.queryPairs.length;i++)if(decode((param=this.queryPairs[i])[0])===decode(key)){index=i;break}this.deleteQueryParam(key),this.addQueryParam(key,newVal,index)}return this},["protocol","hasAuthorityPrefix","userInfo","host","port","path","query","anchor"].forEach(function(key){var method="set"+key.charAt(0).toUpperCase()+key.slice(1);Uri.prototype[method]=function(val){return this[key](val),this}}),Uri.prototype.scheme=function(){var s="";return this.protocol()?(s+=this.protocol(),this.protocol().indexOf(":")!==this.protocol().length-1&&(s+=":"),s+="//"):this.hasAuthorityPrefix()&&this.host()&&(s+="//"),s},Uri.prototype.origin=function(){var s=this.scheme();return this.userInfo()&&this.host()&&(s+=this.userInfo(),this.userInfo().indexOf("@")!==this.userInfo().length-1&&(s+="@")),this.host()&&(s+=this.host(),this.port()&&(s+=":"+this.port())),s},Uri.prototype.toString=function(){var s=this.origin();return this.path()?s+=this.path():this.host()&&(this.query().toString()||this.anchor())&&(s+="/"),this.query().toString()&&(0!==this.query().toString().indexOf("?")&&(s+="?"),s+=this.query().toString()),this.anchor()&&(0!==this.anchor().indexOf("#")&&(s+="#"),s+=this.anchor()),s},Uri.prototype.clone=function(){return new Uri(this.toString())},define("confluence/jsUri",function(){return Uri})}();