/*!
 * Includes BabySitter
 * https://github.com/marionettejs/backbone.babysitter/
 *
 * Includes Wreqr
 * https://github.com/marionettejs/backbone.wreqr/
 */
!function(root){define("marionette",["backbone","underscore"],function(Backbone,_){return root.Marionette=root.Mn=function(root,Backbone,_){"use strict";(function(Backbone,_){var previousChildViewContainer=Backbone.ChildViewContainer;Backbone.ChildViewContainer=function(Backbone,_){var Container=function(views){this._views={},this._indexByModel={},this._indexByCustom={},this._updateLength(),_.each(views,this.add,this)};_.extend(Container.prototype,{add:function(view,customIndex){var viewCid=view.cid;return this._views[viewCid]=view,view.model&&(this._indexByModel[view.model.cid]=viewCid),customIndex&&(this._indexByCustom[customIndex]=viewCid),this._updateLength(),this},findByModel:function(model){return this.findByModelCid(model.cid)},findByModelCid:function(modelCid){var viewCid=this._indexByModel[modelCid];return this.findByCid(viewCid)},findByCustom:function(index){var viewCid=this._indexByCustom[index];return this.findByCid(viewCid)},findByIndex:function(index){return _.values(this._views)[index]},findByCid:function(cid){return this._views[cid]},remove:function(view){var viewCid=view.cid;return view.model&&delete this._indexByModel[view.model.cid],_.any(this._indexByCustom,function(cid,key){if(cid===viewCid)return delete this._indexByCustom[key],!0},this),delete this._views[viewCid],this._updateLength(),this},call:function(method){this.apply(method,_.tail(arguments))},apply:function(method,args){_.each(this._views,function(view){_.isFunction(view[method])&&view[method].apply(view,args||[])})},_updateLength:function(){this.length=_.size(this._views)}});var methods=["forEach","each","map","find","detect","filter","select","reject","every","all","some","any","include","contains","invoke","toArray","first","initial","rest","last","without","isEmpty","pluck","reduce"];return _.each(methods,function(method){Container.prototype[method]=function(){var args=[_.values(this._views)].concat(_.toArray(arguments));return _[method].apply(_,args)}}),Container}(0,_),Backbone.ChildViewContainer.VERSION="0.1.7",Backbone.ChildViewContainer.noConflict=function(){return Backbone.ChildViewContainer=previousChildViewContainer,this},Backbone.ChildViewContainer})(Backbone,_),function(Backbone,_){var CommandStorage,Channel,previousWreqr=Backbone.Wreqr,Wreqr=Backbone.Wreqr={};Backbone.Wreqr.VERSION="1.3.3",Backbone.Wreqr.noConflict=function(){return Backbone.Wreqr=previousWreqr,this},Wreqr.Handlers=function(Backbone,_){var Handlers=function(options){this.options=options,this._wreqrHandlers={},_.isFunction(this.initialize)&&this.initialize(options)};return Handlers.extend=Backbone.Model.extend,_.extend(Handlers.prototype,Backbone.Events,{setHandlers:function(handlers){_.each(handlers,function(handler,name){var context=null;_.isObject(handler)&&!_.isFunction(handler)&&(context=handler.context,handler=handler.callback),this.setHandler(name,handler,context)},this)},setHandler:function(name,handler,context){var config={callback:handler,context:context};this._wreqrHandlers[name]=config,this.trigger("handler:add",name,handler,context)},hasHandler:function(name){return!!this._wreqrHandlers[name]},getHandler:function(name){var config=this._wreqrHandlers[name];if(config)return function(){return config.callback.apply(config.context,arguments)}},removeHandler:function(name){delete this._wreqrHandlers[name]},removeAllHandlers:function(){this._wreqrHandlers={}}}),Handlers}(Backbone,_),Wreqr.CommandStorage=(CommandStorage=function(options){this.options=options,this._commands={},_.isFunction(this.initialize)&&this.initialize(options)},_.extend(CommandStorage.prototype,Backbone.Events,{getCommands:function(commandName){var commands=this._commands[commandName];return commands||(commands={command:commandName,instances:[]},this._commands[commandName]=commands),commands},addCommand:function(commandName,args){this.getCommands(commandName).instances.push(args)},clearCommands:function(commandName){this.getCommands(commandName).instances=[]}}),CommandStorage),Wreqr.Commands=function(Wreqr,_){return Wreqr.Handlers.extend({storageType:Wreqr.CommandStorage,constructor:function(options){this.options=options||{},this._initializeStorage(this.options),this.on("handler:add",this._executeCommands,this),Wreqr.Handlers.prototype.constructor.apply(this,arguments)},execute:function(name){name=arguments[0];var args=_.rest(arguments);this.hasHandler(name)?this.getHandler(name).apply(this,args):this.storage.addCommand(name,args)},_executeCommands:function(name,handler,context){var command=this.storage.getCommands(name);_.each(command.instances,function(args){handler.apply(context,args)}),this.storage.clearCommands(name)},_initializeStorage:function(options){var storage,StorageType=options.storageType||this.storageType;storage=_.isFunction(StorageType)?new StorageType:StorageType,this.storage=storage}})}(Wreqr,_),Wreqr.RequestResponse=function(Wreqr,_){return Wreqr.Handlers.extend({request:function(name){if(this.hasHandler(name))return this.getHandler(name).apply(this,_.rest(arguments))}})}(Wreqr,_),Wreqr.EventAggregator=function(Backbone,_){var EA=function(){};return EA.extend=Backbone.Model.extend,_.extend(EA.prototype,Backbone.Events),EA}(Backbone,_),Wreqr.Channel=(Channel=function(channelName){this.vent=new Backbone.Wreqr.EventAggregator,this.reqres=new Backbone.Wreqr.RequestResponse,this.commands=new Backbone.Wreqr.Commands,this.channelName=channelName},_.extend(Channel.prototype,{reset:function(){return this.vent.off(),this.vent.stopListening(),this.reqres.removeAllHandlers(),this.commands.removeAllHandlers(),this},connectEvents:function(hash,context){return this._connect("vent",hash,context),this},connectCommands:function(hash,context){return this._connect("commands",hash,context),this},connectRequests:function(hash,context){return this._connect("reqres",hash,context),this},_connect:function(type,hash,context){if(hash){context=context||this;var method="vent"===type?"on":"setHandler";_.each(hash,function(fn,eventName){this[type][method](eventName,_.bind(fn,context))},this)}}}),Channel),Wreqr.radio=function(Wreqr,_){var Radio=function(){this._channels={},this.vent={},this.commands={},this.reqres={},this._proxyMethods()};_.extend(Radio.prototype,{channel:function(channelName){if(!channelName)throw new Error("Channel must receive a name");return this._getChannel(channelName)},_getChannel:function(channelName){var channel=this._channels[channelName];return channel||(channel=new Wreqr.Channel(channelName),this._channels[channelName]=channel),channel},_proxyMethods:function(){_.each(["vent","commands","reqres"],function(system){_.each(messageSystems[system],function(method){this[system][method]=proxyMethod(this,system,method)},this)},this)}});var messageSystems={vent:["on","off","trigger","once","stopListening","listenTo","listenToOnce"],commands:["execute","setHandler","setHandlers","removeHandler","removeAllHandlers"],reqres:["request","setHandler","setHandlers","removeHandler","removeAllHandlers"]},proxyMethod=function(radio,system,method){return function(channelName){var messageSystem=radio._getChannel(channelName)[system];return messageSystem[method].apply(messageSystem,_.rest(arguments))}};return new Radio}(Wreqr,_),Backbone.Wreqr}(Backbone,_);var previousMarionette=root.Marionette,previousMn=root.Mn,Marionette=Backbone.Marionette={};Marionette.VERSION="2.4.2",Marionette.noConflict=function(){return root.Marionette=previousMarionette,root.Mn=previousMn,this},Backbone.Marionette=Marionette,Marionette.Deferred=Backbone.$.Deferred,Marionette.extend=Backbone.Model.extend,Marionette.isNodeAttached=function(el){return Backbone.$.contains(document.documentElement,el)},Marionette.mergeOptions=function(options,keys){options&&_.extend(this,_.pick(options,keys))},Marionette.getOption=function(target,optionName){if(target&&optionName)return target.options&&void 0!==target.options[optionName]?target.options[optionName]:target[optionName]},Marionette.proxyGetOption=function(optionName){return Marionette.getOption(this,optionName)},Marionette._getValue=function(value,context,params){return _.isFunction(value)&&(value=params?value.apply(context,params):value.call(context)),value},Marionette.normalizeMethods=function(hash){return _.reduce(hash,function(normalizedHash,method,name){return _.isFunction(method)||(method=this[method]),method&&(normalizedHash[name]=method),normalizedHash},{},this)},Marionette.normalizeUIString=function(uiString,ui){return uiString.replace(/@ui\.[a-zA-Z_$0-9]*/g,function(r){return ui[r.slice(4)]})},Marionette.normalizeUIKeys=function(hash,ui){return _.reduce(hash,function(memo,val,key){return memo[Marionette.normalizeUIString(key,ui)]=val,memo},{})},Marionette.normalizeUIValues=function(hash,ui,properties){return _.each(hash,function(val,key){_.isString(val)?hash[key]=Marionette.normalizeUIString(val,ui):_.isObject(val)&&_.isArray(properties)&&(_.extend(val,Marionette.normalizeUIValues(_.pick(val,properties),ui)),_.each(properties,function(property){var propertyVal=val[property];_.isString(propertyVal)&&(val[property]=Marionette.normalizeUIString(propertyVal,ui))}))}),hash},Marionette.actAsCollection=function(object,listProperty){var methods=["forEach","each","map","find","detect","filter","select","reject","every","all","some","any","include","contains","invoke","toArray","first","initial","rest","last","without","isEmpty","pluck"];_.each(methods,function(method){object[method]=function(){var args=[_.values(_.result(this,listProperty))].concat(_.toArray(arguments));return _[method].apply(_,args)}})};var deprecate=Marionette.deprecate=function(message,test){_.isObject(message)&&(message=message.prev+" is going to be removed in the future. Please use "+message.next+" instead."+(message.url?" See: "+message.url:"")),void 0!==test&&test||deprecate._cache[message]||(deprecate._warn("Deprecation warning: "+message),deprecate._cache[message]=!0)};deprecate._warn="undefined"!=typeof console&&(console.warn||console.log)||function(){},deprecate._cache={},Marionette._triggerMethod=function(){var splitter=/(^|:)(\w)/gi;function getEventName(match,prefix,eventName){return eventName.toUpperCase()}return function(context,event,args){var noEventArg=arguments.length<3;noEventArg&&(event=(args=event)[0]);var result,method=context["on"+event.replace(splitter,getEventName)];return _.isFunction(method)&&(result=method.apply(context,noEventArg?_.rest(args):args)),_.isFunction(context.trigger)&&(noEventArg+args.length>1?context.trigger.apply(context,noEventArg?args:[event].concat(_.drop(args,0))):context.trigger(event)),result}}(),Marionette.triggerMethod=function(event){return Marionette._triggerMethod(this,arguments)},Marionette.triggerMethodOn=function(context){return(_.isFunction(context.triggerMethod)?context.triggerMethod:Marionette.triggerMethod).apply(context,_.rest(arguments))},Marionette.MonitorDOMRefresh=function(view){function handleShow(){view._isShown=!0,triggerDOMRefresh()}function handleRender(){view._isRendered=!0,triggerDOMRefresh()}function triggerDOMRefresh(){view._isShown&&view._isRendered&&Marionette.isNodeAttached(view.el)&&_.isFunction(view.triggerMethod)&&view.triggerMethod("dom:refresh")}view.on({show:handleShow,render:handleRender})},function(Marionette){function bindFromStrings(target,entity,evt,methods){var methodNames=methods.split(/\s+/);_.each(methodNames,function(methodName){var method=target[methodName];if(!method)throw new Marionette.Error('Method "'+methodName+'" was configured as an event handler, but does not exist.');target.listenTo(entity,evt,method)})}function bindToFunction(target,entity,evt,method){target.listenTo(entity,evt,method)}function unbindFromStrings(target,entity,evt,methods){var methodNames=methods.split(/\s+/);_.each(methodNames,function(methodName){var method=target[methodName];target.stopListening(entity,evt,method)})}function unbindToFunction(target,entity,evt,method){target.stopListening(entity,evt,method)}function iterateEvents(target,entity,bindings,functionCallback,stringCallback){if(entity&&bindings){if(!_.isObject(bindings))throw new Marionette.Error({message:"Bindings must be an object or function.",url:"marionette.functions.html#marionettebindentityevents"});bindings=Marionette._getValue(bindings,target),_.each(bindings,function(methods,evt){_.isFunction(methods)?functionCallback(target,entity,evt,methods):stringCallback(target,entity,evt,methods)})}}Marionette.bindEntityEvents=function(target,entity,bindings){iterateEvents(target,entity,bindings,bindToFunction,bindFromStrings)},Marionette.unbindEntityEvents=function(target,entity,bindings){iterateEvents(target,entity,bindings,unbindToFunction,unbindFromStrings)},Marionette.proxyBindEntityEvents=function(entity,bindings){return Marionette.bindEntityEvents(this,entity,bindings)},Marionette.proxyUnbindEntityEvents=function(entity,bindings){return Marionette.unbindEntityEvents(this,entity,bindings)}}(Marionette);var errorProps=["description","fileName","lineNumber","name","message","number"];return Marionette.Error=Marionette.extend.call(Error,{urlRoot:"http://marionettejs.com/docs/v"+Marionette.VERSION+"/",constructor:function(message,options){_.isObject(message)?message=(options=message).message:options||(options={});var error=Error.call(this,message);_.extend(this,_.pick(error,errorProps),_.pick(options,errorProps)),this.captureStackTrace(),options.url&&(this.url=this.urlRoot+options.url)},captureStackTrace:function(){Error.captureStackTrace&&Error.captureStackTrace(this,Marionette.Error)},toString:function(){return this.name+": "+this.message+(this.url?" See: "+this.url:"")}}),Marionette.Error.extend=Marionette.extend,Marionette.Callbacks=function(){this._deferred=Marionette.Deferred(),this._callbacks=[]},_.extend(Marionette.Callbacks.prototype,{add:function(callback,contextOverride){var promise=_.result(this._deferred,"promise");this._callbacks.push({cb:callback,ctx:contextOverride}),promise.then(function(args){contextOverride&&(args.context=contextOverride),callback.call(args.context,args.options)})},run:function(options,context){this._deferred.resolve({options:options,context:context})},reset:function(){var callbacks=this._callbacks;this._deferred=Marionette.Deferred(),this._callbacks=[],_.each(callbacks,function(cb){this.add(cb.cb,cb.ctx)},this)}}),Marionette.Controller=function(options){this.options=options||{},_.isFunction(this.initialize)&&this.initialize(this.options)},Marionette.Controller.extend=Marionette.extend,_.extend(Marionette.Controller.prototype,Backbone.Events,{destroy:function(){return Marionette._triggerMethod(this,"before:destroy",arguments),Marionette._triggerMethod(this,"destroy",arguments),this.stopListening(),this.off(),this},triggerMethod:Marionette.triggerMethod,mergeOptions:Marionette.mergeOptions,getOption:Marionette.proxyGetOption}),Marionette.Object=function(options){this.options=_.extend({},_.result(this,"options"),options),this.initialize.apply(this,arguments)},Marionette.Object.extend=Marionette.extend,_.extend(Marionette.Object.prototype,Backbone.Events,{initialize:function(){},destroy:function(){return this.triggerMethod("before:destroy"),this.triggerMethod("destroy"),this.stopListening(),this},triggerMethod:Marionette.triggerMethod,mergeOptions:Marionette.mergeOptions,getOption:Marionette.proxyGetOption,bindEntityEvents:Marionette.proxyBindEntityEvents,unbindEntityEvents:Marionette.proxyUnbindEntityEvents}),Marionette.Region=Marionette.Object.extend({constructor:function(options){if(this.options=options||{},this._initEl=this.el=this.getOption("el"),this.el=this.el instanceof Backbone.$?this.el[0]:this.el,!this.el)throw new Marionette.Error({name:"NoElError",message:'An "el" must be specified for a region.'});this.$el=this.getEl(this.el),Marionette.Object.call(this,options)},show:function(view,options){if(this._ensureElement()){this._ensureViewIsIntact(view);var showOptions=options||{},isDifferentView=view!==this.currentView,preventDestroy=!!showOptions.preventDestroy,forceShow=!!showOptions.forceShow,isChangingView=!!this.currentView,_shouldDestroyView=isDifferentView&&!preventDestroy,_shouldShowView=isDifferentView||forceShow;if(isChangingView&&this.triggerMethod("before:swapOut",this.currentView,this,options),this.currentView&&delete this.currentView._parent,_shouldDestroyView?this.empty():isChangingView&&_shouldShowView&&this.currentView.off("destroy",this.empty,this),_shouldShowView){view.once("destroy",this.empty,this),view.render(),view._parent=this,isChangingView&&this.triggerMethod("before:swap",view,this,options),this.triggerMethod("before:show",view,this,options),Marionette.triggerMethodOn(view,"before:show",view,this,options),isChangingView&&this.triggerMethod("swapOut",this.currentView,this,options);var attachedRegion=Marionette.isNodeAttached(this.el),displayedViews=[],attachOptions=_.extend({triggerBeforeAttach:this.triggerBeforeAttach,triggerAttach:this.triggerAttach},showOptions);return attachedRegion&&attachOptions.triggerBeforeAttach&&(displayedViews=this._displayedViews(view),this._triggerAttach(displayedViews,"before:")),this.attachHtml(view),this.currentView=view,attachedRegion&&attachOptions.triggerAttach&&(displayedViews=this._displayedViews(view),this._triggerAttach(displayedViews)),isChangingView&&this.triggerMethod("swap",view,this,options),this.triggerMethod("show",view,this,options),Marionette.triggerMethodOn(view,"show",view,this,options),this}return this}},triggerBeforeAttach:!0,triggerAttach:!0,_triggerAttach:function(views,prefix){var eventName=(prefix||"")+"attach";_.each(views,function(view){Marionette.triggerMethodOn(view,eventName,view,this)},this)},_displayedViews:function(view){return _.union([view],_.result(view,"_getNestedViews")||[])},_ensureElement:function(){if(_.isObject(this.el)||(this.$el=this.getEl(this.el),this.el=this.$el[0]),!this.$el||0===this.$el.length){if(this.getOption("allowMissingEl"))return!1;throw new Marionette.Error('An "el" must exist in DOM for this region '+this.cid)}return!0},_ensureViewIsIntact:function(view){if(!view)throw new Marionette.Error({name:"ViewNotValid",message:"The view passed is undefined and therefore invalid. You must pass a view instance to show."});if(view.isDestroyed)throw new Marionette.Error({name:"ViewDestroyedError",message:'View (cid: "'+view.cid+'") has already been destroyed and cannot be used.'})},getEl:function(el){return Backbone.$(el,Marionette._getValue(this.options.parentEl,this))},attachHtml:function(view){this.$el.contents().detach(),this.el.appendChild(view.el)},empty:function(options){var view=this.currentView,preventDestroy=Marionette._getValue(options,"preventDestroy",this);if(view)return view.off("destroy",this.empty,this),this.triggerMethod("before:empty",view),preventDestroy||this._destroyView(),this.triggerMethod("empty",view),delete this.currentView,preventDestroy&&this.$el.contents().detach(),this},_destroyView:function(){var view=this.currentView;view.destroy&&!view.isDestroyed?view.destroy():view.remove&&(view.remove(),view.isDestroyed=!0)},attachView:function(view){return this.currentView=view,this},hasView:function(){return!!this.currentView},reset:function(){return this.empty(),this.$el&&(this.el=this._initEl),delete this.$el,this},destroy:function(){return this.reset(),Marionette.Object.prototype.destroy.apply(this,arguments)}},{buildRegion:function(regionConfig,DefaultRegionClass){if(_.isString(regionConfig))return this._buildRegionFromSelector(regionConfig,DefaultRegionClass);if(regionConfig.selector||regionConfig.el||regionConfig.regionClass)return this._buildRegionFromObject(regionConfig,DefaultRegionClass);if(_.isFunction(regionConfig))return this._buildRegionFromRegionClass(regionConfig);throw new Marionette.Error({message:"Improper region configuration type.",url:"marionette.region.html#region-configuration-types"})},_buildRegionFromSelector:function(selector,DefaultRegionClass){return new DefaultRegionClass({el:selector})},_buildRegionFromObject:function(regionConfig,DefaultRegionClass){var RegionClass=regionConfig.regionClass||DefaultRegionClass,options=_.omit(regionConfig,"selector","regionClass");return regionConfig.selector&&!options.el&&(options.el=regionConfig.selector),new RegionClass(options)},_buildRegionFromRegionClass:function(RegionClass){return new RegionClass}}),Marionette.RegionManager=Marionette.Controller.extend({constructor:function(options){this._regions={},this.length=0,Marionette.Controller.call(this,options),this.addRegions(this.getOption("regions"))},addRegions:function(regionDefinitions,defaults){return regionDefinitions=Marionette._getValue(regionDefinitions,this,arguments),_.reduce(regionDefinitions,function(regions,definition,name){return _.isString(definition)&&(definition={selector:definition}),definition.selector&&(definition=_.defaults({},definition,defaults)),regions[name]=this.addRegion(name,definition),regions},{},this)},addRegion:function(name,definition){var region;return region=definition instanceof Marionette.Region?definition:Marionette.Region.buildRegion(definition,Marionette.Region),this.triggerMethod("before:add:region",name,region),region._parent=this,this._store(name,region),this.triggerMethod("add:region",name,region),region},get:function(name){return this._regions[name]},getRegions:function(){return _.clone(this._regions)},removeRegion:function(name){var region=this._regions[name];return this._remove(name,region),region},removeRegions:function(){var regions=this.getRegions();return _.each(this._regions,function(region,name){this._remove(name,region)},this),regions},emptyRegions:function(){var regions=this.getRegions();return _.invoke(regions,"empty"),regions},destroy:function(){return this.removeRegions(),Marionette.Controller.prototype.destroy.apply(this,arguments)},_store:function(name,region){this._regions[name]||this.length++,this._regions[name]=region},_remove:function(name,region){this.triggerMethod("before:remove:region",name,region),region.empty(),region.stopListening(),delete region._parent,delete this._regions[name],this.length--,this.triggerMethod("remove:region",name,region)}}),Marionette.actAsCollection(Marionette.RegionManager.prototype,"_regions"),Marionette.TemplateCache=function(templateId){this.templateId=templateId},_.extend(Marionette.TemplateCache,{templateCaches:{},get:function(templateId,options){var cachedTemplate=this.templateCaches[templateId];return cachedTemplate||(cachedTemplate=new Marionette.TemplateCache(templateId),this.templateCaches[templateId]=cachedTemplate),cachedTemplate.load(options)},clear:function(){var i,args=_.toArray(arguments),length=args.length;if(length>0)for(i=0;i<length;i++)delete this.templateCaches[args[i]];else this.templateCaches={}}}),_.extend(Marionette.TemplateCache.prototype,{load:function(options){if(this.compiledTemplate)return this.compiledTemplate;var template=this.loadTemplate(this.templateId,options);return this.compiledTemplate=this.compileTemplate(template,options),this.compiledTemplate},loadTemplate:function(templateId,options){var template=Backbone.$(templateId).html();if(!template||0===template.length)throw new Marionette.Error({name:"NoTemplateError",message:'Could not find template: "'+templateId+'"'});return template},compileTemplate:function(rawTemplate,options){return _.template(rawTemplate,options)}}),Marionette.Renderer={render:function(template,data){if(!template)throw new Marionette.Error({name:"TemplateNotFoundError",message:"Cannot render the template since its false, null or undefined."});return(_.isFunction(template)?template:Marionette.TemplateCache.get(template))(data)}},Marionette.View=Backbone.View.extend({isDestroyed:!1,constructor:function(options){_.bindAll(this,"render"),options=Marionette._getValue(options,this),this.options=_.extend({},_.result(this,"options"),options),this._behaviors=Marionette.Behaviors(this),Backbone.View.call(this,this.options),Marionette.MonitorDOMRefresh(this)},getTemplate:function(){return this.getOption("template")},serializeModel:function(model){return model.toJSON.apply(model,_.rest(arguments))},mixinTemplateHelpers:function(target){target=target||{};var templateHelpers=this.getOption("templateHelpers");return templateHelpers=Marionette._getValue(templateHelpers,this),_.extend(target,templateHelpers)},normalizeUIKeys:function(hash){var uiBindings=_.result(this,"_uiBindings");return Marionette.normalizeUIKeys(hash,uiBindings||_.result(this,"ui"))},normalizeUIValues:function(hash,properties){var ui=_.result(this,"ui"),uiBindings=_.result(this,"_uiBindings");return Marionette.normalizeUIValues(hash,uiBindings||ui,properties)},configureTriggers:function(){if(this.triggers){var triggers=this.normalizeUIKeys(_.result(this,"triggers"));return _.reduce(triggers,function(events,value,key){return events[key]=this._buildViewTrigger(value),events},{},this)}},delegateEvents:function(events){return this._delegateDOMEvents(events),this.bindEntityEvents(this.model,this.getOption("modelEvents")),this.bindEntityEvents(this.collection,this.getOption("collectionEvents")),_.each(this._behaviors,function(behavior){behavior.bindEntityEvents(this.model,behavior.getOption("modelEvents")),behavior.bindEntityEvents(this.collection,behavior.getOption("collectionEvents"))},this),this},_delegateDOMEvents:function(eventsArg){var events=Marionette._getValue(eventsArg||this.events,this);events=this.normalizeUIKeys(events),_.isUndefined(eventsArg)&&(this.events=events);var combinedEvents={},behaviorEvents=_.result(this,"behaviorEvents")||{},triggers=this.configureTriggers(),behaviorTriggers=_.result(this,"behaviorTriggers")||{};_.extend(combinedEvents,behaviorEvents,events,triggers,behaviorTriggers),Backbone.View.prototype.delegateEvents.call(this,combinedEvents)},undelegateEvents:function(){return Backbone.View.prototype.undelegateEvents.apply(this,arguments),this.unbindEntityEvents(this.model,this.getOption("modelEvents")),this.unbindEntityEvents(this.collection,this.getOption("collectionEvents")),_.each(this._behaviors,function(behavior){behavior.unbindEntityEvents(this.model,behavior.getOption("modelEvents")),behavior.unbindEntityEvents(this.collection,behavior.getOption("collectionEvents"))},this),this},_ensureViewIsIntact:function(){if(this.isDestroyed)throw new Marionette.Error({name:"ViewDestroyedError",message:'View (cid: "'+this.cid+'") has already been destroyed and cannot be used.'})},destroy:function(){if(this.isDestroyed)return this;var args=_.toArray(arguments);return this.triggerMethod.apply(this,["before:destroy"].concat(args)),this.isDestroyed=!0,this.triggerMethod.apply(this,["destroy"].concat(args)),this.unbindUIElements(),this.isRendered=!1,this.remove(),_.invoke(this._behaviors,"destroy",args),this},bindUIElements:function(){this._bindUIElements(),_.invoke(this._behaviors,this._bindUIElements)},_bindUIElements:function(){if(this.ui){this._uiBindings||(this._uiBindings=this.ui);var bindings=_.result(this,"_uiBindings");this.ui={},_.each(bindings,function(selector,key){this.ui[key]=this.$(selector)},this)}},unbindUIElements:function(){this._unbindUIElements(),_.invoke(this._behaviors,this._unbindUIElements)},_unbindUIElements:function(){this.ui&&this._uiBindings&&(_.each(this.ui,function($el,name){delete this.ui[name]},this),this.ui=this._uiBindings,delete this._uiBindings)},_buildViewTrigger:function(triggerDef){var hasOptions=_.isObject(triggerDef),options=_.defaults({},hasOptions?triggerDef:{},{preventDefault:!0,stopPropagation:!0}),eventName=hasOptions?options.event:triggerDef;return function(e){e&&(e.preventDefault&&options.preventDefault&&e.preventDefault(),e.stopPropagation&&options.stopPropagation&&e.stopPropagation());var args={view:this,model:this.model,collection:this.collection};this.triggerMethod(eventName,args)}},setElement:function(){var ret=Backbone.View.prototype.setElement.apply(this,arguments);return _.invoke(this._behaviors,"proxyViewProperties",this),ret},triggerMethod:function(){var ret=Marionette._triggerMethod(this,arguments);return this._triggerEventOnBehaviors(arguments),this._triggerEventOnParentLayout(arguments[0],_.rest(arguments)),ret},_triggerEventOnBehaviors:function(args){for(var triggerMethod=Marionette._triggerMethod,behaviors=this._behaviors,i=0,length=behaviors&&behaviors.length;i<length;i++)triggerMethod(behaviors[i],args)},_triggerEventOnParentLayout:function(eventName,args){var layoutView=this._parentLayoutView();if(layoutView){var prefixedEventName=Marionette.getOption(layoutView,"childViewEventPrefix")+":"+eventName;Marionette._triggerMethod(layoutView,[prefixedEventName,this].concat(args));var childEvents=Marionette.getOption(layoutView,"childEvents"),normalizedChildEvents=layoutView.normalizeMethods(childEvents);normalizedChildEvents&&_.isFunction(normalizedChildEvents[eventName])&&normalizedChildEvents[eventName].apply(layoutView,[this].concat(args))}},_getImmediateChildren:function(){return[]},_getNestedViews:function(){var children=this._getImmediateChildren();return children.length?_.reduce(children,function(memo,view){return view._getNestedViews?memo.concat(view._getNestedViews()):memo},children):children},_getAncestors:function(){for(var ancestors=[],parent=this._parent;parent;)ancestors.push(parent),parent=parent._parent;return ancestors},_parentLayoutView:function(){var ancestors=this._getAncestors();return _.find(ancestors,function(parent){return parent instanceof Marionette.LayoutView})},normalizeMethods:Marionette.normalizeMethods,mergeOptions:Marionette.mergeOptions,getOption:Marionette.proxyGetOption,bindEntityEvents:Marionette.proxyBindEntityEvents,unbindEntityEvents:Marionette.proxyUnbindEntityEvents}),Marionette.ItemView=Marionette.View.extend({constructor:function(){Marionette.View.apply(this,arguments)},serializeData:function(){if(!this.model&&!this.collection)return{};var args=[this.model||this.collection];return arguments.length&&args.push.apply(args,arguments),this.model?this.serializeModel.apply(this,args):{items:this.serializeCollection.apply(this,args)}},serializeCollection:function(collection){return collection.toJSON.apply(collection,_.rest(arguments))},render:function(){return this._ensureViewIsIntact(),this.triggerMethod("before:render",this),this._renderTemplate(),this.isRendered=!0,this.bindUIElements(),this.triggerMethod("render",this),this},_renderTemplate:function(){var template=this.getTemplate();if(!1!==template){if(!template)throw new Marionette.Error({name:"UndefinedTemplateError",message:"Cannot render the template since it is null or undefined."});var data=this.mixinTemplateHelpers(this.serializeData()),html=Marionette.Renderer.render(template,data,this);return this.attachElContent(html),this}},attachElContent:function(html){return this.$el.html(html),this}}),Marionette.CollectionView=Marionette.View.extend({childViewEventPrefix:"childview",sort:!0,constructor:function(options){this.once("render",this._initialEvents),this._initChildViewStorage(),Marionette.View.apply(this,arguments),this.on({"before:show":this._onBeforeShowCalled,show:this._onShowCalled,"before:attach":this._onBeforeAttachCalled,attach:this._onAttachCalled}),this.initRenderBuffer()},initRenderBuffer:function(){this._bufferedChildren=[]},startBuffering:function(){this.initRenderBuffer(),this.isBuffering=!0},endBuffering:function(){var nestedViews,canTriggerAttach=this._isShown&&Marionette.isNodeAttached(this.el);this.isBuffering=!1,this._isShown&&this._triggerMethodMany(this._bufferedChildren,this,"before:show"),canTriggerAttach&&this._triggerBeforeAttach&&(nestedViews=this._getNestedViews(),this._triggerMethodMany(nestedViews,this,"before:attach")),this.attachBuffer(this,this._createBuffer()),canTriggerAttach&&this._triggerAttach&&(nestedViews=this._getNestedViews(),this._triggerMethodMany(nestedViews,this,"attach")),this._isShown&&this._triggerMethodMany(this._bufferedChildren,this,"show"),this.initRenderBuffer()},_triggerMethodMany:function(targets,source,eventName){var args=_.drop(arguments,3);_.each(targets,function(target){Marionette.triggerMethodOn.apply(target,[target,eventName,target,source].concat(args))})},_initialEvents:function(){this.collection&&(this.listenTo(this.collection,"add",this._onCollectionAdd),this.listenTo(this.collection,"remove",this._onCollectionRemove),this.listenTo(this.collection,"reset",this.render),this.getOption("sort")&&this.listenTo(this.collection,"sort",this._sortViews))},_onCollectionAdd:function(child,collection,opts){var index;if(index=void 0!==opts.at?opts.at:_.indexOf(this._filteredSortedModels(),child),this._shouldAddChild(child,index)){this.destroyEmptyView();var ChildView=this.getChildView(child);this.addChild(child,ChildView,index)}},_onCollectionRemove:function(model){var view=this.children.findByModel(model);this.removeChildView(view),this.checkEmpty()},_onBeforeShowCalled:function(){this._triggerBeforeAttach=this._triggerAttach=!1,this.children.each(function(childView){Marionette.triggerMethodOn(childView,"before:show",childView)})},_onShowCalled:function(){this.children.each(function(childView){Marionette.triggerMethodOn(childView,"show",childView)})},_onBeforeAttachCalled:function(){this._triggerBeforeAttach=!0},_onAttachCalled:function(){this._triggerAttach=!0},render:function(){return this._ensureViewIsIntact(),this.triggerMethod("before:render",this),this._renderChildren(),this.isRendered=!0,this.triggerMethod("render",this),this},reorder:function(){var children=this.children,models=this._filteredSortedModels();if(_.find(models,function(model){return!children.findByModel(model)}))this.render();else{var els=_.map(models,function(model,index){var view=children.findByModel(model);return view._index=index,view.el});this.triggerMethod("before:reorder"),this._appendReorderedChildren(els),this.triggerMethod("reorder")}},resortView:function(){Marionette.getOption(this,"reorderOnSort")?this.reorder():this.render()},_sortViews:function(){var models=this._filteredSortedModels();_.find(models,function(item,index){var view=this.children.findByModel(item);return!view||view._index!==index},this)&&this.resortView()},_emptyViewIndex:-1,_appendReorderedChildren:function(children){this.$el.append(children)},_renderChildren:function(){this.destroyEmptyView(),this.destroyChildren({checkEmpty:!1}),this.isEmpty(this.collection)?this.showEmptyView():(this.triggerMethod("before:render:collection",this),this.startBuffering(),this.showCollection(),this.endBuffering(),this.triggerMethod("render:collection",this),this.children.isEmpty()&&this.showEmptyView())},showCollection:function(){var ChildView,models=this._filteredSortedModels();_.each(models,function(child,index){ChildView=this.getChildView(child),this.addChild(child,ChildView,index)},this)},_filteredSortedModels:function(){var models,viewComparator=this.getViewComparator();return models=viewComparator?_.isString(viewComparator)||1===viewComparator.length?this.collection.sortBy(viewComparator,this):_.clone(this.collection.models).sort(_.bind(viewComparator,this)):this.collection.models,this.getOption("filter")&&(models=_.filter(models,function(model,index){return this._shouldAddChild(model,index)},this)),models},showEmptyView:function(){var EmptyView=this.getEmptyView();if(EmptyView&&!this._showingEmptyView){this.triggerMethod("before:render:empty"),this._showingEmptyView=!0;var model=new Backbone.Model;this.addEmptyView(model,EmptyView),this.triggerMethod("render:empty")}},destroyEmptyView:function(){this._showingEmptyView&&(this.triggerMethod("before:remove:empty"),this.destroyChildren(),delete this._showingEmptyView,this.triggerMethod("remove:empty"))},getEmptyView:function(){return this.getOption("emptyView")},addEmptyView:function(child,EmptyView){var nestedViews,canTriggerAttach=this._isShown&&!this.isBuffering&&Marionette.isNodeAttached(this.el),emptyViewOptions=this.getOption("emptyViewOptions")||this.getOption("childViewOptions");_.isFunction(emptyViewOptions)&&(emptyViewOptions=emptyViewOptions.call(this,child,this._emptyViewIndex));var view=this.buildChildView(child,EmptyView,emptyViewOptions);view._parent=this,this.proxyChildEvents(view),this._isShown&&Marionette.triggerMethodOn(view,"before:show",view),this.children.add(view),canTriggerAttach&&this._triggerBeforeAttach&&(nestedViews=[view].concat(view._getNestedViews()),view.once("render",function(){this._triggerMethodMany(nestedViews,this,"before:attach")},this)),this.renderChildView(view,this._emptyViewIndex),canTriggerAttach&&this._triggerAttach&&(nestedViews=[view].concat(view._getNestedViews()),this._triggerMethodMany(nestedViews,this,"attach")),this._isShown&&Marionette.triggerMethodOn(view,"show",view)},getChildView:function(child){var childView=this.getOption("childView");if(!childView)throw new Marionette.Error({name:"NoChildViewError",message:'A "childView" must be specified'});return childView},addChild:function(child,ChildView,index){var childViewOptions=this.getOption("childViewOptions");childViewOptions=Marionette._getValue(childViewOptions,this,[child,index]);var view=this.buildChildView(child,ChildView,childViewOptions);return this._updateIndices(view,!0,index),this.triggerMethod("before:add:child",view),this._addChildView(view,index),this.triggerMethod("add:child",view),view._parent=this,view},_updateIndices:function(view,increment,index){this.getOption("sort")&&(increment&&(view._index=index),this.children.each(function(laterView){laterView._index>=view._index&&(laterView._index+=increment?1:-1)}))},_addChildView:function(view,index){var nestedViews,canTriggerAttach=this._isShown&&!this.isBuffering&&Marionette.isNodeAttached(this.el);this.proxyChildEvents(view),this._isShown&&!this.isBuffering&&Marionette.triggerMethodOn(view,"before:show",view),this.children.add(view),canTriggerAttach&&this._triggerBeforeAttach&&(nestedViews=[view].concat(view._getNestedViews()),view.once("render",function(){this._triggerMethodMany(nestedViews,this,"before:attach")},this)),this.renderChildView(view,index),canTriggerAttach&&this._triggerAttach&&(nestedViews=[view].concat(view._getNestedViews()),this._triggerMethodMany(nestedViews,this,"attach")),this._isShown&&!this.isBuffering&&Marionette.triggerMethodOn(view,"show",view)},renderChildView:function(view,index){return view.render(),this.attachHtml(this,view,index),view},buildChildView:function(child,ChildViewClass,childViewOptions){return new ChildViewClass(_.extend({model:child},childViewOptions))},removeChildView:function(view){return view&&(this.triggerMethod("before:remove:child",view),view.destroy?view.destroy():view.remove&&view.remove(),delete view._parent,this.stopListening(view),this.children.remove(view),this.triggerMethod("remove:child",view),this._updateIndices(view,!1)),view},isEmpty:function(){return!this.collection||0===this.collection.length},checkEmpty:function(){this.isEmpty(this.collection)&&this.showEmptyView()},attachBuffer:function(collectionView,buffer){collectionView.$el.append(buffer)},_createBuffer:function(){var elBuffer=document.createDocumentFragment();return _.each(this._bufferedChildren,function(b){elBuffer.appendChild(b.el)}),elBuffer},attachHtml:function(collectionView,childView,index){collectionView.isBuffering?collectionView._bufferedChildren.splice(index,0,childView):collectionView._insertBefore(childView,index)||collectionView._insertAfter(childView)},_insertBefore:function(childView,index){var currentView;return this.getOption("sort")&&index<this.children.length-1&&(currentView=this.children.find(function(view){return view._index===index+1})),!!currentView&&(currentView.$el.before(childView.el),!0)},_insertAfter:function(childView){this.$el.append(childView.el)},_initChildViewStorage:function(){this.children=new Backbone.ChildViewContainer},destroy:function(){return this.isDestroyed?this:(this.triggerMethod("before:destroy:collection"),this.destroyChildren({checkEmpty:!1}),this.triggerMethod("destroy:collection"),Marionette.View.prototype.destroy.apply(this,arguments))},destroyChildren:function(options){var destroyOptions=options||{},shouldCheckEmpty=!0,childViews=this.children.map(_.identity);return _.isUndefined(destroyOptions.checkEmpty)||(shouldCheckEmpty=destroyOptions.checkEmpty),this.children.each(this.removeChildView,this),shouldCheckEmpty&&this.checkEmpty(),childViews},_shouldAddChild:function(child,index){var filter=this.getOption("filter");return!_.isFunction(filter)||filter.call(this,child,index,this.collection)},proxyChildEvents:function(view){var prefix=this.getOption("childViewEventPrefix");this.listenTo(view,"all",function(){var args=_.toArray(arguments),rootEvent=args[0],childEvents=this.normalizeMethods(_.result(this,"childEvents"));args[0]=prefix+":"+rootEvent,args.splice(1,0,view),void 0!==childEvents&&_.isFunction(childEvents[rootEvent])&&childEvents[rootEvent].apply(this,args.slice(1)),this.triggerMethod.apply(this,args)})},_getImmediateChildren:function(){return _.values(this.children._views)},getViewComparator:function(){return this.getOption("viewComparator")}}),Marionette.CompositeView=Marionette.CollectionView.extend({constructor:function(){Marionette.CollectionView.apply(this,arguments)},_initialEvents:function(){this.collection&&(this.listenTo(this.collection,"add",this._onCollectionAdd),this.listenTo(this.collection,"remove",this._onCollectionRemove),this.listenTo(this.collection,"reset",this._renderChildren),this.getOption("sort")&&this.listenTo(this.collection,"sort",this._sortViews))},getChildView:function(child){return this.getOption("childView")||this.constructor},serializeData:function(){var data={};return this.model&&(data=_.partial(this.serializeModel,this.model).apply(this,arguments)),data},render:function(){return this._ensureViewIsIntact(),this._isRendering=!0,this.resetChildViewContainer(),this.triggerMethod("before:render",this),this._renderTemplate(),this._renderChildren(),this._isRendering=!1,this.isRendered=!0,this.triggerMethod("render",this),this},_renderChildren:function(){(this.isRendered||this._isRendering)&&Marionette.CollectionView.prototype._renderChildren.call(this)},_renderTemplate:function(){var data={};data=this.serializeData(),data=this.mixinTemplateHelpers(data),this.triggerMethod("before:render:template");var template=this.getTemplate(),html=Marionette.Renderer.render(template,data,this);this.attachElContent(html),this.bindUIElements(),this.triggerMethod("render:template")},attachElContent:function(html){return this.$el.html(html),this},attachBuffer:function(compositeView,buffer){this.getChildViewContainer(compositeView).append(buffer)},_insertAfter:function(childView){this.getChildViewContainer(this,childView).append(childView.el)},_appendReorderedChildren:function(children){this.getChildViewContainer(this).append(children)},getChildViewContainer:function(containerView,childView){if(containerView.$childViewContainer)return containerView.$childViewContainer;var container,childViewContainer=Marionette.getOption(containerView,"childViewContainer");if(childViewContainer){var selector=Marionette._getValue(childViewContainer,containerView);if((container="@"===selector.charAt(0)&&containerView.ui?containerView.ui[selector.substr(4)]:containerView.$(selector)).length<=0)throw new Marionette.Error({name:"ChildViewContainerMissingError",message:'The specified "childViewContainer" was not found: '+containerView.childViewContainer})}else container=containerView.$el;return containerView.$childViewContainer=container,container},resetChildViewContainer:function(){this.$childViewContainer&&(this.$childViewContainer=void 0)}}),Marionette.LayoutView=Marionette.ItemView.extend({regionClass:Marionette.Region,options:{destroyImmediate:!1},childViewEventPrefix:"childview",constructor:function(options){options=options||{},this._firstRender=!0,this._initializeRegions(options),Marionette.ItemView.call(this,options)},render:function(){return this._ensureViewIsIntact(),this._firstRender?this._firstRender=!1:this._reInitializeRegions(),Marionette.ItemView.prototype.render.apply(this,arguments)},destroy:function(){return this.isDestroyed?this:(!0===this.getOption("destroyImmediate")&&this.$el.remove(),this.regionManager.destroy(),Marionette.ItemView.prototype.destroy.apply(this,arguments))},showChildView:function(regionName,view){return this.getRegion(regionName).show(view)},getChildView:function(regionName){return this.getRegion(regionName).currentView},addRegion:function(name,definition){var regions={};return regions[name]=definition,this._buildRegions(regions)[name]},addRegions:function(regions){return this.regions=_.extend({},this.regions,regions),this._buildRegions(regions)},removeRegion:function(name){return delete this.regions[name],this.regionManager.removeRegion(name)},getRegion:function(region){return this.regionManager.get(region)},getRegions:function(){return this.regionManager.getRegions()},_buildRegions:function(regions){var defaults={regionClass:this.getOption("regionClass"),parentEl:_.partial(_.result,this,"el")};return this.regionManager.addRegions(regions,defaults)},_initializeRegions:function(options){var regions;this._initRegionManager(),regions=Marionette._getValue(this.regions,this,[options])||{};var regionOptions=this.getOption.call(options,"regions");regionOptions=Marionette._getValue(regionOptions,this,[options]),_.extend(regions,regionOptions),regions=this.normalizeUIValues(regions,["selector","el"]),this.addRegions(regions)},_reInitializeRegions:function(){this.regionManager.invoke("reset")},getRegionManager:function(){return new Marionette.RegionManager},_initRegionManager:function(){this.regionManager=this.getRegionManager(),this.regionManager._parent=this,this.listenTo(this.regionManager,"before:add:region",function(name){this.triggerMethod("before:add:region",name)}),this.listenTo(this.regionManager,"add:region",function(name,region){this[name]=region,this.triggerMethod("add:region",name,region)}),this.listenTo(this.regionManager,"before:remove:region",function(name){this.triggerMethod("before:remove:region",name)}),this.listenTo(this.regionManager,"remove:region",function(name,region){delete this[name],this.triggerMethod("remove:region",name,region)})},_getImmediateChildren:function(){return _.chain(this.regionManager.getRegions()).pluck("currentView").compact().value()}}),Marionette.Behavior=Marionette.Object.extend({constructor:function(options,view){this.view=view,this.defaults=_.result(this,"defaults")||{},this.options=_.extend({},this.defaults,options),this.ui=_.extend({},_.result(view,"ui"),_.result(this,"ui")),Marionette.Object.apply(this,arguments)},$:function(){return this.view.$.apply(this.view,arguments)},destroy:function(){return this.stopListening(),this},proxyViewProperties:function(view){this.$el=view.$el,this.el=view.el}}),Marionette.Behaviors=function(Marionette,_){var delegateEventSplitter=/^(\S+)\s*(.*)$/;function Behaviors(view,behaviors){return _.isObject(view.behaviors)?(behaviors=Behaviors.parseBehaviors(view,behaviors||_.result(view,"behaviors")),Behaviors.wrap(view,behaviors,_.keys(methods)),behaviors):{}}var methods={behaviorTriggers:function(behaviorTriggers,behaviors){return new BehaviorTriggersBuilder(this,behaviors).buildBehaviorTriggers()},behaviorEvents:function(behaviorEvents,behaviors){var _behaviorsEvents={};return _.each(behaviors,function(b,i){var _events={},behaviorEvents=_.clone(_.result(b,"events"))||{};behaviorEvents=Marionette.normalizeUIKeys(behaviorEvents,getBehaviorsUI(b));var j=0;_.each(behaviorEvents,function(behaviour,key){var match=key.match(delegateEventSplitter),eventKey=match[1]+"."+[this.cid,i,j++," "].join("")+match[2],handler=_.isFunction(behaviour)?behaviour:b[behaviour];_events[eventKey]=_.bind(handler,b)},this),_behaviorsEvents=_.extend(_behaviorsEvents,_events)},this),_behaviorsEvents}};function BehaviorTriggersBuilder(view,behaviors){this._view=view,this._behaviors=behaviors,this._triggers={}}function getBehaviorsUI(behavior){return behavior._uiBindings||behavior.ui}return _.extend(Behaviors,{behaviorsLookup:function(){throw new Marionette.Error({message:"You must define where your behaviors are stored.",url:"marionette.behaviors.html#behaviorslookup"})},getBehaviorClass:function(options,key){return options.behaviorClass?options.behaviorClass:Marionette._getValue(Behaviors.behaviorsLookup,this,[options,key])[key]},parseBehaviors:function(view,behaviors){return _.chain(behaviors).map(function(options,key){var behavior=new(Behaviors.getBehaviorClass(options,key))(options,view),nestedBehaviors=Behaviors.parseBehaviors(view,_.result(behavior,"behaviors"));return[behavior].concat(nestedBehaviors)}).flatten().value()},wrap:function(view,behaviors,methodNames){_.each(methodNames,function(methodName){view[methodName]=_.partial(methods[methodName],view[methodName],behaviors)})}}),_.extend(BehaviorTriggersBuilder.prototype,{buildBehaviorTriggers:function(){return _.each(this._behaviors,this._buildTriggerHandlersForBehavior,this),this._triggers},_buildTriggerHandlersForBehavior:function(behavior,i){var triggersHash=_.clone(_.result(behavior,"triggers"))||{};triggersHash=Marionette.normalizeUIKeys(triggersHash,getBehaviorsUI(behavior)),_.each(triggersHash,_.bind(this._setHandlerForBehavior,this,behavior,i))},_setHandlerForBehavior:function(behavior,i,eventName,trigger){var triggerKey=trigger.replace(/^\S+/,function(triggerName){return triggerName+".behaviortriggers"+i});this._triggers[triggerKey]=this._view._buildViewTrigger(eventName)}}),Behaviors}(Marionette,_),Marionette.AppRouter=Backbone.Router.extend({constructor:function(options){this.options=options||{},Backbone.Router.apply(this,arguments);var appRoutes=this.getOption("appRoutes"),controller=this._getController();this.processAppRoutes(controller,appRoutes),this.on("route",this._processOnRoute,this)},appRoute:function(route,methodName){var controller=this._getController();this._addAppRoute(controller,route,methodName)},_processOnRoute:function(routeName,routeArgs){if(_.isFunction(this.onRoute)){var routePath=_.invert(this.getOption("appRoutes"))[routeName];this.onRoute(routeName,routePath,routeArgs)}},processAppRoutes:function(controller,appRoutes){if(appRoutes){var routeNames=_.keys(appRoutes).reverse();_.each(routeNames,function(route){this._addAppRoute(controller,route,appRoutes[route])},this)}},_getController:function(){return this.getOption("controller")},_addAppRoute:function(controller,route,methodName){var method=controller[methodName];if(!method)throw new Marionette.Error('Method "'+methodName+'" was not found on the controller');this.route(route,methodName,_.bind(method,controller))},mergeOptions:Marionette.mergeOptions,getOption:Marionette.proxyGetOption,triggerMethod:Marionette.triggerMethod,bindEntityEvents:Marionette.proxyBindEntityEvents,unbindEntityEvents:Marionette.proxyUnbindEntityEvents}),Marionette.Application=Marionette.Object.extend({constructor:function(options){this._initializeRegions(options),this._initCallbacks=new Marionette.Callbacks,this.submodules={},_.extend(this,options),this._initChannel(),Marionette.Object.call(this,options)},execute:function(){this.commands.execute.apply(this.commands,arguments)},request:function(){return this.reqres.request.apply(this.reqres,arguments)},addInitializer:function(initializer){this._initCallbacks.add(initializer)},start:function(options){this.triggerMethod("before:start",options),this._initCallbacks.run(options,this),this.triggerMethod("start",options)},addRegions:function(regions){return this._regionManager.addRegions(regions)},emptyRegions:function(){return this._regionManager.emptyRegions()},removeRegion:function(region){return this._regionManager.removeRegion(region)},getRegion:function(region){return this._regionManager.get(region)},getRegions:function(){return this._regionManager.getRegions()},module:function(moduleNames,moduleDefinition){var ModuleClass=Marionette.Module.getClass(moduleDefinition),args=_.toArray(arguments);return args.unshift(this),ModuleClass.create.apply(ModuleClass,args)},getRegionManager:function(){return new Marionette.RegionManager},_initializeRegions:function(options){var regions=_.isFunction(this.regions)?this.regions(options):this.regions||{};this._initRegionManager();var optionRegions=Marionette.getOption(options,"regions");return _.isFunction(optionRegions)&&(optionRegions=optionRegions.call(this,options)),_.extend(regions,optionRegions),this.addRegions(regions),this},_initRegionManager:function(){this._regionManager=this.getRegionManager(),this._regionManager._parent=this,this.listenTo(this._regionManager,"before:add:region",function(){Marionette._triggerMethod(this,"before:add:region",arguments)}),this.listenTo(this._regionManager,"add:region",function(name,region){this[name]=region,Marionette._triggerMethod(this,"add:region",arguments)}),this.listenTo(this._regionManager,"before:remove:region",function(){Marionette._triggerMethod(this,"before:remove:region",arguments)}),this.listenTo(this._regionManager,"remove:region",function(name){delete this[name],Marionette._triggerMethod(this,"remove:region",arguments)})},_initChannel:function(){this.channelName=_.result(this,"channelName")||"global",this.channel=_.result(this,"channel")||Backbone.Wreqr.radio.channel(this.channelName),this.vent=_.result(this,"vent")||this.channel.vent,this.commands=_.result(this,"commands")||this.channel.commands,this.reqres=_.result(this,"reqres")||this.channel.reqres}}),Marionette.Module=function(moduleName,app,options){this.moduleName=moduleName,this.options=_.extend({},this.options,options),this.initialize=options.initialize||this.initialize,this.submodules={},this._setupInitializersAndFinalizers(),this.app=app,_.isFunction(this.initialize)&&this.initialize(moduleName,app,this.options)},Marionette.Module.extend=Marionette.extend,_.extend(Marionette.Module.prototype,Backbone.Events,{startWithParent:!0,initialize:function(){},addInitializer:function(callback){this._initializerCallbacks.add(callback)},addFinalizer:function(callback){this._finalizerCallbacks.add(callback)},start:function(options){this._isInitialized||(_.each(this.submodules,function(mod){mod.startWithParent&&mod.start(options)}),this.triggerMethod("before:start",options),this._initializerCallbacks.run(options,this),this._isInitialized=!0,this.triggerMethod("start",options))},stop:function(){this._isInitialized&&(this._isInitialized=!1,this.triggerMethod("before:stop"),_.invoke(this.submodules,"stop"),this._finalizerCallbacks.run(void 0,this),this._initializerCallbacks.reset(),this._finalizerCallbacks.reset(),this.triggerMethod("stop"))},addDefinition:function(moduleDefinition,customArgs){this._runModuleDefinition(moduleDefinition,customArgs)},_runModuleDefinition:function(definition,customArgs){if(definition){var args=_.flatten([this,this.app,Backbone,Marionette,Backbone.$,_,customArgs]);definition.apply(this,args)}},_setupInitializersAndFinalizers:function(){this._initializerCallbacks=new Marionette.Callbacks,this._finalizerCallbacks=new Marionette.Callbacks},triggerMethod:Marionette.triggerMethod}),_.extend(Marionette.Module,{create:function(app,moduleNames,moduleDefinition){var module=app,customArgs=_.drop(arguments,3),length=(moduleNames=moduleNames.split(".")).length,moduleDefinitions=[];return moduleDefinitions[length-1]=moduleDefinition,_.each(moduleNames,function(moduleName,i){var parentModule=module;module=this._getModule(parentModule,moduleName,app,moduleDefinition),this._addModuleDefinition(parentModule,module,moduleDefinitions[i],customArgs)},this),module},_getModule:function(parentModule,moduleName,app,def,args){var options=_.extend({},def),ModuleClass=this.getClass(def),module=parentModule[moduleName];return module||(module=new ModuleClass(moduleName,app,options),parentModule[moduleName]=module,parentModule.submodules[moduleName]=module),module},getClass:function(moduleDefinition){var ModuleClass=Marionette.Module;return moduleDefinition?moduleDefinition.prototype instanceof ModuleClass?moduleDefinition:moduleDefinition.moduleClass||ModuleClass:ModuleClass},_addModuleDefinition:function(parentModule,module,def,args){var fn=this._getDefine(def),startWithParent=this._getStartWithParent(def,module);fn&&module.addDefinition(fn,args),this._addStartWithParent(parentModule,module,startWithParent)},_getStartWithParent:function(def,module){var swp;return _.isFunction(def)&&def.prototype instanceof Marionette.Module?(swp=module.constructor.prototype.startWithParent,!!_.isUndefined(swp)||swp):!_.isObject(def)||(swp=def.startWithParent,!!_.isUndefined(swp)||swp)},_getDefine:function(def){return!_.isFunction(def)||def.prototype instanceof Marionette.Module?_.isObject(def)?def.define:null:def},_addStartWithParent:function(parentModule,module,startWithParent){module.startWithParent=module.startWithParent&&startWithParent,module.startWithParent&&!module.startWithParentIsConfigured&&(module.startWithParentIsConfigured=!0,parentModule.addInitializer(function(options){module.startWithParent&&module.start(options)}))}}),Marionette}(root,Backbone,_)})}(this);