/* eslint-disable */
AJS.toInit(function($) {
    var jobId = "";
    var currentProcessedSpaceCount = -1; // Seems unused
    var clickedPermissionIndex;

    var owners = [];
    var spaces = [];
    var evaluatedPage = null;
    var permissionsMatrix = [];
    var totalOwners;
    var rowsPerPage = 25;
    var currentPageIndex = 0;
    var pollingEvaluation = false;
    var pollingExportDownload = false;

    const ALL_PERMISSIONS_FLAG = $("#all-permissions-flag").val();
    const ALL_PERMISSIONS_METADATA = JSON.parse($("#all-permissions-metadata").val());
    //console.log(ALL_PERMISSIONS_METADATA);

    var dialogTemplate = $("#permission-details-template");
    dialogTemplate.remove();

    var permissionsTable = $("#permissions-overview-table");
    var permissionsFixColTable = $("#permissions-fixcol-table");
    var isGlobal = permissionsFixColTable.length > 0;
    var urlPrefix = AJS.contextPath() + (isGlobal
                    ? "/admin/plugins/gatekeeper-plugin/global/"
                    : "/plugins/gatekeeper-plugin/space/");

    var permissionDialog, dialogTitle, dialogType;
    var viewPanel, editPanel, permissionImageCells, permissionCheckboxes;
    var modifyForm, spaceSelect, spaceList, saveButton;
    var spaceKey, spaceName, owner, anonymous;

    var showButton = $('#show-button');
    var exportButton = $('#export-button');
    var overviewForm = $('form#overview-form');
    var exportCsvDelimiterSelect = $('#export-csv-delimiter-select');
    var exportCsvCustomDelimiterInput = $('#export-csv-custom-delimiter-input');
    var exportSpaceDetailsSelect = $('#export-space-details-format-select');
    var exportCustomSpaceDetailsInput = $('#export-custom-space-details-input');

    var exportFormat = "";

    if (AJS.version == undefined || AJS.version.indexOf("5.4.4") == 0) {
        $(".aui-iconfont-back-page").removeClass("aui-iconfont-back-page").addClass("aui-iconfont-devtools-arrow-left");
    }

    showButton.on('click', function(e) {
        MIUPMJS.resetForm(overviewForm);
        exportFormat = "";
        initEvaluator();
    });

    exportButton.on('click', function(e) {
        MIUPMJS.resetForm(overviewForm);
        exportFormat = "csv";//$("#export-format-select").val();
        initEvaluator();
    });

    exportCsvDelimiterSelect.on('change', function(e) {
        updateExportCsvDelimiterSelect();
    });

    exportSpaceDetailsSelect.on('change', function(e) {
        updateExportCustomSpaceDetailsSelect();
    });

    $("#page-size-selector-main").on('change', function() {
        var selector = $("#page-size-selector-main")[0];
        rowsPerPage = selector.options[selector.selectedIndex].value;
    });

    function updateExportCsvDelimiterSelect() {
        exportCsvCustomDelimiterInput.prop("disabled", exportCsvDelimiterSelect.val() != "custom");
    }

    function updateExportCustomSpaceDetailsSelect() {
        exportCustomSpaceDetailsInput.prop("disabled", exportSpaceDetailsSelect.val() != "custom");
    }

    if (isGlobal) {
        // Highlight row in permissionTable
        permissionsFixColTable.delegate('td', 'mouseover mouseleave', function(e) {
            var rowSelector = ":nth-child(" + ($(this).parent().index() + 1) + ")";
            if (e.type == 'mouseover') {
                permissionsTable.find("tr" + rowSelector).addClass("hover");
            }
            else {
                permissionsTable.find("tr" + rowSelector).removeClass("hover");
            }
        });

        permissionsTable.delegate('td,th', 'mouseover mouseleave', function(e) {
            var cell = $(this);
            var colIndex = cell.index();
            var row = cell.parent();
            var rowIndex = row.index();
            // Highlight column
            if (colIndex > 0) {
                var colSelector = ":nth-child(" + (colIndex + 1) + ")";
                if (e.type == 'mouseover') {
                    permissionsTable.find("th" + colSelector + ",td" + colSelector).addClass("hover");
                }
                else {
                    permissionsTable.find("th" + colSelector + ",td" + colSelector).removeClass("hover");
                }
            }
            // Highlight row in permissionFixColTable
            if (cell[0].nodeName.toLowerCase() == 'td') {
                var rowSelector = ":nth-child(" + (rowIndex + 1) + ")";
                if (e.type == 'mouseover') {
                    permissionsFixColTable.find("tr" + rowSelector).addClass("hover");
                }
                else {
                    permissionsFixColTable.find("tr" + rowSelector).removeClass("hover");
                }
            }
        });
    }

    permissionsTable.on('click', 'td', function(e) {
        var cell = $(this);
        var permissions = isGlobal ? cell.data("permissions") : cell.parent().data("permissions");
        var partialPermissions = isGlobal ? cell.data("partial-permissions") : cell.parent().data("partial-permissions");
        if (typeof permissions == "undefined") {
            return;
        }

        dialogTitle = dialogTemplate.find(".permission-details-dialog-title").html();
        viewPanel = dialogTemplate.find(".permission-details-dialog-view-panel").clone();
        editPanel = dialogTemplate.find(".permission-details-dialog-edit-panel").clone();
        permissionImageCells = viewPanel.find(".space-permissions-table td");
        permissionCheckboxes = editPanel.find(".permission-checkbox");
        var panels = $([viewPanel[0], editPanel[0]]);

        var x = cell.index();
        var y = cell.parent().index() + (isGlobal ? 1 : 2); // Global overview has 1 header row, Space overview has 2 header rows.
        clickedPermissionIndex = x;

        var spaceNode = isGlobal ? permissionsTable.find("tr th:eq(" + x + ")") : $("#space-node");
        spaceKey = spaceNode.data("space-key");
        spaceName = spaceNode.data("space-name");
        panels.find(".ep-space").text(spaceName + " (" + spaceKey + ")");

        if (evaluatedPage) {
            panels.find(".ep-page").text(evaluatedPage.title);
        }

        var ownerNode = permissionsTable.find("tr:eq(" + y + ") td:eq(0)");
        dialogType = cell.closest("table").data("type");
        owner = ownerNode.data("owner");
        anonymous = ownerNode.data("anonymous") ? "true" : "false";
        panels.find(".ep-owner").html(ownerNode.html().trim());

        panels.find(".switch-button").on('click', function(e) {
            permissionDialog.nextPage();
            var h = Math.max(modifyForm.outerHeight() - 100, 60);
            spaceList.height(h);
        });

        var readOnlyMode = AJS.Meta.get("render-mode") === "READ_ONLY";
        if (!readOnlyMode) {
            spaceSelect = editPanel.find(".space-selector");
            spaceList = editPanel.find('.space-list');
            saveButton = editPanel.find("#save-button");
            modifyForm = editPanel.find('#modify-form');
            saveButton.on('click', savePermissions);

            spaceList.sortedList();
            spaceList.sortedList("add", spaceKey, spaceName);

            editPanel.find('.space-list').sortedList();

            editPanel.find("#select-all, #deselect-all").on('click', function (e) {
                var target = $(e.target);
                permissionCheckboxes.prop('checked', target.attr('id') == 'select-all');
            });

            spaceSelect.auiSelect2({
                placeholder: "Start typing space name and use Enter or click to add the space",
                width: "100%",
                allowClear: true,
                minimumInputLength: 1,
                ajax: {
                    url: AJS.contextPath() + "/rest/api/search",
                    dataType: "json",
                    data: function(term, page) {
                        return {
                            cql: 'type=space AND title~"' + term + '*"'
                        }
                    },
                    results: function(data, page) {
                        var results = [];
                        if (data.results) {
                            for (var i = 0; i < data.results.length; i++) {
                                var space = data.results[i].space;
                                results.push({id: space.key, text: space.name})
                            }
                        }
                        return { results: results }
                    }
                }
            });

            spaceSelect.on("change", function (e) {
                var key = spaceSelect.auiSelect2("data").id;
                var value = spaceSelect.auiSelect2("data").text;
                spaceList.sortedList("add", key, value);
                spaceSelect.auiSelect2("val", "");
            });
        }

        if (!ALL_PERMISSIONS_METADATA[1].supported) {
            viewPanel.find(".space-permissions-table th:nth-child(3), .space-permissions-table td:nth-child(3)").empty().addClass("unsupported");
            editPanel.find(".space-permissions-table th:nth-child(3), .space-permissions-table td:nth-child(3)").empty().addClass("unsupported");
        }

        // First cell is used for showing username in space permissions
        for (var i = 1; i < permissionImageCells.length; i++) {
            var node = $(permissionImageCells[i]);
            var permissionFlag = node.data("permission-flag");

            var stateClass = "p-none";
            if ((permissions & permissionFlag) != 0) {
                stateClass = ((partialPermissions & permissionFlag) != 0) ? "p-some" : "p-all";
            }
            node.find("div").addClass(stateClass);

            node.click(function(e) {
                var clickedCell = $(this);
                var permissionFlag = clickedCell.data("permission-flag");
                permissionImageCells.removeClass("active");
                clickedCell.addClass("active");
                viewPanel.find(".permission-explanation").hide();
                viewPanel.find("#permission-explanation-" + permissionFlag).show();
            });
        }

        permissionCheckboxes.each(function() {
            var checkbox = $(this);
            var permissionFlag = checkbox.data("permission-flag");
            checkbox.prop("checked", (permissions & permissionFlag) != 0);
        });

        showExplanationDialog();
        loadExplanations();
    });

    $("#permissions-explanation-table").on('click', 'td', function(e) {
        var cell = $(this);
        var permissionFlag = cell.data("permission-flag");
        $("#permissions-explanation-table td").removeClass("active");
        cell.addClass("active");
        $(".permission-explanation").hide();
        $("#permission-explanation-" + permissionFlag).show();
    });

    function showExplanationDialog() {
        permissionDialog = new AJS.Dialog({
            width: Math.min($(window).innerWidth() - 120, 1100),
            height: Math.min($(window).innerHeight() - 25, 800),
            id: "permissions-detail-dialog",
            closeOnOutsideClick: true,
            keypressListener: (function(e) {
                if (e.keyCode == 27) {
                    permissionDialog.remove();
                }
            })
        });

        permissionDialog.addHeader(dialogTitle);
        permissionDialog.addPanel("View", viewPanel, "singlePanel");
        permissionDialog.addLink("Close", function(dialog) {
            dialog.remove();
        }, "#");

        permissionDialog.addPage();
        permissionDialog.addHeader(dialogTitle);
        permissionDialog.addPanel("Edit", editPanel, "singlePanel");
        permissionDialog.addLink("Close", function(dialog) {
            dialog.remove();
        }, "#");

        permissionDialog.gotoPage(0);
        permissionDialog.gotoPanel(0);
        permissionDialog.show();
    }

    function loadExplanations() {
        var explanationContainerNode = viewPanel.find(".permission-explanations-container");
        var data = createOwnerData();
        // Important: for space overview "key" must be the parameter name, required by SpaceAdminAction
        $.extend(data, isGlobal ? {spaceKey: spaceKey} : {key: spaceKey});
        $.extend(data, {pageId: evaluatedPage ? evaluatedPage.id : 0});

        MIUPMJS.get(urlPrefix + 'explain-space-permissions.action', data, {errorMessage: 'Failed loading explanations!'})
                .done(function(data, textStatus, jqXHR) {
                    explanationContainerNode.html(data);
                    permissionImageCells[isGlobal ? 1 : clickedPermissionIndex].click();
                })
    }

    function savePermissions() {
        saveButton.prop('disabled', true);
        MIUPMJS.resetForm(modifyForm);

        var data = createOwnerData();
        $.extend(data, {
            permissions: calculatePermissionsValue(),
            spaceKeys: isGlobal ? spaceList.sortedList("val") : [spaceKey],
            atl_token: AJS.Meta.get("atl-token")
        });
        MIUPMJS.post(urlPrefix + 'save-space-permissions.action', data, {errorMessage: 'Failed setting permissions!'})
                .done(function(data, textStatus, jqXHR) {
                    switch (data.status) {
                        case "success":
                            permissionDialog.remove();
                            MIUPMJS.showDialog({
                                title: "Modification results",
                                message: buildModificationResults(data),
                                width: Math.min($(window).innerWidth() - 200, 1100),
                                onClose: function() {
                                    showButton.click();
                                }
                            });
                            break;
                        case "invalid-data":
                            MIUPMJS.setFormErrors(modifyForm, data.errors);
                            break;
                    }
                })
                .always(function() {
                    saveButton.prop('disabled', false);
                })
        return false;
    }

    function buildModificationResults(data) {
        var succeedCount = data.succeed.length;
        var failedCount = data.failed.length;
        var totalCount = succeedCount + failedCount;

        var result = $("<div/>");
        result.append("<div>The permission overview will be reloaded now, please review your modifications.<br/>"
                + "Total number of selected spaces: <b>" + totalCount
                + "</b>. Successfully modified: <b>" + succeedCount
                + "</b>. " + (failedCount > 0
                        ? "<span class='failed-count'>Failed: <b>" + failedCount + "</b></span>"
                        : "Failed: <b>0</b>"));

        var table = $("<table class='modification-results-table'></table>");
        table.append("<tr><th>Space</th><th>Result</th></tr>");
        if (succeedCount > 0) {
            table.append('<tr class="modification-results-subheader"><td colspan="2">Successfully modified spaces</td></tr>');
            $.each(data.succeed, function() {
                var row = $("<tr/>");
                row.append("<td>" + AJS.escapeHtml(this.n) + " (" + AJS.escapeHtml(this.k) + ")</td>");
                row.append("<td>Successfully modified</td>");
                table.append(row);
            })
        }
        if (failedCount > 0) {
            table.append('<tr class="modification-results-subheader"><td colspan="2">Failed spaces</td></tr>');
            $.each(data.failed, function() {
                var row = $("<tr class='failed'></tr>");
                row.append("<td>" + AJS.escapeHtml(this.n) + " (" + AJS.escapeHtml(this.k) + ")</td>");
                row.append("<td>" + AJS.escapeHtml(this.message) + "</td>");
                table.append(row);
            })
        }

        result.append(table);
        return result;
    }

    function calculatePermissionsValue() {
        var result = 0;
        permissionCheckboxes.each(function() {
            if (this.checked) {
                result = result + $(this).data("permission-flag");
            }
        });
        return result;
    }

    function createOwnerData() {
        switch (dialogType) {
            case "user":
                return {type: "user", username: owner, anonymous: anonymous};
            case "group":
                return {type: "group", groupname: owner};
        }
    }

    function initEvaluator() {
        pollingEvaluation = true;
        pollingExportDownload = false;

        showButton.prop('disabled', true);
        exportButton.prop('disabled', true);
        $('.permissions-overview-container').toggle(false);
        $("#progress").html('');
        $("input[name='exportFormat']").val(exportFormat);
        MIUPMJS.post(urlPrefix + 'init-evaluator.action', overviewForm.serialize(), {errorMessage: 'Failed evaluating permissions!'})
                .done(function(data, textStatus, jqXHR) {
                    if (data.status == "success") {
                        jobId = data.jobId;
                        setTimeout(poll, 100);
                        currentProcessedSpaceCount = -1;
                        showTab("result");
                        $("#progress").toggle(true);
                    }
                    else if (data.status == "invalid-data") {
                        MIUPMJS.setFormErrors(overviewForm, data.errors);
                        resetProgressAndButtons();
                    }
                })
                .fail(function() {
                    resetProgressAndButtons();
                })
    }

    function poll() {
        MIUPMJS.get(urlPrefix + 'poll.action', createJobIdData(), {errorMessage: 'Failed evaluating permissions!'})
                .done(function(data, textStatus, jqXHR) {
                    if (data.done) {
                        if (pollingEvaluation) {
                            pollingEvaluation = false;
                            $("#progress").html("Downloading result...");
                            if (exportFormat == "") {
                                downloadOverview();
                            }
                            else {
                                downloadExport();
                            }
                        }
                        else if (pollingExportDownload) {
                            $("#progress").html("Download finished");
                            resetProgressAndButtons();
                        }
                    }
                    else {
                        $("#progress").html(data.phase + " " + data.percent + "%");
                        setTimeout(poll, 500);
                    }
                })
                .fail(function() {
                    resetProgressAndButtons();
                })
    }

    function downloadOverview() {
        MIUPMJS.get(urlPrefix + 'download.action', createJobIdData(), {errorMessage: 'Failed evaluating Spaces!'})
                .done(function(data, textStatus, jqXHR) {
                    //console.log("POLL: " + data);
                    spaces = data.spaces;
                    totalOwners = data.totalOwners;
                    evaluatedPage = (data.pageId != undefined && data.pageId != 0)
                            ? { id: data.pageId, title: data.pageTitle }
                            : null;
                    if (spaces.length === 0 || totalOwners === 0) {
                        resetProgressAndButtons();
                        $("#progress").toggle(true);
                        $('#progress').html("No results are found.");
                    }
                    else {
                        $('#progress').html('Generating overview table...');
                        downloadPermissionsMatrix();
                    }
                })
                .fail(function() {
                    resetProgressAndButtons();
                })
    }

    function downloadPermissionsMatrix() {
        var data = createJobIdData();
        $.extend(data, {start: currentPageIndex * rowsPerPage, count: rowsPerPage});
        MIUPMJS.get(urlPrefix + 'permissions.action', data, {errorMessage: 'Failed evaluating permissions!'})
                .done(function(data, textStatus, jqXHR){
                    owners = data.owners;
                    permissionsMatrix = data.permissions;
                    if (isGlobal) {
                        var pageHeightInPx = $("#admin-content").css("height");
                        var pageHeight = pageHeightInPx.substring(0, pageHeightInPx.length -2);
                        $(".global-permissions-overview-wrapper").css("max-height", (pageHeight - 320) + "px");
                        buildFixcolTable();
                        buildGlobalOverviewTable();
                    }
                    else {
                        buildSpaceOverviewTable();
                    }
                    resetProgressAndButtons();
                    $('.permissions-overview-container').toggle(true);
                })
                .fail(function() {
                    resetProgressAndButtons();
                })
    }

    function downloadExport() {
        var params = createJobIdData();
        var src = urlPrefix + 'download.action?' + AJS.$.param(params);

        if (this.iframe && this.iframe.length > 0) {
            this.iframe.remove();
        }
        this.iframe = AJS.$('<iframe>')
                .hide()
                .prop('src', src)
                .appendTo('body');
        pollingExportDownload = true;
        setTimeout(poll(), 500);
        setTimeout(function() {
            checkDownloadStarted();
        }, 500);
    }

    function checkDownloadStarted() {
        var cookieName = 'upm-export-' + jobId;
        if (document.cookie.indexOf(cookieName + '=success') >= 0) {
            document.cookie = cookieName + "=; path=/; expires=" + new Date(0).toUTCString();
        }
        else if (checkDownloadFailed()) {
            setTimeout(function() {
                MIUPMJS.showErrorDialog('Error', "Sorry, download failed! Please contact your administrator to check server logs!");
            }, 100);
        }
        else {
            setTimeout(function() {
                checkDownloadStarted();
            }, 500);
        }
    }

    function checkDownloadFailed() {
        try {
            var iframeDoc = this.iframe[0].contentWindow || this.iframe[0].contentDocument;
            if (iframeDoc.document) {
                iframeDoc = iframeDoc.document;
            }
            if (iframeDoc && iframeDoc.body !== null && iframeDoc.body.innerHTML.length) {
                return true;
            }
        }
        catch (e) {
            return true;
        }
        return false;
    }

    function buildFixcolTable() {
        var fixTable = $('#permissions-fixcol-table');
        fixTable.empty();

        var head = $('<thead>');
        var row = $('<tr>');
        row.append('<th></th>');
        head.append(row);

        var body = $('<tbody>');
        for (var i = 0; i < owners.size; i++) {
            var row = $('<tr>');
            row.append(buildOwnerCell(owners[i]));
            body.append(row);
        }

        fixTable.append(head, body);
    }

    function buildGlobalOverviewTable() {
        var overviewTable = $('#permissions-overview-table');
        createPageSelectorContainer();
        overviewTable.empty();

        var head = $('<thead>');
        var headRow = $('<tr>');
        headRow.append('<th></th>');
        for (var i = 0; i < spaces.length; i++) {
            var s = '<th class="rotate" title="{SPACENAME} ({SPACEKEY})" data-space-key="{SPACEKEY}" data-space-name="{SPACENAME}"><div><span>'
                    + '<a class="space-key" href="{CONTEXTPATH}/plugins/gatekeeper-plugin/space/inspect-permissions.action?key={SPACEKEY}">{SPACEKEY}</a>'
                    + ' <span class="space-name">{SPACENAME}</span>'
                    + '</span></div></th>';
            var space = spaces[i];

            s = s.replace(/\{SPACENAME\}/g, MIUPMJS.escapeHtml(space.n));
            s = s.replace(/\{SPACEKEY\}/g, MIUPMJS.escapeHtml(space.k));
            s = s.replace(/\{CONTEXTPATH\}/g, AJS.contextPath());
            //TODO: XSS vuln here due to inserting space.n above,
            headRow.append($(s));
        }
        head.append(headRow);

        var body = $('<tbody>');
        for (var i = 0; i < owners.length; i++) {
            var row = $('<tr>');
            row.append(buildOwnerCell(owners[i], true));
            for (var j = 0; j < permissionsMatrix[i].length; j++) {
                var permissions = permissionsMatrix[i][j];
                var partialPermissions = permissions >> 16;
                permissions = permissions & 0xFFFF;
                var className = (permissions == 0 ? 'p-none' : (permissions == ALL_PERMISSIONS_FLAG ? 'p-all' : 'p-some'));
                var cell = buildPermissionCell(className);
                cell.data('permissions', permissions);
                cell.data('partial-permissions', partialPermissions);
                row.append(cell);
            }
            body.append(row);
        }

        overviewTable.append(head, body);
    }

    function createPageSelectorContainer() {
        var $pagesList = $(".page-selector-container").find(".pages-field");
        var $pageSizeSelector = $(".page-selector-container").find(".selector-field");
        $pagesList.empty();
        $pageSizeSelector.empty();
        $pageSizeSelector.append(addPageSizeSelector());
        $pagesList.append(createPageSelector());
    };

    function buildSpaceOverviewTable() {
        // $('.row-count-info').html(buildRowInfo());

        var overviewTable = $('#permissions-overview-table');
        var body = overviewTable.find('tbody');
        body.empty();

        var max = overviewTable.find('.header-2 th').length - 1;
        var rows = [];
        for (var i = 0; i < permissionsMatrix.length; i++) {
            var row = $('<tr>');
            var permissions = permissionsMatrix[i][0];
            var partialPermissions = permissions >> 16;
            permissions = permissions & 0xFFFF;
            row.data('permissions', permissions);
            row.data('partial-permissions', partialPermissions);
            row.append(buildOwnerCell(owners[i], true));
            var permissionFlag = 1;
            for (var j = 0; j < max; j++) {
                var permitted = (permissions & permissionFlag) !== 0;
                var partialPermitted = (partialPermissions & permissionFlag) !== 0;
                var className = (permitted ? (partialPermitted ? 'p-some' : 'p-all') : 'p-none');
                row.append(buildPermissionCell(className));
                permissionFlag = permissionFlag << 1;
            }
            rows.push(row);
        }

        $.each(rows, function() {
            body.append(this);
        });

        if (!ALL_PERMISSIONS_METADATA[1].supported) {
            overviewTable.find("th:nth-child(3), td:nth-child(3)").empty().addClass("unsupported");
        }
    }

    function buildRowInfo() {
        var rowInfo = rowsPerPage < totalOwners
                ? '<b>' + rowsPerPage + '</b> of <b>' + totalOwners + '</b> rows are shown.<br/>Adjust filters or row limit to see all results.'
                : '<b>' + owners.length + '</b> rows found.';
        return rowInfo;
    }

    function addPageSizeSelector() {
        var $result = $("<div><span class='st_per_page_container'>Rows per page:" +
                "<select size='1' class='st_per_page' id='page-size-selector-view'></select></span></div>");
        $result.find("#page-size-selector-view").append();
        $result.find("#page-size-selector-view").append("<option value='1'" + (rowsPerPage == 1 ? " selected" : "") + ">1</option>");
        $result.find("#page-size-selector-view").append("<option value='2'" + (rowsPerPage == 2 ? " selected" : "") + ">2</option>");
        $result.find("#page-size-selector-view").append("<option value='10'" + (rowsPerPage == 10 ? " selected" : "") + ">10</option>");
        $result.find("#page-size-selector-view").append("<option value='25'" + (rowsPerPage == 25 ? " selected" : "") + ">25</option>");
        $result.find("#page-size-selector-view").append("<option value='50'" + (rowsPerPage == 50 ? " selected" : "") + ">50</option>");
        $result.find("#page-size-selector-view").append("<option value='100'" + (rowsPerPage == 100 ? " selected" : "") + ">100</option>");

        $result.on("change", function() {
            var selector = $("#page-size-selector-view")[0];
            rowsPerPage = selector.options[selector.selectedIndex].value;
            downloadPermissionsMatrix();
        });
        return $result;
    }

    function createPageSelector() {
        if (totalOwners <= rowsPerPage) return "";
        var actualPage = currentPageIndex + 1;
        // 3 4 5 6 7 8 9 10 11
        var $result = $("<ol class='aui-nav aui-nav-pagination'></ol>");
        var maxPage = Math.ceil(totalOwners / rowsPerPage);
        var startPage;
        if (maxPage < 10) {
            startPage = 1;
        } else {
            startPage = actualPage > 4
                    ? (maxPage - actualPage > 4 ? actualPage - 4 : actualPage - 9 + (maxPage - actualPage + 1))
                    : 1;
        }

        $result.append("<ol class='aui-nav aui-nav-pagination'>");
        if (actualPage > 2)
            $result.append("<li class='aui-nav-first'><a href='#' class='upm-page-selector' data-page='1'>First</a></li>");
        if (actualPage > 1)
            $result.append("<li class='aui-nav-previous'><a href='#' class='upm-page-selector' data-page='" + (actualPage - 1) + "'>Prev</a></li>");
        for (var i = startPage; i < startPage + 9 && i <= maxPage; i++) {
            if (i == actualPage) {
                $result.append("<li><b>" + i + "</b></li>");
            } else {
                $result.append("<li><a href='#' class='upm-page-selector' data-page=" + i + ">" + i + "</a></li>");
            }
        }
        if (actualPage < maxPage)
            $result.append("<li class='aui-nav-next'><a href='#' class='upm-page-selector' data-page='" + (actualPage + 1) + "'>Next</a></li>");
        if (actualPage < maxPage - 1)
            $result.append("<li class='aui-nav-last'><a href='#' class='upm-page-selector' data-page='" + maxPage + "'>Last</a></li>");
        $result.find(".upm-page-selector").click(function() {
           currentPageIndex = Number(this.dataset.page -1);
           downloadPermissionsMatrix();
        });
        return $result;
    }

    function buildOwnerCell(user, addMetaData) {
        var s = MIUPMJS.escapeHtml(user.n);
        if (user.f && (user.f & 2) == 0) {
            s = s + ' <span class="disabled-owner">(disabled)</span>';
        }
        var result = $('<td>' + s + '</td>');
        if (addMetaData) {
            result.data('owner', user.n);
            if (user.anonymous) {
                result.data('anonymous', 'true');
            }
        }
        return result;
    }

    function buildPermissionCell(className) {
        var span = $('<span>&nbsp;</span>');
        span.addClass(className);
        var result = $('<td>');
        result.append(span);
        return result;
    }

    function createJobIdData() {
        var result = {jobId: jobId};
        if (!isGlobal) {
            result.key = $('#space-node').data('space-key');
        }
        return result;
    }

    function resetProgressAndButtons() {
        showButton.prop('disabled', false);
        exportButton.prop('disabled', false);
        $("#progress").toggle(false);
    }

    function showTab(tab)
    {
        $("#display-tab").toggle(tab == "display");
        $("#result-tab").toggle(tab == "result");
        $("#admin-heading-container a").toggle(tab == "result");
    }

    updateExportCsvDelimiterSelect();
    updateExportCustomSpaceDetailsSelect();

    $(".back-button").on("click", function() {
        showTab("display");
    })
});

