/* eslint-disable */
var MIUPMJS = MIUPMJS || {};

(function($) {
    MIUPMJS.ajaxOptions = {};

    MIUPMJS.escapeHtml = function(s) {
        return s.replace(/\&/g, '&amp;').replace(/\"/g, '&quot;').replace(/\'/g, '&#39;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
    }

    MIUPMJS.resetForm = function(form) {
        form.find('div.error').empty();
    }

    MIUPMJS.setFormErrors = function(form, errors) {
        $.each(errors, function() {
            var e = form.find('div#error-' + this.key);
            e.html(this.message);
        });

    }

    MIUPMJS.ajaxSetup = function(opts) {
        MIUPMJS.ajaxOptions = opts;
    }

    MIUPMJS.ajax = function(method, url, data, settings) {
        var deferred = $.Deferred();
        var promise = deferred.promise();
        var jqXHR = $.ajax({
            url: url,
            type: method,
            method: method,
            data: data,
            cache: false
        });
        jqXHR.done(function(data, textStatus, jqXHR) {
            var contentType = jqXHR.getResponseHeader('Content-Type');
            var isHtml = (contentType.indexOf('text/html') === 0);
            var expireType = "";
            if (isHtml && data.indexOf('dologin.action') > 0) {
                expireType = "session";
            }
            else if (isHtml && data.indexOf('doauthenticate.action') > 0) {
                expireType = "websudo";
            }

            if (expireType > "") {
                var expireHandler = MIUPMJS.ajaxOptions.sessionExpired ? MIUPMJS.ajaxOptions.sessionExpired() : window.location.href;
                if ($.type(expireHandler) == "function") {
                    expireHandler(expireType);
                }
                else {
                    window.location.href = AJS.contextPath()
                            + (expireType == "session" ? "/login.action?os_destination=" : "/authenticate.action?destination=")
                            + encodeURI(expireHandler);
                }
            }
            else {
                deferred.resolve.apply(this, arguments);
            }
        });
        jqXHR.fail(function(data, textStatus, jqXHR) {
            if (settings.errorMessage > '') {
                MIUPMJS.showErrorDialog('Error', settings.errorMessage, function() {
                    deferred.reject.apply(this, arguments);
                });
            }
            else {
                deferred.reject.apply(this, arguments);
            }
        });

        return promise;
    }

    MIUPMJS.get = function(url, data, settings) {
        return MIUPMJS.ajax('GET', url, data, settings);
    }

    MIUPMJS.post = function(url, data, settings) {
        return MIUPMJS.ajax('POST', url, data, settings);
    }
}(AJS.$));