/* eslint-disable */
var MIUPMJS = MIUPMJS || {};

(function($) {
    var dialogCounter = 0;
    var currentDialogId = '';

    MIUPMJS.showInfoDialog = function(title, message, onClose) {
        var infoDialog = MIUPMJS.dialog({
            title: title,
            message: message,
            onClose: function() {
                if (onClose) {
                    onClose(infoDialog);
                }
            }
        });
        infoDialog.show();
        return infoDialog;
    }

    MIUPMJS.showErrorDialog = function(title, message, onClose) {
        var errorDialog = MIUPMJS.dialog({
            title: title,
            message: message,
            className: "error-dialog",
            onClose: function() {
                if (onClose) {
                    onClose(errorDialog);
                }
            }
        });
        errorDialog.show();
        return errorDialog;
    }

    MIUPMJS.showDialog = function(opts) {
        var dialog = MIUPMJS.dialog(opts);
        dialog.show();
        return dialog;
    }

    MIUPMJS.dialog = function(opts) {
        var dialog;
        var dialogNode;
        var defaults = {
            id: "dialog-" + (dialogCounter++),
            width: 600,
            maxHeight: $(window).innerHeight() - 50
        };
        var auiZIndex;
        var options = $.extend(defaults, opts);
        currentDialogId = options.id;

        var h = measureHeight(options.message);
        dialog = new AJS.Dialog({
            width: options.width,
            height: Math.min(h + 150, options.maxHeight),
            id: options.id,
            closeOnOutsideClick: false,
            keypressListener: function(e) {
                if (e.keyCode == 27) {
                    closeDialog();
                    e.preventDefault();
                }
            }
        });
        dialogNode = $("#" + dialog.id);
        if (options.className) {
            dialogNode.addClass(options.className);
        }

        dialog.addHeader(options.title);
        //modalDialogNode.find(".dialog-title").prepend(this.guiTemplateNode.find(".content-exporter-header-avatar").clone());

        dialog.addLink("OK", function(dialog) {
            closeDialog();
        });

        dialog.addPanel("", $("<p/>").append(options.message), "panel-body");
        //modalDialogNode.find(".error-message").html(msg);

        AJS.bind("show.dialog", function(e, data) {
            //console.log("Dialog shown " + data.dialog.id + " = " + currentDialogId);
            if (data.dialog.id == currentDialogId) {
                //if (this.exportDialogNode && this.exportDialogNode.is(":visible")) {
                showCustomBlanket();
                //}
            }
        });

        return dialog;

        function closeDialog() {
            dialog.remove();
            hideCustomBlanket();
            if (options.onClose) {
                options.onClose(null);
            }
        }

        function measureHeight(msg) {
            var div = $("<div/>")
            div.css({
                "position": "absolute",
                "visibility": "hidden",
                "width": options.width + "px"
            })
            div.html(msg);
            div.appendTo("body");
            var result = div.height();
            div.remove();
            return result;
        }

        function showCustomBlanket() {
            var auiBlanket = $(".aui-blanket");
            if (auiBlanket.length > 0) {
                auiZIndex = auiBlanket.css("z-index");
                var dialogZIndex = dialogNode.css("z-index");
                auiBlanket.css("z-index", dialogZIndex - 1);
            }
            else {
                var o = this.exportDialogNode.offset();
                AJS.$(".meta-inf-blanket").css({
                    "left": o.left,
                    "top": o.top,
                    "width": this.exportDialogNode.outerWidth(),
                    "height": this.exportDialogNode.outerHeight(),
                    "z-index": dialogNode.css("z-index") - 1
                });
            }
        }

        function hideCustomBlanket() {
            var auiBlanket = $(".aui-blanket");
            if (auiBlanket.length > 0) {
                auiBlanket.css("z-index", auiZIndex);
            }
            else {
                AJS.$(".meta-inf-blanket").css({width: 0, height: 0});
            }
        }
    }

}(AJS.$));
