/* eslint-disable */
AJS.toInit(function() {
    var urlPrefix = AJS.contextPath() + "/plugins/gatekeeper-plugin/who-can-view/";

    function WhoCanView($container, params) {
        this.$container = $container;
        this.$container.html("<div>Filter by user: <input class='user-filter' type='text'/><aui-badge id='who-can-view-num-search-results'></aui-badge></div><div class='results'></div>");
        this.$resultContainer = $container.find(".results");
        this.params = params;
        this.currentPageIndex = 0;
        this.rowsPerPage = 10;

        this.$container.find(".user-filter").on("input", AJS.$.proxy(function(event) {
            this.filter = $(event.target).val();
            this.fetchUsers();
        }, this));

        this.fetchUsers();
    }

    WhoCanView.prototype.fetchUsers = function() {
        this.$resultContainer.html("<span class='aui-icon aui-icon-wait gatekeeper-wait-spinner'></span> Please wait...");
        this.params.start = this.currentPageIndex * this.rowsPerPage;
        this.params.count = this.rowsPerPage;
        this.params.filter = this.filter;
        MIUPMJS.get(urlPrefix + 'evaluate.action', this.params, {errorMessage: 'Failed evaluating permissions!'})
                .done(AJS.$.proxy(function(data, textStatus, jqXHR) {
                    this.totalOwners = data.totalOwners;
                    this.showResults(data);
                    this.$container.find("#who-can-view-num-search-results").html(this.totalOwners);
                }, this))
                .fail(AJS.$.proxy(function(jqXHR, textStatus, errorThrown) {
                    this.$resultContainer.html("Who can view macro failed! " + (jqXHR.status == 400 ? jqXHR.responseText : "See server logs!"));
                }, this))
    };

    WhoCanView.prototype.showResults = function(data) {
        var table = $("<table class='who-can-view-table'>"
                + "<thead><tr><th>Username</th><th>User</th></tr></thead>"
                + "<tbody></tbody></table>");
        var paginator = $("<div class='page-selector-container'>" +
                "<span class='pages-field'></span>" +
                "<span class='selector-field'></span>" +
                "</div>");

        var body = table.find("tbody");
        if (data.owners.length > 0) {
            for (var i = 0; i < data.owners.length; i++) {
                var owner = data.owners[i];
                var avatarHtml = "<span class=\"aui-avatar aui-avatar-small\"><span class=\"aui-avatar-inner who-can-view-avatar-icon\"><img src=\"" + owner.u + "\" alt=\"" + owner.n + "\"></span></span>";
                body.append("<tr><td><div id='who-can-view-first-col'>" + avatarHtml + AJS.escapeHtml(owner.n) + "</div></td><td><div id='who-can-view-second-col'>"
                    + (!!owner.anonymous ? "" : AJS.escapeHtml(owner.d)) + "</div></td></tr>");
            }
        }
        else {
            body.append("<tr><td colspan='2'>No results were found.</td><td>");
        }

        this.$resultContainer.empty().append(table).append(paginator);
        this.createPageSelectorContainer();

        // "<tr><td colspan='2'><i>No users to show.</i></td></tr>";
        console.log("Who can view macro evaluation time: " + data.evaluationTime + " ms");
    };

    WhoCanView.prototype.createPageSelectorContainer = function() {
        var $pagesList = this.$resultContainer.find(".page-selector-container .pages-field");
        var $pageSizeSelector = this.$resultContainer.find(".page-selector-container .selector-field");
        $pagesList.empty();
        $pageSizeSelector.empty();
        $pageSizeSelector.append(this.addPageSizeSelector());
        $pagesList.append(this.createPageSelector());
    };

    WhoCanView.prototype.addPageSizeSelector = function() {
        var $result = $("<div><span class=\"st_per_page_container\">Rows per page:" +
                "<select size=\"1\" class=\"st_per_page\"></select></span></div>");
        var $select = $result.find("select");
        $select.append("<option value='1'>1</option>");
        $select.append("<option value='2'>2</option>");
        $select.append("<option value='10'>10</option>");
        $select.append("<option value='25'>25</option>");
        $select.append("<option value='50'>50</option>");
        $select.append("<option value='100'>100</option>");
        $select.val(this.rowsPerPage);

        $result.on("change", AJS.$.proxy(function(event) {
            this.rowsPerPage = $(event.target).val();
            this.fetchUsers();
        }, this));
        return $result;
    }

    WhoCanView.prototype.createPageSelector = function() {
        if (this.totalOwners <= this.rowsPerPage) return "";
        var actualPage = this.currentPageIndex + 1;
        // 3 4 5 6 7 8 9 10 11
        var $result = $("<ol class='aui-nav aui-nav-pagination'></ol>");
        var maxPage = Math.ceil(this.totalOwners / this.rowsPerPage);
        var startPage;
        if (maxPage < 10) {
            startPage = 1;
        } else {
            startPage = actualPage > 4
                    ? (maxPage - actualPage > 4 ? actualPage - 4 : actualPage - 9 + (maxPage - actualPage + 1))
                    : 1;
        }

        $result.append("<ol class='aui-nav aui-nav-pagination'>");
        if (actualPage > 2)
            $result.append("<li class='aui-nav-first'><a href='#' class='upm-page-selector' data-page='1'>First</a></li>");
        if (actualPage > 1)
            $result.append("<li class='aui-nav-previous'><a href='#' class='upm-page-selector' data-page='" + (actualPage - 1) + "'>Prev</a></li>");
        for (var i = startPage; i < startPage + 9 && i <= maxPage; i++) {
            if (i == actualPage) {
                $result.append("<li><b>" + i + "</b></li>");
            } else {
                $result.append("<li><a href='#' class='upm-page-selector' data-page=" + i + ">" + i + "</a></li>");
            }
        }
        if (actualPage < maxPage)
            $result.append("<li class='aui-nav-next'><a href='#' class='upm-page-selector' data-page='" + (actualPage + 1) + "'>Next</a></li>");
        if (actualPage < maxPage - 1)
            $result.append("<li class='aui-nav-last'><a href='#' class='upm-page-selector' data-page='" + maxPage + "'>Last</a></li>");
        $result.find(".upm-page-selector").on("click", AJS.$.proxy(function(event) {
            this.currentPageIndex = $(event.target).data("page") - 1;
            this.fetchUsers();
        }, this));
        return $result;
    }


    $('#who-can-view-button-link-v2').on('click', function(e) {
        $("#action-menu-link").click();
        e.preventDefault();
        var $macro = $(this);
        var params = {
            spaceKey: AJS.Meta.get('space-key'),
            pageId: AJS.Meta.get('page-id'),
            hideAnonymous: false,
            ignoreRestrictions: false
        }

        this.whoCanViewDialog = new AJS.Dialog({
            width: 640,
            height: 480,
            id: "who-can-view-dialog",
            closeOnOutsideClick: true
            // keypressListener: $.proxy(function(e) {
            //     if (e.keyCode == 27) {
            //         this.closeError();
            //         e.preventDefault();
            //     }
            }, this);

        var $whoCanViewContainer = $('<div></div>');
        new WhoCanView($whoCanViewContainer, params);

        this.whoCanViewDialog.addHeader(AJS.I18n.getText('com.atlassian.confluence.plugins.gatekeeper.who-can-view-button.label'));
        //this.errorDialogNode.find(".dialog-title").prepend(AJS.CONTENT_EXPORTER.headerAvatarTemplate.clone());

        this.whoCanViewDialog.addButton("OK", $.proxy(function(dialog) {
            dialog.hide();
        }, this));

        this.whoCanViewDialog.addPanel("", $whoCanViewContainer, "panel-body");
        // this.errorDialogNode.find(".error-message").html(msg);
        // this.errorDialogNode.find("#error-details-toggler").click($.proxy(function(e) {
        //     e.preventDefault();
        //     AJS.$("#error-details").toggle();
        //     this.errorDialog.updateHeight();
        // }, this));
        this.whoCanViewDialog.show();

        return false;
    });

    $('.who-can-view-macro').each(function(index) {
        var $macro = $(this);
        var params = {
            spaceKey: $macro.data('space-key'),
            pageId: $macro.data('page-id'),
            hideAnonymous: $macro.data('hide-anonymous'),
            ignoreRestrictions: $macro.data('ignore-restrictions')
        }
        new WhoCanView($macro, params);
    })
});

// AJS.bind("hide.dialog", function(e, data) {
//     console.log("Dialog hidden: " + data.dialog.id);
//     if (data.dialog.id == "who-can-view-dialog") {
//         data.dialog.remove();
//     }
// });
//
// AJS.bind("remove.dialog", function(e, data) {
//     console.log("Dialog remove: " + data.dialog.id);
//     if (data.dialog.id == "who-can-view-dialog") {
//         //data.dialog.remove();
//     }
// });
