define('confluence/cjc/common/services', [
    'jquery',
    'ajs',
    'jira-integration-plugin/fields'
],
function(
    $,
    AJS,
    JiraIntegrationFields
) {
    'use strict';

    var THREE_MINUTES = 3 * 60 * 1000;

    return {
        createIssues: function(serverId, data) {
            var jiraRestUrl = AJS.contextPath() + '/rest/jira-integration/1.0/issues';

            return $.ajax({
                type: 'POST',
                contentType: 'application/json',
                url: jiraRestUrl + '?applicationId=' + serverId,
                data: data,
                timeout: THREE_MINUTES
            });
        },

        /**
         * Call JIP to render required fields
         * @param options
         */
        renderCreateRequiredFields: function(options) {
            JiraIntegrationFields.renderCreateRequiredFields(
                options.$container,
                options.afterElement,
                options.context,
                options.options,
                options.errorCallback
            );
        }
    };
});
