define('confluence/cjc/issue-field/init', [
    'ajs',
    'confluence/cjc/issue-field/collection',
    'confluence/cjc/error/error-type'
],
function(
    AJS,
    IssueFieldCollection,
    ErrorType
) {
    'use strict';
    return {
        /**
         * Initialize all supported field issue types
         * @returns {IssueTypeCollection}
         */
        init: function() {
            var issueFields = new IssueFieldCollection();

            issueFields.add({
                name: 'summary',
                type: 'string',
                index: 0,
                required: true,
                label: AJS.I18n.getText('createjiracontent.dialog.form.text.summary.label')
            });

            issueFields.add({
                name: 'description',
                type: 'string',
                index: -1,
                required: false,
                label: AJS.I18n.getText('createjiracontent.dialog.form.text.description.label')
            });
            return issueFields;
        }
    };

});



