define('confluence/cjc/create-issue-form-submit-validation', [
    'jquery',
    'ajs',
    'underscore',
    'confluence/cjc/error/error-type'
],
function(
    $,
    AJS,
    _,
    ErrorType
) {
    'use strict';
    /**
     * Handling validation with abstract manner.
     * It means that we want to check validation by some HTML attributes.
     * @param {Object} options
     * @param {jQuery object} options.$form - a jQuery element to wrap form
     * @constructor
     */
    var CreateIssueFormSubmitValidation = function(options) {
        this.$form = options.$form;
        this.errors = [];

        // turn off HTML5 default validation
        this.$form.attr('novalidate', 'novalidate');
    };

    CreateIssueFormSubmitValidation.prototype.startValidation = function(successCallback, errorCallback) {
        successCallback = successCallback || function() {};
        errorCallback = errorCallback || function() {};

        this.errors = [];
        var valid = this._checkRequiredFields();

        if (valid) {
            successCallback();
        } else {
            errorCallback(this.errors);
        }

        return valid;
    };

    CreateIssueFormSubmitValidation.prototype._checkRequiredFields = function() {
        // AUI 9.9.1 select 2 will set display:none so filter with :visible won't work
        var $requiredFields = this.$form
                                    .find('[required]')
                                    .filter('input[type=text]:visible, select, textarea:visible');

        // remove fields which are generated by select2
        $requiredFields = $requiredFields.filter(function(index, el) {
            return $(el).attr('id').indexOf('s2id_autogen') < 0;
        });

        var valid = true;
        var _this = this;

        $requiredFields.each(function(index, el) {
            var $el = $(el);
            var val = $.trim($el.val());

            var isSingleFieldValid = true;

            if ($el.is('select')) {
                isSingleFieldValid = (val !== '-1') && (val !== '');
            } else {
                isSingleFieldValid = val !== '';
            }

            if (!isSingleFieldValid) {
                _this.errors.push({
                    el: el,
                    errorMessageContent: AJS.I18n.getText('createjiracontent.dialog.create.issue.error.required.field', $el.attr('data-name')),
                    type: ErrorType.ERROR_INVALID_SUBMIT_DATA_ID
                });

                valid = false;
            }
        });

        return valid;
    };

    return CreateIssueFormSubmitValidation;
});
