require(
  [
    'ajs',
    'underscore',
    'confluence/analytics-support',
    'confluence/api/constants',
    'confluence/api/event',
    'confluence/api/logger'
  ],
  function (
    AJS,
    _,
    Analytics,
    Constants,
    Event,
    Logger
  ) {
    AJS.toInit(function ($) {
      var isEditInOfficeEnabled = AJS.DarkFeatures.isEnabled("enable.legacy.edit.in.office");

      $("div.converter-macro-ajax-container").each(function () {
        var $el = $(this);

        // The macro parameters are encoded as JSON in the DOM.
        var macroParameters = _.unescape($el.find(".converter-macro-parameters")[0].innerHTML)? JSON.parse(_.unescape($el.find(".converter-macro-parameters")[0].innerHTML)): null;
        $el.find(".converter-macro-file-name").text(macroParameters.name);

        Analytics.publish('confluence.plugin.office-connector.view-file-macro.init', {
          fileType: macroParameters.type
        });

        $.ajax({
          dataType: 'json',
          url: Constants.CONTEXT_PATH + '/rest/office/1.0/view',
          data: macroParameters,
          success: function (data) {
            Analytics.publish('confluence.plugin.office-connector.view-file-macro.success', {
              fileType: macroParameters.type
            });

            $el.html(Confluence.OfficeConnector.ConverterMacro.renderContent(data));

            if (isEditInOfficeEnabled) {
              initEditInOffice($el);
            } else {
              initCompanionEditButton($el);
            }
          },
          error: function (xhr, status, error) {
            Analytics.publish('confluence.plugin.office-connector.view-file-macro.error', {
              fileType: macroParameters.type
            });
            Logger.log(xhr, status, error);

            xhr.responseJSON.downloadUrl = Constants.CONTEXT_PATH + xhr.responseJSON.downloadUrl;
            $el.html(Confluence.OfficeConnector.ConverterMacro.renderPreviewError(xhr.responseJSON));

            if (isEditInOfficeEnabled) {
              initEditInOffice($el);
            } else {
              initCompanionEditButton($el);
            }
          }
        });
      })
    });

    var initCompanionEditButton = function ($el) {
      try {
        var embeddedInitializer = require('cp/component/companion/embedded-edit-with');
      } catch (e) {
        AJS.warn('officeconnector.converter-macro.initCompanionEditButton: Embedded Edit With resource not available.', e);
        return;
      }

      var $container = $el.find(".companion-edit-button-placeholder");

      if (embeddedInitializer && embeddedInitializer.loadEditButton && $container.length) {
        embeddedInitializer
          .loadEditButton($container)
          .then(function (companionMainView) {
            Event.trigger('oc-slideviewer-embedded-edit-button-loaded', companionMainView);
          })
          ['catch'](function (error) {
            Logger.log(error);
          });
      }
    }

    var initEditInOffice = function ($el) {
      try {
        var EditInOffice = require('office-connector/edit-in-office');
      } catch (e) {
        AJS.warn('Edit in Office resource not available.', e);
        return;
      }

      var editInOfficeLinks = $el.find('#edit-in-word, #edit-in-word-pathauth, a.office-editable, a.office-editable-pathauth');
      editInOfficeLinks.each(function () {
        EditInOffice.attachClickHandler(this);
      });
    }
  });
