AJS.$(function($) {

	var confluenceContextPath = AJS.contextPath();
	var spaceAttachmentsError = AJS.I18n.getText("confluence.extra.attachments.error.spaceattachmenterror");
	var updateSpaceAttachments = function($spaceAttachments) {

		$.ajax({
			cache: false,
			data : $spaceAttachments.data("spaceAttachmentsCacheData"),
			dataType : "html",
			success : function(serverGeneratedHtml) {
				var $finalOutput = $(serverGeneratedHtml);
				$(".attachments-container", $spaceAttachments).replaceWith($finalOutput.find(".attachments-container"));
				AJS.Labels.bindOpenDialog(AJS.$(".show-labels-editor", $(".attachments-container")));
				// we need to re-bind the click event triggers with the respective element after the whole HTML content is replaced
				handleClickEvents($spaceAttachments);
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {

				AJS.log("Error retrieving space attachments: " + errorThrown);
				$(".attachments-container", $spaceAttachments).remove();
				$spaceAttachments.append('<div class="space-attachments-error error">'+ spaceAttachmentsError +'</div>');
			},

			type : "GET",
			url : confluenceContextPath + "/pages/plugins/attachments/space-attachments.action"
		});
	};

	var handleClickEvents = function($spaceAttachments) {
		var spaceAttachmentsData = {};
		var setPageNumber = function (pageNumber) {
			spaceAttachmentsData["pageNumber"] = pageNumber;
		}

		$("fieldset input[class='param']", $spaceAttachments).each(function() {
			spaceAttachmentsData[this.name] = this.value;
		});
		$spaceAttachments.data("spaceAttachmentsCacheData", spaceAttachmentsData);

		$(".spaceAttachmentsPage", $spaceAttachments).on('click', function() {
			var $spaceAttachmentsPage = $(this);
			var $clickedPage = $spaceAttachmentsPage.attr("clickedPage");

			setPageNumber($clickedPage);
			updateSpaceAttachments($spaceAttachments);
			return false;
		});

		$(".spaceAttachmentsSortBy", $spaceAttachments).on('click', function() {
			var $spaceAttachmentsSortBy = $(this);

			spaceAttachmentsData["sortBy"] = $spaceAttachmentsSortBy.attr("sortBy");
			setPageNumber(1);
			updateSpaceAttachments($spaceAttachments);
			return false;
		});

		$(".removeFilterLink", $spaceAttachments).on('click', function() {

			spaceAttachmentsData["fileExtension"] = "";
			spaceAttachmentsData["labelFilter"] = "";
			setPageNumber(1);
			updateSpaceAttachments($spaceAttachments);
			return false;
		});

		$(".filterButton", $spaceAttachments).on('click', function() {
			var $fileExtensionType = $("input[name='fileExtensionType']", $spaceAttachments).val();
			var $labelFilter = $("input[name='labelFilter']", $spaceAttachments).val();

			filterSpaceAttachments($fileExtensionType, $labelFilter);
		});

		$(".fileExtensionType", $spaceAttachments).on('keydown', function(event) {
			if(event.keyCode === '13') {
				var $labelFilter = $("input[name='labelFilter']", $spaceAttachments).val();
				var $fileExtensionType = $("input[name='fileExtensionType']", $spaceAttachments).val();

				filterSpaceAttachments($fileExtensionType, $labelFilter);
			}
		});

		$(".labelFilter", $spaceAttachments).on('keydown', function(event) {
			if(event.keyCode === '13') {
				var $labelFilter = $("input[name='labelFilter']", $spaceAttachments).val();
				var $fileExtensionType = $("input[name='fileExtensionType']", $spaceAttachments).val();
				filterSpaceAttachments($fileExtensionType, $labelFilter);
			}
		});

		var filterSpaceAttachments = function(fileExtensionType, label) {

			spaceAttachmentsData["fileExtension"] = fileExtensionType;
			spaceAttachmentsData["labelFilter"] = label;
			setPageNumber(1);
			updateSpaceAttachments($spaceAttachments);
			return false;
		};
	}
	$(".space-attachments").each(function() {
		handleClickEvents($(this));
	});
});
