/* eslint-disable @atlassian/confluence-server/matching-tests, @atlassian/confluence-server/web-resource-audit,
   no-param-reassign, no-undef, valid-jsdoc */
/**
 * @module confluence-quick-reload/handlers/quick-reload-attachments
 */
define('confluence-quick-reload/handlers/quick-reload-attachments', [
    'underscore',
    'jquery',
    'ajs',
    'confluence/flag',
    'confluence-quick-reload/utils/quick-reload-count'
],
/**
 * A QuickReload handler for updating the page content.
 * Obviously for multiple updates only the most recent change will be shown.
 *
 * @tainted QuickComment.Templates
 * @exports confluence-quick-reload/handlers/quick-reload-page
 */
function(
    _,
    $,
    AJS,
    Flag,
    QuickReloadCount
) {
    'use strict';

    var pageEditFlag;

    return {
        results: [],
        property: 'attachmentsCount',

        filterNewResults: function(current, newResults) {
            const attachmentsChanged = newResults[0];

            if (typeof attachmentsChanged === 'number' && attachmentsChanged > 0) {
                current.length = 0;
                return newResults;
            }
            return [];
        },

        render: function(newResults) {
            const attachmentsChanged = newResults[0] || 0;
            QuickReloadCount.setCount(QuickReloadCount.getCount() + attachmentsChanged);

            const flagDefaults = {
                close: 'manual',
                type: 'info',
                extraClasses: 'qr-flag',
                fifo: true,
                stack: 'quickreload'
            };
            const title = AJS.I18n.getText('quick.reload.attachment');

            const flagBody = QuickReload.Templates.pageAttachments({});
            if (pageEditFlag === undefined || pageEditFlag.getAttribute('aria-hidden') === 'true') {
                pageEditFlag = new Flag($.extend({}, {
                    body: flagBody,
                    title: title
                }, flagDefaults));

                $(pageEditFlag).on('click', '.qr-notice-show', function() {
                    $(this).prop('disabled', true).prepend('<span class="aui-icon aui-icon-wait"></span>&nbsp;');
                    window.location.reload();
                });

                const self = this;
                const onClose = function() {
                    QuickReloadCount.setCount(QuickReloadCount.getCount() - (self.results[0] || 0));
                    self.results = [];
                };
                $(pageEditFlag).on('aui-flag-close', _.bind(onClose, this));
            } else {
                $(pageEditFlag).find('.qr-container').replaceWith(flagBody);
                $(pageEditFlag).find('.title').text(title);
            }
        }
    };
});
