/**
 * On DomContentLoaded, checks that conditions are right for enabling quick reload and if they are, starts quick reload
 *
 * @tainted Confluence.CommentDisplayManager
 * @tainted AJS.DarkFeatures
 */
require([
    'ajs',
    'confluence/dark-features',
    'confluence-quick-reload/main/quick-reload-manager',
    'confluence-quick-reload/handlers/quick-reload-comments',
    'confluence-quick-reload/handlers/quick-reload-inline-comments',
    'confluence-quick-reload/handlers/quick-reload-page',
    'confluence-quick-reload/handlers/quick-reload-read-only-mode',
    'confluence-quick-reload/handlers/quick-reload-attachments',
    'confluence/legacy'
],
function(
    AJS,
    DarkFeatures,
    QuickReloadManager,
    commentHandler,
    inlineCommentHandler,
    pageEditHandler,
    readOnlyModeHandler,
    attachmentsHandler,
    Confluence
) {
    'use strict';

    AJS.toInit(function() {
        if (isCompatible()) {
            QuickReloadManager.addHandler(commentHandler);
            QuickReloadManager.addHandler(inlineCommentHandler);
            QuickReloadManager.addHandler(pageEditHandler);
            QuickReloadManager.addHandler(attachmentsHandler);
            QuickReloadManager.addHandler(readOnlyModeHandler);

            QuickReloadManager.enable();

            AJS.bind('page.commentAddedOrUpdated', function(e, data) {
                commentHandler.ignoreOnce(data.commentId);
            });
        }
    });

    function isCompatible() {
        if (DarkFeatures.isEnabled('quickreload.disabled')) {
            return false;
        }

        // We need CommentDisplayManager to continue
        if (!Confluence.CommentDisplayManager) {
            return false;
        }

        // Don't activate quick reload if we don't have a page-id (e.g. page embedded in a remote iframe)
        return AJS.Meta.get('page-id') !== undefined;
    }
});
