/**
 * A simplified version of quick-reload-main.js that handles the read-only mode only
 * @tainted AJS.DarkFeatures
 * @since 6.10.0
 */
require([
    'ajs',
    'confluence/dark-features',
    'confluence-quick-reload/main/quick-reload-manager',
    'confluence-quick-reload/handlers/quick-reload-read-only-mode'
],
function(
    AJS,
    DarkFeatures,
    QuickReloadManager,
    readOnlyModeHandler
) {
    'use strict';

    function isCompatible() {
        return !DarkFeatures.isEnabled('quickreload.disabled');
    }

    AJS.toInit(function() {
        if (isCompatible()) {
            QuickReloadManager.addHandler(readOnlyModeHandler);

            QuickReloadManager.enable();
        }
    });
});
