/**
 * @module confluence-quick-reload/utils/quick-reload-count
 */
define('confluence-quick-reload/utils/quick-reload-count', [],
    function() {
        'use strict';

        var originalTitle = document.title;

        function QuickReloadCount() {
            this.count = 0;
        }

        QuickReloadCount.prototype.getCount = function() {
            return this.count;
        };

        QuickReloadCount.prototype.setCount = function(count) {
            this.count = count;
            this._displayCount();
        };

        QuickReloadCount.prototype._displayCount = function() {
            var displayString = (this.count > 0 ? '(' + this.count + ') ' : '');
            document.title = displayString + originalTitle;
        };

        // return a singleton
        return (new QuickReloadCount());
    }
);
