(function($, _) {
    'use strict';

    window.Roadmap = window.Roadmap || {};
    var RM = {};
    RM.Helper = Confluence.Roadmap.Helper;

    Roadmap.TimelineView = Backbone.View.extend({
        className: 'roadmap-frame-title',

        initialize: function() {
            _.bindAll(this, 'render');
        },

        render: function() {
            this.model.calculateTimelineColumns();
            this.$el.html(Confluence.Templates.Roadmap.timeline({displayTimelines: this.model.get('displayTimelineColumns')}));
            return this;
        },

        update: function() {
            this.render();
        },

        getBarPosition: function(bar) {
            const displayOption = this.model.get('displayOption');
            const attributes = this.model.attributes;
            const startDate = bar.startDate;
            const width = RM.Helper.getWidthTimeline(attributes, bar);
            let left;
            switch (displayOption) {
                case Roadmap.TIMELINE_DISPLAY_OPTION.MONTH:
                    left = RM.Helper.getPosXOnMonthTimeline(attributes, startDate);
                    break;
                case Roadmap.TIMELINE_DISPLAY_OPTION.WEEK:
                    left = RM.Helper.getPosXOnWeekTimeline(attributes, startDate);
                    break;
                case Roadmap.TIMELINE_DISPLAY_OPTION.DAY:
                    left = RM.Helper.getPosXOnDayTimeline(attributes, startDate);
                    break;
            }
            return { left, width };
        },

        getBarDuration: function(barWidth) {
            const displayOption = this.model.get('displayOption');
            switch (displayOption) {
                case Roadmap.TIMELINE_DISPLAY_OPTION.MONTH:
                    return barWidth / Roadmap.MONTH_WIDTH;
                case Roadmap.TIMELINE_DISPLAY_OPTION.WEEK:
                    return barWidth / Roadmap.WEEK_WIDTH;
                case Roadmap.TIMELINE_DISPLAY_OPTION.DAY:
                    return barWidth / Roadmap.DAY_WIDTH;
            }
        },

        getBarStartDate: function(positionX) {
            const displayOption = this.model.get('displayOption');
            switch (displayOption) {
                case Roadmap.TIMELINE_DISPLAY_OPTION.MONTH:
                    return RM.Helper.getMonthStartDateByPosition(this.model.attributes, positionX);
                case Roadmap.TIMELINE_DISPLAY_OPTION.WEEK:
                    return RM.Helper.getWeekStartDateByPosition(this.model.attributes, positionX);
                case Roadmap.TIMELINE_DISPLAY_OPTION.DAY:
                    return RM.Helper.getDayStartDateByPosition(this.model.attributes, positionX);
            }
        }
    });
})(AJS.$, window._);
