/**
 * This module provides helper functions for CQL templates such as accessibility and toggling state.
 */
define('confluence-ui-components/js/cql/internal/cql-navigation-helper', ['jquery'], function () {
    'use strict';

    // Add keyboard navigation for radio groups
    const setAccessibleKeyboardNavigationForRadioGroup = ($el, fieldName) => {
        // Apply for radiogroup templates only, update if suit other templates
        if (!['lastmodified', 'type'].includes(fieldName)) return;

        const $radiogroup = $el.is('[role="radiogroup"]') ? $el : $el.find('[role="radiogroup"]');
        const $options = $el.find('.aui-nav li');

        $radiogroup.on('keydown', function (event) {
            const $currentlyFocusedLi = $options.filter(`:focus`);
            const index = $options.index($currentlyFocusedLi);

            switch (event.key) {
                case 'ArrowUp':
                case 'ArrowLeft':
                    event.preventDefault();
                    const $previousElement = index - 1 < 0 ? $options.last() : $options.eq(index - 1);
                    $currentlyFocusedLi.attr('tabindex', '-1');
                    $previousElement.attr('tabindex', '0');
                    $previousElement.focus();
                    break;
                case 'ArrowDown':
                case 'ArrowRight':
                    event.preventDefault();
                    const $nextElement = index + 1 > $options.length - 1 ? $options.first() : $options.eq(index + 1);
                    $currentlyFocusedLi.attr('tabindex', '-1');
                    $nextElement.attr('tabindex', '0');
                    $nextElement.focus();
                    break;
                case 'Enter':
                case ' ':
                    event.preventDefault();
                    if ($currentlyFocusedLi.attr('aria-checked') !== 'true') {
                        $currentlyFocusedLi.click();
                    }
                    break;
                default:
                    break;
            }
        });
    };

    const select = ($element) => {
        $element.addClass('aui-nav-selected').attr('aria-checked', 'true').attr('tabindex', '0');
    };

    const unselect = ($element) => {
        $element.removeClass('aui-nav-selected').attr('aria-checked', 'false').attr('tabindex', '-1');
    };

    const setSelected = ($target, $previous) => {
        unselect($previous);
        select($target);
    };

    const setRadioGroupAriaLabel = ($element, str) => {
        if (typeof str === 'string') {
            const $radiogroup = $element.is('[role="radiogroup"]') ? $element : $element.find('[role="radiogroup"]');
            $radiogroup.attr('aria-label', str);
        }
    };

    return {
        setAccessibleKeyboardNavigationForRadioGroup,
        setSelected,
        setRadioGroupAriaLabel,
    };
});
