/**
 * @module confluence-user-rest/directory-aggregation-warning
 */
define('confluence-user-rest/directory-aggregation-warning', [
    'jquery',
    'ajs',
    'window',
    'confluence/legacy'
], function(
    $,
    AJS,
    window,
    Confluence
) {
    'use strict';

    return function($) {
        var contextPath = AJS.contextPath();
        AJS.messages.info('#main', {
            title: AJS.I18n.getText('aggregation.warning.title'),
            body: Confluence.Templates.UserDirectoryAggregation.renderWarning(),
            id: 'aggregation-warning-msg',
            insert: 'prepend',
            closeable: false,
            shadowed: true
        });

        $('.aggregation-acknowledge').on('click', function(ev) {
            var redirect = ev.target.getAttribute('id') === 'aggregation-read-more';
            var request = $.ajax({
                url: contextPath + '/rest/user-management/1.0/aggregation-warning/acknowledge',
                type: 'PUT'
            });
            var $warningMsg = $('#aggregation-warning-msg');
            request.then(function() {
                if (redirect) {
                    $warningMsg.remove();
                    window.location.href = 'https://confluence.atlassian.com/display/DOC/Confluence+5.7+Upgrade+Notes#Confluence5.7UpgradeNotes-AggregatedGroupMembership';
                } else {
                    $warningMsg.fadeOut(500, function() {
                        this.parentNode.removeChild(this);
                    });
                }
            });

            request.fail(function() {
                AJS.messages.error('#aggregation-warning-msg', {
                    body: AJS.I18n.getText('aggregation.warning.could.not.save'),
                    id: 'config-update-failed',
                    insert: 'append',
                    closeable: false,
                    shadowed: true
                });
                $('.aui-message#config-update-failed').delay(5000).fadeOut(500, function() {
                    $warningMsg.remove();
                });
            });
        });
    };
});

require('confluence/module-exporter').safeRequire('confluence-user-rest/directory-aggregation-warning', function(DirectoryAggregationWarning) {
    'use strict';

    require('ajs').toInit(DirectoryAggregationWarning);
});
