AJS.toInit(function ($) {
    function contentOptionChangeHandler() {
        var isAllSelected = !!$("#contentOptionAll:checked").length;
        if (isAllSelected) {
            hideContentTree();
            $('div.buttons-container input.submit[name="confirm"]').prop('disabled', false);
        } else {
            showContentTree();
        }
    }

    function hideContentTree() {
        $("#exportContentTree").hide();
        $("#export-comments-attachments-options-container").hide();
        $("#export-content-tree-container").hide();
    }

    function showContentTree() {
        var $exportContentTree = $("#exportContentTree");
        if (!($exportContentTree.attr("tree-loaded") === "true")) {
            loadContentTree(function(){
                //setup the events once the tree is loaded
                $(".exportContentTreeCheckbox").click(function () {
                    toggleChildren(this);
                });

                // Single node select functionality
                //
                $(".togglemeonlytreenode").click(function (e) {
                    var inputCheckbox = $($(this).siblings(".exportContentTreeCheckbox").get(0));
                    if (inputCheckbox.prop("checked")) {
                        inputCheckbox.prop("checked",false);
                    } else {
                        inputCheckbox.prop("checked", true);
                    }
                    event.preventDefault();
                });

                // Dispay the select all checkbox
                $("#selectAllContainer").show();
                // 'hidden' class only need before we load page tree after that we reply on JQuery
                $("#selectAllContainer").removeClass('hidden');
            });
        }
        $("#export-comments-attachments-options-container").show();
        $("#export-content-tree-container").show();
        $exportContentTree.show();
    }

    function toggleChildren(checkboxElement) {
        var $checkbox = $(checkboxElement),
            isChecked = $checkbox.prop("checked");

        $checkbox.parent().find("input.exportContentTreeCheckbox").prop("checked", isChecked)
                                                                  .each(cascadeToggleExcludes(isChecked));
    }

    function cascadeToggleExcludes (isChecked) {
        return function (idx, elem) {
            var pageId = $(elem).val(),
                $excludeInput = $('input[name="contentToBeExcluded"]', $(elem).parent());
            if (!isChecked) {
                AJS.log("Setting contentToBeExcluded to " + pageId);
                $excludeInput.val(pageId);
            } else {
                AJS.log("Unsetting contentToBeExcluded");
                $excludeInput.val("");
            }
        };
    }

    /**
     * Loads the page tree. When the tree is completed loading, call the loadCompletedCallback parameter if given.
     */
    function loadContentTree(loadCompletedCallback) {
        var $exportContentTree = $("#exportContentTree"),
            url = AJS.contextPath() + $exportContentTree.attr("data-content-tree-src"),
            data = {
                key       : $exportContentTree.attr("data-space-key"),
                atl_token : AJS.Meta.get('atl-token')
            };
        $exportContentTree.html('');
        AJS.$('#exportContentTree').spin();
        AJS.safe.ajax({
            type: "POST",
            url: url,
            data: data,
            dataType: "xml"
        }).done(function(data, status, xhr){
            var contentType = xhr.getResponseHeader("content-type") || "";
            if (contentType.indexOf('xml') > -1) {
                setTimeout(function(){ pollLongRunningTask($(data).find('url').text(), loadCompletedCallback); }, 1500);
                return;
            }
        }).fail(function(jqXHR, textStatus, errorThrown){
            onContentTreeErrorReceived(url, textStatus, errorThrown);
        });
    }

    function onContentTreeReceived(data, loadCompletedCallback) {
        var $exportContentTree = $("#exportContentTree")
        AJS.$('#exportContentTree').spinStop();
        $exportContentTree
                .attr("tree-loaded", "true")
                .html(data);
        loadCompletedCallback && loadCompletedCallback();
    }

    function onContentTreeErrorReceived(url, textStatus, errorThrown, message, retryCallback, retryParams) {
        var $exportContentTree = $("#exportContentTree");
        AJS.$('#exportContentTree').spinStop();

        const errorText = message ? message : errorThrown + " " + textStatus + ": url=" + url;
        const errorMessage = require('confluence/templates').Export.Pdf.contentTreeError({
            errorText,
            spaceKey: $exportContentTree.attr("data-space-key")
        })
        $exportContentTree.attr('tree-loaded', 'false').html(errorMessage);
        $('div.buttons-container input.submit[name="confirm"]').prop('disabled', true);

        if(retryCallback) {
            $("#retry-button").unbind("click").bind("click", function(e){
                $exportContentTree.html('');
                $exportContentTree.spin();
                retryCallback(retryParams);
                e.preventDefault();
            })
            $("#retry-button").show();
        } else {
            $("#retry-button").hide();
        }
    }

    function downloadContentTree(url, loadCompletedCallback) {
        $.ajax({
            type: 'GET',
            url: url,
            success: function (data) {
                onContentTreeReceived(data, loadCompletedCallback);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                onContentTreeErrorReceived(url, textStatus, errorThrown, false, downloadContentTree,
                        url, loadCompletedCallback);
            }
        });
    }

    function pollLongRunningTask(url, loadCompletedCallback) {
        $.ajax({
            type: 'GET',
            url: url,
            success: function (data) {
                var $xml = $(data);
                var completed = parseInt($xml.find('percentComplete').text());
                if(!isNaN(completed)) {
                    if (completed === 100) {
                        if ($xml.find('isSuccessful').text() === 'true') {
                            downloadContentTree($xml.find('currentStatus').text(), loadCompletedCallback);
                        }
                        else {
                            onContentTreeErrorReceived(url, '', '', $xml.find('currentStatus').text(), pollLongRunningTask,
                                    url, loadCompletedCallback);
                        }
                    }
                    else {
                        setTimeout(function () { pollLongRunningTask(url, loadCompletedCallback); }, 5000);
                    }
                } else {
                    onContentTreeErrorReceived(url, '', '', ' ', pollLongRunningTask,
                            url, loadCompletedCallback);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                onContentTreeErrorReceived(url, textStatus, errorThrown, false,
                        pollLongRunningTask, url, loadCompletedCallback);
            },
            dataType: 'xml'
        });
    }

    // Check and clear all links
    //
    $("#selectAll").on("change", function () {
        if($(this).prop('checked')){
            $("input.exportContentTreeCheckbox").prop("checked", true)
                .each(cascadeToggleExcludes(true));
        } else {
            $("input.exportContentTreeCheckbox").prop("checked", false)
                .each(cascadeToggleExcludes(false));
        }

        return false;
    });

    // Include comments and backup attachments checkboxes
    //
    $("#includeComments").click(function () {
        $("#includeCommentsCopy").prop("checked", this.checked);
    });
    $("#includeCommentsCopy").click(function () {
        $("#includeComments").prop("checked", this.checked);
    });
    $("#backupAttachments").click(function () {
        $("#backupAttachmentsCopy").prop("checked", this.checked);
    });
    $("#backupAttachmentsCopy").click(function () {
        $("#backupAttachments").prop("checked", this.checked);
    });

    // Pages to export radio buttons
    //
    $("#contentOptionAll, #contentOptionVisible").click(contentOptionChangeHandler);

    // Add the tooltip to the select all checkbox
    $("#selectAllContainer").tooltip();
});
