define("tc/auto-complete-search-helper",
    [
        "tc/calendar-util"
    ], function
        (
            CalUtil
        )
    {
        "use strict";
        return {
            makeAutoCompleteSearch : function(calendarDiv, searchField, searchOptions) {
                const getHtmlLink = (result) => {
                    return result.id ? CalUtil.getParameter(calendarDiv, "baseUrl") + "/pages/viewpage.action?pageId=" + encodeURIComponent(result.id) : "#";
                };

                const mapSelection = (result) => {
                    let resultText = '';

                    if (result.link && result.link.length) {
                        resultText = getHtmlLink(result);
                    } else if (result.customValue) {
                        resultText = result.customValue;
                    }

                    return resultText;
                }

                searchField.auiSelect2({
                    minimumInputLength: 1,
                    placeholder: AJS.I18n.getText("calendar3.eventlink.pageorblogpost"),
                    allowClear: true,
                    containerCssClass: 'select',
                    dropdownCssClass: 'auto-complete-search-dropdown',
                    ajax: {
                        type: 'GET',
                        url: CalUtil.getParameter(calendarDiv, "baseUrl") + "/rest/prototype/1/search.json",
                        dataType: 'json',
                        quietMillis: 300,
                        timeout: CalUtil.ajaxTimeout,
                        data: (query) => {
                            return Object.assign({
                                search: "name",
                                query: query
                            }, searchOptions)
                        },
                        results: function (data) {
                            const results = (data.group || [])
                                .flatMap(group => (group.result || []));

                            return { results };
                        },
                    },
                    formatAjaxError: (XMLHttpRequest, textStatus, errorThrown) => {
                        if (XMLHttpRequest.status !== 400) {
                            // 400 is invalid search query - but we just want to swallow
                            // it since the user may be typing a wiki link (which would be result in this error)
                            CalUtil.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown);
                        }
                    },
                    formatResult: (result) => {
                        let resultText = '';

                        if (result.thumbnailLink) {
                            const thumbnailElement = document.createElement("img");
                            thumbnailElement.setAttribute("src", result.thumbnailLink.href);
                            resultText += thumbnailElement.outerHTML;
                        }

                        if (result.link && result.link.length) {
                            const itemElement = document.createElement("span");
                            itemElement.setAttribute("title", result.title || (result.space ? " " + result.space.name : ""));
                                // class content-type-{type} marks element for icon injection on the left
                            if (!result.thumbnailLink && result.type) {
                                itemElement.classList.add(`content-type-${result.type}`);
                            }
                            itemElement.textContent = result.title;

                            resultText += itemElement.outerHTML;
                        } else if (result.customValue) {
                            resultText += result.customValue;
                        }

                        return resultText;
                    },
                    id: mapSelection,
                    formatSelection: mapSelection,
                    initSelection: (element, setValue) => {
                        setValue({ customValue: element.val() });
                    },
                    createSearchChoice: (query) => {
                        return {
                            customValue: query
                        }
                    },
                    createSearchChoicePosition: 'top',
                });
            }
        }
    });
