define("tc/calendar-add-dialog",
    [
        "jquery",
        "tc-backbone",
        "tc/templates",
        "tc/dialogs",
        "tc/util",
        "tc/calendar-util"
    ],
    function (
        $,
        Backbone,
        Templates,
        Dialogs,
        Util,
        CalUtil) {
    "use strict";
    var dialog;

    var CalendarAddDialogView = Backbone.View.extend({
        events: {
            "click .option-new": "addNewCalendar",
            "click .option-existing": "addExistingCalendar",
            "click .option-subscription": "subscribeByUrl",
            "click .option-import": "importCalendar"
        },

        defaults: {
            title: AJS.I18n.getText("calendar3.addcalendar")
        },

        initialize: function(options) {
            options = options || {};
            this.callbackHandler = options.callbackHandler;
            this.dialogOptions = $.extend({}, this.defaults, options.dialogOptions);
        },

        hide: function() {
            dialog.hide();

            //Backbone.View.prototype.remove.call(this, arguments);
        },
        render: function () {
            if (!dialog) {
                dialog = this.dialog = new AJS.Dialog(600, 320, "add-calendar-dialog");

                dialog.addHeader(this.dialogOptions.title);

                dialog.addPanel(
                    this.dialogOptions.title,
                    Templates.addDialog(),
                    "add-calendar-panel"
                );

                if (this.dialogOptions.addClass) {
                    $("#add-calendar-dialog").addClass(this.dialogOptions.addClass);
                }

                dialog.addCancel(AJS.I18n.getText("cancel.name"), function () {
                    dialog.hide();
                    return false;
                });

                this.setElement(dialog.getCurPanel().body);
            }

            dialog.show();

            $("#add-calendar-dialog .dialog-page-menu").remove();
            var capture = dialog.popup.element.find(".dialog-components");
            var tabbable = $()
                .add( capture.find( "button, input, select, textarea" ) )
                .add( capture.find( "[href]" ) )
                .add( capture.find( "[tabindex]:not([tabindex='-1'])" ) );
                capture.focus()
                .keydown(
                    function handleKeydown(event) {
                        if ( event.key.toLowerCase() !== "tab" ) {
                            return;
                        }
                        var target = $( event.target );
                        if ( event.shiftKey ) {
                            if ( target.is( capture ) || target.is( tabbable.first() ) ) {
                                event.preventDefault();
                                tabbable.last().focus();
                            }
                        } else {
                            if ( target.is( tabbable.last() ) ) {
                                event.preventDefault();
                                tabbable.first().focus();
                            }
                        }
                    });
        },

        addNewCalendar: function() {
            var subCalendarDialog = Dialogs.getSubCalendarCreateDialog("parent", this.callbackHandler);
            Util.showDialogInUpdatedHeight(subCalendarDialog);
            $("input[name='name']", subCalendarDialog.getCurrentPanel().body).focus();
            CalUtil.fireEventForAnalytics(
                "add.calendar.click",
                { context: CalUtil.getCalendarContext(), subSource: "new" }
            );
            this.hide();
        },

        addExistingCalendar: function() {
            var inPage = $("meta[name='ajs-page-id']").length >= 1;

            var subCalendarSubscribeDialog = Dialogs.getSubCalendarSubscribeDialog(
                $.extend({
                    callbackHandler: this.callbackHandler,
                    heading: inPage ? AJS.I18n.getText("calendar3.searchcalendars") : AJS.I18n.getText("calendar3.popularcalendars"),
                    showSearch: inPage,
                    searchParams: {
                        "showSubCalendarsInView": AJS.Meta.get("space-key") !== undefined || inPage
                    },
                    disableWatching: inPage,
                    id: "internal-subscription-calendar-dialog"
                })
            );

            Util.showDialogInUpdatedHeight(subCalendarSubscribeDialog);
            CalUtil.fireEventForAnalytics(
                "add.calendar.click",
                {context: CalUtil.getCalendarContext(), subSource: "existing"}
                );
            this.hide();
        },

        subscribeByUrl: function() {
            var subCalendarDialog = Dialogs.getSubCalendarCreateDialog("subscription", this.callbackHandler);
            Util.showDialogInUpdatedHeight(subCalendarDialog);
            $("input[name='name']", subCalendarDialog.getCurrentPanel().body).focus();
            CalUtil.fireEventForAnalytics(
                "add.calendar.click",
                {context: CalUtil.getCalendarContext(), subSource: "subscribe"}
                );
            this.hide();
        },

        importCalendar: function() {
            var subCalendarDialog = Dialogs.getSubCalendarImportDialog(this.callbackHandler);
            Util.showDialogInUpdatedHeight(subCalendarDialog);
            $("input[name='name']", subCalendarDialog.getCurrentPanel()).focus();
            CalUtil.fireEventForAnalytics(
                "add.calendar.click",
                {context: CalUtil.getCalendarContext(), subSource: "import"}
            );
            this.hide();
        }

    });

    return CalendarAddDialogView;

});
