define("tc/calendar-add-dropdown",
    [
        "jquery",
        "tc-backbone",
        "tc/templates",
        "tc/dialogs",
        "tc/util"
    ],
    function (
        $,
        Backbone,
        Templates,
        Dialogs,
        Util) {
    "use strict";

    var CalendarAddDropdownView = Backbone.View.extend({

        initialize: function(options) {
            options = options || {};
            this.callbackHandler = options.callbackHandler;
        },

        render: function() {
            if (this.dropdown) {
                return;
            }

            var handler = this.callbackHandler;
            this.dropdown = $('#add-calendar-dropdown');

            this.addOptionEventHandler(
                this.dropdown,
                "#add-calendar-new",
                function () {
                    return Dialogs.getSubCalendarCreateDialog("parent", handler);
                },
                "new"
            );

            var getExistingCalendarDialog = function () {
                var inPage = $("meta[name='ajs-page-id']").length >= 1;
                return Dialogs.getSubCalendarSubscribeDialog(
                    $.extend({
                        callbackHandler: handler,
                        heading: inPage
                            ? AJS.I18n.getText("calendar3.searchcalendars")
                            : AJS.I18n.getText("calendar3.popularcalendars"),
                        showSearch: inPage,
                        searchParams: {
                            showSubCalendarsInView: AJS.Meta.get("space-key") !== undefined || inPage,
                        },
                        disableWatching: inPage,
                        id: "internal-subscription-calendar-dialog",
                    })
                );
            };
            this.addOptionEventHandler(
                this.dropdown,
                "#add-calendar-existing",
                getExistingCalendarDialog,
                "existing",
                function () {
                    return $(".dialog-components", "#internal-subscription-calendar-dialog");
                }
            );

            this.addOptionEventHandler(
                this.dropdown,
                "#add-calendar-import",
                function () {
                    return Dialogs.getSubCalendarImportDialog(handler);
                },
                "import"
            );

            this.addOptionEventHandler(
                this.dropdown,
                "#add-calendar-subscription",
                function () {
                    return Dialogs.getSubCalendarCreateDialog("subscription", handler);
                },
                "subscribe"
            ); 
        },

        addOptionEventHandler: function(dropdown, optionDialogId, getOptionDialog, optionType, getElementToFocusOn) {
            dropdown.find(optionDialogId).on("click", function (e) {
                if (e.type === "click" || e.keyCode === 13 || e.keyCode === 32) {
                    var optionDialog = getOptionDialog();
                    Util.showDialogInUpdatedHeight(optionDialog);
                    setTimeout(function () {
                        if (getElementToFocusOn) {
                            getElementToFocusOn().focus();
                        } else {
                            $("input[name='name']", optionDialog.getCurrentPanel().body).focus();
                        }
                    }, 10);
                    Confluence.TeamCalendars.fireEventForAnalytics("add.calendar.click", {
                        context: Confluence.TeamCalendars.getCalendarContext(),
                        subSource: optionType,
                    });
                }
            }); 
        }
    });

    return CalendarAddDropdownView;
});
