define("tc/subcalendar-subscribe-dialog",
    [
        "jquery",
        "ajs",
        "tc-backbone",
        "tc/templates",
        "tc/calendar-reset-url-dialog",
        "tc/calendar-caldav-subscribe-service"
    ],
    function(
        $,
        AJS,
        Backbone,
        Template,
        CalendarResetUrlDialog,
        CalDavSubscribeService
    ) {
        "use strict";
        var subscriptionTemplate = Template.subCalendarSubscribeDialog;
        var addToMyCalendarsButtonTemplate = Template.addToMyCalendarsButton;
        var addToMyCalendarsButtonStatusTemplate = Template.addToMyCalendarsButtonStatus;

        var subscribeDialogView = Backbone.View.extend({
            template: subscriptionTemplate,
            events: {
                "change select#cal-select": "updateModel",
                "change select#cal-app-select": "updateModel",
                "click #subscribe-url-copy": "handleCopyButton",
                "click #subscribe-url-reset": "handleResetButton",
                "click #add-to-mycalendars": "handleAddToMyCalendars",
                "click #remove-form-mycalendars": "handleRemoveToMyCalendars",
                "click #reload-action": "handleReloadAction"
            },
            /**
             * Hacky to dynamically set $el on view
             *
             * @param new$el
             */
            setJQueryEl: function(new$el) {
                this.undelegateEvents();
                this.$el = new$el;
                this.delegateEvents();
            },
            initialize: function(options) {
                this.setJQueryEl($(this.template({ subCalendars: this.model.subCalendars })));
                this.calendarPlugin = options.calendarPlugin;
                this.calendarDiv = options.calendarDiv;
                $(this.$el[0]).find('.aui-dialog2-header-close').replaceWith('<button class="aui-close-button" type="button" aria-label="close"></button>');
                this.dialog = AJS.dialog2(this.$el);
                this.$calendarSelection = this.$el.find("#cal-select");
                this.$calendarAppSelection = this.$el.find("#cal-app-select");
                this.service = options.calDavSubscribeService ? options.calDavSubscribeService : new CalDavSubscribeService(this.calendarPlugin, this.calendarDiv);
                this.previousAction = null;

                var modelAttributes = this.model.attributes;
                if (modelAttributes.selectedSubCalId) {
                    console.debug("Going to select sub calendar: " + modelAttributes.selectedSubCalId);
                    this.$calendarSelection.val(modelAttributes.selectedSubCalId).trigger('change');
                }
            },
            _showSpinner: function() {
                var $spinner = this.$el.find(".add-to-mycalendars-panel .spinner");
                var $panel = this.$el.find(".add-to-mycalendars-panel-container");
                $spinner.removeClass("hidden");
                $panel.addClass("hidden");
            },
            _hideSpinner: function() {
                var $spinner = this.$el.find(".add-to-mycalendars-panel .spinner");
                var $panel = this.$el.find(".add-to-mycalendars-panel-container");
                $panel.removeClass("hidden");
                $spinner.addClass("hidden");
            },
            _setSubCalendarIdInUserView: function(data) {
                var modelAttributes = this.model.attributes;
                modelAttributes["subCalendarIdInUserView"] = data;
                modelAttributes['allowAddSubCalendarIntoUserView'] =
                    data.indexOf(modelAttributes.selectedSubCalId) < 0;
            },
            handleReloadAction: function(e) {
                e.preventDefault();
                if (this.previousAction) {
                    this.previousAction(e);
                }
            },
            handleRemoveToMyCalendars: function(e) {
                console.info("Removing calendar from user view");
                e.preventDefault();
                var that = this;
                var modelAttributes = this.model.attributes;
                var $panel = this.$el.find(".add-to-mycalendars-panel-container");
                this.previousAction = this.handleRemoveToMyCalendars;

                console.log("Old calendars in view:" + modelAttributes.subCalendarIdInUserViewOld);
                this._showSpinner();
                this.service.updateSubCalendarInUserView(modelAttributes.subCalendarIdInUserViewOld)
                    .then(function(data) {
                        that._setSubCalendarIdInUserView(data);
                        $panel.html(addToMyCalendarsButtonTemplate());

                        that._hideSpinner();
                    }, function(error) {
                        $panel.html(addToMyCalendarsButtonStatusTemplate(
                            {
                                isError: true,
                                message: AJS.I18n.getText('calendar.subscribe.dialog.add.mycalendars.error.message2', AJS.contextPath() + "/calendar/mycalendar.action")
                            }));
                        that._hideSpinner();
                    });
            },
            handleAddToMyCalendars: function(e) {
                console.info("Adding calendar into user view");
                e.preventDefault();
                var that = this;
                var modelAttributes = this.model.attributes;
                var $panel = this.$el.find(".add-to-mycalendars-panel-container");
                this.previousAction = this.handleAddToMyCalendars;

                console.log("Old calendars in view:" + modelAttributes.subCalendarIdInUserView);
                that._showSpinner();
                modelAttributes["subCalendarIdInUserViewOld"] = modelAttributes.subCalendarIdInUserView.slice();
                modelAttributes.subCalendarIdInUserView.push(modelAttributes.selectedSubCalId)
                this.service.updateSubCalendarInUserView(modelAttributes.subCalendarIdInUserView)
                    .then(function(data) {
                        that._setSubCalendarIdInUserView(data);
                        $panel.html(addToMyCalendarsButtonStatusTemplate(
                            {
                                isError: false,
                                message: AJS.I18n.getText('calendar.subscribe.dialog.add.mycalendars.message', modelAttributes.selectedSubCalName)
                            }));

                        that._hideSpinner();
                    }, function(error) {
                        $panel.html(addToMyCalendarsButtonStatusTemplate(
                            {
                                isError: true,
                                message: AJS.I18n.getText('calendar.subscribe.dialog.add.mycalendars.error.message1')
                            }));

                        that._hideSpinner();
                    });
            },
            handleCopyButton: function() {
                var $urlSubcriptionTxt = this.$el.find(".subscribe-dialog-url-txt input.long-field");
                var $copyMessage = this.$el.find(".subscribe-dialog-url .copy-message");
                $urlSubcriptionTxt.select();
                document.execCommand("Copy");
                console.debug("Copy subscription url into clipboard");

                $copyMessage.removeClass("hidden");
                setTimeout(function() { $copyMessage.addClass("hidden"); }, 5000);
                return false;
            },
            handleResetButton: function() {
                var modelAttributes = this.model.attributes;
                this.dialog.hide();
                var calendarResetUrlDialog = new CalendarResetUrlDialog(
                    {
                        calendarPlugin: this.calendarPlugin,
                        calendarDiv: this.calendarDiv,
                        subCalendar: this.calendarPlugin.getSubCalendar(this.calendarDiv, modelAttributes.selectedSubCalId),
                        subCalendars: this.model.subCalendars
                    });
                calendarResetUrlDialog.render();
                return false;
            },
            updateModel: function() {
                var modelAttributes = this.model.attributes;
                console.debug("Updating model value");
                this.model.set({ "selectedSubCalId": this.$calendarSelection.val() });
                this.model.set({ "selectedSubCalName": this.$calendarSelection.find('option:selected').text() });
                this.model.set({ "selectedApp": this.$calendarAppSelection.val() });

                var that = this;
                this.service.getSubCalendarsInUserView()
                    .then(function(data, textStatus, jqXHR) {
                        if (jqXHR.status === 200) {
                            console.info("Load 'subCalendarIdInUserView' successfully");
                            that.model.attributes['subCalendarIdInUserView'] = data;
                            that.model.attributes['allowAddSubCalendarIntoUserView'] =
                                data.indexOf(modelAttributes.selectedSubCalId) < 0;
                        } else {
                            console.error("Could not load 'subCalendarIdInUserView' from server")
                            that.model.attributes['subCalendarIdInUserView'] = [];
                            that.model.attributes['allowAddSubCalendarIntoUserView'] = false;
                        }

                        that.render();
                    });
            },
            render: function() {
                var modelAttributes = this.model.attributes;
                var $outputContent = this.$el.find(".subscribe-dialog-output");
                var $helpContentHelp = this.$el.find(".subscribe-dialog-help");
                $outputContent.removeClass("hidden");
                var spinnerDefer = this.calendarPlugin.setSubCalendarSpinnerIconVisible(true);
                var that = this;

                switch (modelAttributes.selectedApp) {
                    case "OUTLOOK-WIN":
                        $helpContentHelp.html(Template.outlookHelpWin({
                            "isInUserView": !modelAttributes.allowAddSubCalendarIntoUserView,
                            "selectedCalendarName": modelAttributes.selectedSubCalName
                        }));

                        var $helpContentUrl = $helpContentHelp.find(".subscribe-dialog-url");
                        $helpContentUrl.html(Template.calDAVLinkOutput());
                        break;
                    case "OUTLOOK-BRO":
                        $helpContentHelp.html(Template.outlookHelpBro());

                        var $helpContentUrl = $helpContentHelp.find(".subscribe-dialog-url");
                        $helpContentUrl.html(Template.calDAVLinkOutput());
                        break;
                    case "APPLECAL-MAC":
                        $helpContentHelp.html(Template.appleCalHelpMac({
                            "isInUserView": !modelAttributes.allowAddSubCalendarIntoUserView,
                            "selectedCalendarName": modelAttributes.selectedSubCalName
                        }));

                        var $helpContentUrl = $helpContentHelp.find(".subscribe-dialog-url");
                        $helpContentUrl.html(Template.calDAVLinkOutput());
                        break;
                    case "APPLECAL-IOS":
                        $helpContentHelp.html(Template.appleCalHelpIos({
                            "isInUserView": !modelAttributes.allowAddSubCalendarIntoUserView,
                            "selectedCalendarName": modelAttributes.selectedSubCalName
                        }));

                        var $helpContentUrl = $helpContentHelp.find(".subscribe-dialog-url");
                        $helpContentUrl.html(Template.calDAVLinkOutput());
                        break;
                    case "GCAL-BRO":
                        $helpContentHelp.html(Template.gcalHelpBro());

                        var $helpContentUrl = $helpContentHelp.find(".subscribe-dialog-url");
                        $helpContentUrl.html(Template.calDAVLinkOutput());
                        break;
                    case "GCAL-AND":
                        $helpContentHelp.html(Template.gcalHelpAndroid({
                            "isInUserView": !modelAttributes.allowAddSubCalendarIntoUserView,
                            "selectedCalendarName": modelAttributes.selectedSubCalName
                        }));

                        var $helpContentUrl = $helpContentHelp.find(".subscribe-dialog-url");
                        $helpContentUrl.html(Template.calDAVLinkOutput());
                        break;
                    case "THUNDERBIRD":
                        $helpContentHelp.html(Template.thunderbirdHelp());

                        var $helpContentUrl = $helpContentHelp.find(".subscribe-dialog-url");
                        $helpContentUrl.html(Template.calDAVLinkOutput());
                        break;
                    case "CALDAV":
                        $helpContentHelp.html(Template.otherCalDAVHelp({
                            "isInUserView": !modelAttributes.allowAddSubCalendarIntoUserView,
                            "selectedCalendarName": modelAttributes.selectedSubCalName
                        }));

                        var $helpContentUrl = $helpContentHelp.find(".subscribe-dialog-url");
                        $helpContentUrl.html(Template.calDAVLinkOutput());
                        break;
                    case "ICAL":
                        $helpContentHelp.html(Template.otherIcalHelp());

                        var $helpContentUrl = $helpContentHelp.find(".subscribe-dialog-url");
                        if (modelAttributes["isPrivateUrlsEnabled"] === "true") {
                            $helpContentUrl.html(Template.icalLinkOutput());
                        } else {
                            $helpContentUrl.html(Template.calDAVLinkOutput());
                        }
                        break;
                    case "UNKNOWN":
                        $helpContentHelp.html(Template.otherUnknown());
                        break;
                    default:
                        $outputContent.addClass("hidden");
                }

                var $urlSubcriptionTxt = this.$el.find(".subscribe-dialog-url-txt input.long-field");
                $.when(this.model.getEndpoint(modelAttributes.selectedSubCalId))
                    .then(
                        function(subscriptionUrl) {
                            console.debug("Set subscription url: " + subscriptionUrl);
                            $urlSubcriptionTxt.val(subscriptionUrl).focus().select();
                            if (spinnerDefer) spinnerDefer.resolve();
                        },
                        function(XMLHttpRequest, textStatus, errorThrown) {
                            console.debug("set subscription error:");
                            that.calendarPlugin.showAjaxError(
                                that.calendarDiv,
                                XMLHttpRequest,
                                textStatus,
                                errorThrown,
                                that.calendarPlugin.ERROR_CLASS_PRIVATE_URL
                            );
                            if (spinnerDefer) spinnerDefer.resolve();
                        }
                    );

                this.dialog.show();
            }
        });

        return subscribeDialogView;
    }
);
