define("tc/calendar-caldav-subscribe-model",
        [
        "jquery",
        "tc/rrule",
        "tc-backbone",
        "tc/calendar-util",
        "underscore"
    ],
    function (
        $,
        TCRRule,
        Backbone,
        CalUtil,
        _
    ) {
        "use strict";

        /**
         * Backbone model of subscription url
         */
        var subscribeModel = Backbone.Model.extend({
            calDavEndpoint: "/plugins/servlet/team-calendars/caldav/",
            /**
             * mapping between value of cal app selection and a function which return
             * a promise value of subscription url
             */
            mapper: {},
            defaults: {
                subCalendars: [],
                baserUrl: "",
                selectedSubCalId: null,
                selectedSubCalName: null,
                selectedApp: null,
                isPrivateUrlsEnabled: false,
                privateUrlProvider: null,
                subCalendarIdInUserView: null,
            },
            /**
             * Initialize function which accept list of sub calendars
             * @param params
             */
            initialize: function(params) {
                this.baseUrl = params.baseUrl;
                this.subCalendars = params.subCalendars ? params.subCalendars : [];
                this.privateUrlProvider = params.privateUrlProvider;
                this.set({
                    isPrivateUrlsEnabled: params.isPrivateUrlsEnabled,
                    selectedSubCalId: params.selectedSubCalId,
                });

                var that = this;

                var autoDiscorverFunc = function(subCalendarId) {
                    var defer = $.Deferred();
                    var promise = defer.promise();
                    var urlParts = that.baseUrl.split("/");
                    var origin = urlParts[0] + "//" + urlParts[2];
                    var caldavUrl = origin.charAt(origin.length) === '/' ?  origin : origin + "/";
                    defer.resolve(caldavUrl);
                    return promise;
                };

                var directCalDAVFunc = function(subCalendarId) {
                    var defer = $.Deferred();
                    var promise = defer.promise();
                    defer.resolve(that.baseUrl + that.calDavEndpoint + encodeURIComponent(subCalendarId));
                    return promise;
                };

                var icalFunc = function(subCalendarId) {
                    if (this.attributes["isPrivateUrlsEnabled"] === "true") {
                        return icalPrivateFunc(subCalendarId);
                    }

                    return icalBasicFunc(subCalendarId);
                };

                var icalBasicFunc = function(subCalendarId) {
                    var defer = $.Deferred();
                    var promise = defer.promise();
                    defer.resolve(
                        that.baseUrl +
                        "/rest/calendar-services/1.0/calendar/export/subcalendar/" +
                        encodeURIComponent(subCalendarId) +
                        ".ics?os_authType=basic&isSubscribe=true");
                    return promise;
                };

                var icalPrivateFunc = function(subCalendarId) {
                    var subcribeUrlPromise = that.privateUrlProvider(subCalendarId);
                    return subcribeUrlPromise;
                }

                this.mapper = {
                    "OUTLOOK-WIN" : autoDiscorverFunc,
                    "OUTLOOK-BRO" : icalFunc,
                    "APPLECAL-MAC": autoDiscorverFunc,
                    "APPLECAL-IOS": autoDiscorverFunc,
                    "GCAL-BRO": icalFunc,
                    "GCAL-AND": autoDiscorverFunc,
                    "THUNDERBIRD": directCalDAVFunc,
                    "CALDAV": autoDiscorverFunc,
                    "ICAL": icalFunc
                };
            },
            /**
             * Public method will be called on UI to get value of subscription url
             * @returns {string}
             */
            getEndpoint: function(selectedSubCalId) {
                var modelAttributes = this.attributes;
                console.debug("Get endpoint for: " + modelAttributes.selectedApp);
                var returnVal = this.mapper[modelAttributes.selectedApp] ? _.bind(this.mapper[modelAttributes.selectedApp], this, selectedSubCalId)() : "Could not detected endpoint";
                return returnVal;
            }
        });

        return subscribeModel
    }
)