define("tc/calendar-caldav-subscribe-service",
    [
        "jquery",
        "tc/rrule",
        "tc-backbone",
        "tc/calendar-util"
    ],
    function (
        $,
        TCRRule,
        Backbone,
        CalUtil
    ) {
        "use strict";

        var subscriptionService = function (calendarPlugin, calendarDiv) {
            this.calendarPlugin = calendarPlugin;
            this.calendarDiv = calendarDiv;

            return {
                calendarPlugin: this.calendarPlugin,
                calendarDiv: this.calendarDiv,
                getPrivateUrlProvider: function(subCalendarId) {
                    return $.ajax({
                        cache: false,
                        type: "GET",
                        timeout: CalUtil.ajaxTimeout,
                        url: this.calendarPlugin.getCalendarServiceBaseUrl(
                            this.calendarDiv,
                            "/subcalendar/privateurl/" + encodeURIComponent(subCalendarId))
                    });
                },
                getSubCalendarsInUserView: function() {
                    return $.ajax({
                        cache: false,
                        type: "GET",
                        timeout: CalUtil.ajaxTimeout,
                        url: this.calendarPlugin.getCalendarServiceBaseUrl(
                            this.calendarDiv,
                            "/subcalendars/user/view")
                    });
                },
                updateSubCalendarInUserView: function (subCalendarIds) {
                    return $.ajax({
                        cache: false,
                        type: "PUT",
                        dataType : "json",
                        contentType: 'application/json',
                        data: JSON.stringify(
                            subCalendarIds
                        ),
                        timeout: CalUtil.ajaxTimeout,
                        url: this.calendarPlugin.getCalendarServiceBaseUrl(
                            this.calendarDiv,
                            "/subcalendars/user/view")
                    });
                }
            }
        };

        return subscriptionService;
    }
);