define("tc/calendar-edit-dialog",
    [
        "jquery",
        "underscore",
        "confluence/dialog",
        "tc-backbone",
        "tc/calendar-util",
        "tc/util",
        "tc/myCalendarTour",
        "tc/eventtypes-edit-dialog",
        "tc/calendar-restriction-dialog",
        "tc/calendar-share-dialog"
    ], function
        (
            $,
            _,
            confluenceDialog,
            Backbone,
            CalUtil,
            Util,
            CalendarTour,
            EventTypesEditDialogView,
            RestrictionDialog,
            ShareCalendarDialogView
        )
    {
        "use strict";
        var CalendarEditDialog = Backbone.View.extend({
            subCalendarType: null,
            editForm: null,
            subCalendarTypeObj: null,
            editDialog: null,
            subCalendar: null,
            callbackHandler: null,
            submitButton: null,
            eventTypesEditDialogView: null,
            shareCalendarDialogView: null,
            calendarIcalAddressDialog: null,
            _calendarDiv: null,
            _calendarPlugin: null,
            calendarCache: null,
            restrictionDialog: null,
            initialize: function (options) {
                this.options = $.extend({}, this.defaults, options);

                if (!this.options.subCalendar) {
                    AJS.debug("tc/eventtypes-edit-dialog: requires 'subCalendar' object");
                }

                if (!this.options.callbackHandler) {
                    AJS.debug("tc/eventtypes-edit-dialog: requires 'callbackHandler' object");
                }

                this.callbackHandler = this.options.callbackHandler;
                this.subCalendar = this.options.subCalendar;

                this.subCalendarType = (typeof this.subCalendar === "string") ? this.subCalendar : this.subCalendar.type;
                this.subCalendarTypeObj = Confluence.TeamCalendars.subcalendar[this.subCalendarType];

                this._calendarDiv = options._calendarDiv;

                this._calendarPlugin = options._calendarPlugin;

                this.calendarCache = options.calendarCache;
            },
            render: function () {
                this._editCalendarDialog();

                //just allow owner subcalendar have permission edit custom event type
                if (CalUtil.isInternalSubscriptionSubCalendar(this.subCalendar) &&
                    CalUtil.isJiraSubCalendar(this.subCalendar)) {
                    return this.editDialog;
                }

                //TODO: should we move this define panel to new class
                //panel id = 1
                this.eventTypesEditDialogView = new EventTypesEditDialogView(
                    {
                        editDialog: this.editDialog,
                        subCalendar: this.subCalendar,
                        callbackHandler: this.callbackHandler
                    }
                );
                this.eventTypesEditDialogView.render();

                //panel id = 2 for restriction
                this.restrictionDialog = new RestrictionDialog(
                    {
                        editDialog: this.editDialog,
                        _calendarPlugin: this._calendarPlugin,
                        _calendarDiv: this._calendarDiv,
                        subCalendar: this.subCalendar,
                        calendarCache: this.calendarCache
                    }
                );
                this.restrictionDialog.render();

                //panel id = 3 for share-embedded
                this.shareCalendarDialogView = new ShareCalendarDialogView(
                    {
                        editDialog: this.editDialog,
                        subCalendar: this.subCalendar,
                        _calendarPlugin: this._calendarPlugin,
                        _calendarDiv: this._calendarDiv
                    }
                );
                this.shareCalendarDialogView.render();
                return this.editDialog;
            },
            showRestrictionOption: function () {
                this.editDialog.gotoPanel(CalUtil.panelEditCalendar.RESTRICTION_PANEL);
            },
            showShareOption: function () {
                this.editDialog.gotoPanel(CalUtil.panelEditCalendar.SHARE_EMBEDDED_PANEL);
            },
            showSubscriptionOption: function () {
                this.editDialog.gotoPanel(CalUtil.panelEditCalendar.SUBSCRIBE_PANEL);
            },
            selectCustomEvent: function (id) {
                this.editDialog.gotoPanel(CalUtil.panelEditCalendar.EVENT_TYPE_PANEL);
                this.eventTypesEditDialogView.selectCustomEvent(id);
            },
            showAddEventTypeForm: function () {
                this.editDialog.gotoPanel(CalUtil.panelEditCalendar.EVENT_TYPE_PANEL);
                this.eventTypesEditDialogView.showAddEventypeForm();
            },
            _editCalendarDialog: function () {
                var that = this;
                // todo: remove check in Confluence 9.0
                var dialog = confluenceDialog.confluenceDialog || confluenceDialog;
                that.editDialog = new dialog({
                        width: that.subCalendarTypeObj.dialogWidth || 630,
                        height: that.subCalendarTypeObj.dialogHeight || 537,
                        onSubmit: function () {
                            that.editForm.submit();
                            return false;
                        },
                        onCancel: function () {
                            that._callBackCancel(that.editDialog, that.callbackHandler);
                            that.editDialog.remove();
                        },
                        id: "edit-calendar-dialog"
                    }
                );
                that.subCalendarTypeHandler = that.subCalendarTypeObj.getDialog(
                    that.editDialog,
                    $.isPlainObject(that.subCalendar) ? that.subCalendar : null,
                    that.callbackHandler
                );

                //Make overflow visible so that the JQL autocomplete etc are not cut off
                that.editDialog.popup.element.css("overflow", "visible");

                that.editForm = that.subCalendarTypeHandler.initializeForm(_.bind(that._callBackCancel, that, that.editDialog, that.callbackHandler));

                that.submitButton = that.editDialog.popup.element.find(".submit");

                that.editForm.submit(function () {
                    if (that.editDialog.getCurrentPanel() !== undefined) {
                        if (that.editDialog.getCurrentPanel().id === CalUtil.panelEditCalendar.GENERAL_PANEL) { //General Panel
                            return that._submitCalendarEdit(that.callbackHandler, that.subCalendarTypeHandler, that.editDialog, that.editForm, that.subCalendarTypeObj);
                        } else if (that.editDialog.getCurrentPanel().id === CalUtil.panelEditCalendar.EVENT_TYPE_PANEL) {  //custom event type panel
                            var panelBodyForm = that.editDialog.getCurrentPanel().body;
                            var eventTypeEditForm = $("form.sub-calendar-edit-event-types-form", panelBodyForm);

                            //show warning and process behaviour in edit custom event type form
                            var editCustomEventTypeForm = $("#edit-custom-event-type-form", eventTypeEditForm);
                            if ($(editCustomEventTypeForm).length) {
                                $(editCustomEventTypeForm).find(".tooltip-warning").removeClass("hidden");
                                $(panelBodyForm).scrollTop($(editCustomEventTypeForm).find("form.form-add-custom").position().top);
                                $(editCustomEventTypeForm).find('.custom-event-title input').focus();
                                return false;
                            }
                            return that._submitEventTypesEdit(eventTypeEditForm, that.editDialog, that.callbackHandler, that.subCalendarTypeHandler, that.submitButton);
                        } else if (that.editDialog.getCurrentPanel().id === CalUtil.panelEditCalendar.RESTRICTION_PANEL) { //restriction
                            return that._submitRestrictionEdit(that.editDialog);
                        }
                    }
                });
            },
            _submitCalendarEdit: function (callbackHandler, subCalendarTypeHandler, editDialog, editForm, subCalendarTypeObj) {
                if (callbackHandler.isProcessingSubCalendar()) {
                    return false;
                }

                callbackHandler.setProcessingSubCalendar(true);
                var spinnerDefer = callbackHandler.setSubCalendarSpinnerIconVisible(true);

                subCalendarTypeHandler.onSubmitStart();

                var requestData = subCalendarTypeHandler.getFormDataAsAjaxData();
                if (callbackHandler.getIncludedCalendars()) {
                    requestData.include = callbackHandler.getIncludedCalendars();
                }

                var subCalendarId = requestData.subCalendarId;
                var requestedSpaceKey = requestData.spaceKey;
                var viewingSpaceKey = requestData.viewingSpaceKey;
                var currentSpaceKey = this.subCalendar.spaceKey;
                var calendarPlugin = this._calendarPlugin;
                var calendarDiv = this._calendarDiv;
                var childSubCalendars = this.subCalendar.childSubCalendars;

                $.ajax({
                    cache: false,
                    converters: {
                        "text json": function (jsonObject) {
                            return jsonObject;
                        }
                    },
                    data: requestData,
                    dataFilter: function (data) {
                        var subCalendarsResponseEntity = data ? JSON.parse(data) : null;
                        if (subCalendarsResponseEntity.success) {
                            CalUtil.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                        }
                        return subCalendarsResponseEntity;
                    },
                    dataType: "json",
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        callbackHandler.showAjaxUpdateError(XMLHttpRequest, textStatus, errorThrown);
                        subCalendarTypeHandler.onSubmitEnd();
                        callbackHandler.setProcessingSubCalendar(false);
                    },
                    success: function (responseEntity) {
                        callbackHandler.setGenericUpdateError();

                        if (responseEntity.success) {
                            CalUtil.setFieldErrors(editForm, null);

                            if ((requestedSpaceKey !== currentSpaceKey) && (viewingSpaceKey !== ""))
                            {
                                subCalendarId = responseEntity.modifiedSubCalendarId;
                                $("input[name='subCalendarId']", editForm).val(subCalendarId);
                                calendarPlugin.removeSubCalendarEventSource(calendarDiv, subCalendarId);
                                calendarPlugin.removeSubCalendarEventSource(calendarDiv, childSubCalendars);
                                callbackHandler.setSubCalendars(subCalendarId, responseEntity.payload);
                            } else {
                                if (subCalendarId) {
                                    callbackHandler.setSubCalendars(subCalendarId, responseEntity.payload);
                                    callbackHandler.reloadSubCalendar(subCalendarId);
                                } else {
                                    subCalendarId = responseEntity.modifiedSubCalendarId;
                                    $("input[name='subCalendarId']", editForm).val(subCalendarId);
                                    callbackHandler.setSubCalendars(subCalendarId, responseEntity.payload);
                                }
                            }
                            callbackHandler.refreshCalendarInfo(responseEntity.payload);

                            callbackHandler.updateAvailableSubCalendarsInSubCalendarPanel();
                            subCalendarTypeHandler.onSubmitEnd();
                            editDialog.remove();
                        } else {
                            CalUtil.setFieldErrors(editForm, responseEntity.fieldErrors);
                            subCalendarTypeHandler.onSubmitEnd();

                            if (!subCalendarTypeObj.dynamicDialogHeight) {
                                Util.showDialogInUpdatedHeight(editDialog);
                            }
                        }
                        callbackHandler.setProcessingSubCalendar(false);
                    },
                    complete: function(){
                        if (spinnerDefer) spinnerDefer.resolve();
                    },
                    type: "PUT",
                    timeout: CalUtil.ajaxTimeout,
                    url: CalUtil.getCalendarServiceBaseUrl("/subcalendars.json")
                });
                return false;
            },
            _submitEventTypesEdit: function (eventTypeEditForm, editDialog, callbackHandler, subCalendarTypeHandler, submitButton) {
                var requestData = this._getEventTypeData(eventTypeEditForm);
                var subCalendarId = requestData.subCalendarId;

                var spinnerDefer = callbackHandler.setSubCalendarSpinnerIconVisible(true);
                //disable button submit
                $(submitButton).text(AJS.I18n.getText("calendar3.submit.updating")).prop("disabled", true).addClass("ui-state-disabled");

                $.ajax({
                    cache: false,
                    converters: {
                        "text json": function (jsonObject) {
                            return jsonObject;
                        }
                    },
                    data: requestData,
                    dataFilter: function (data) {
                        var subCalendarsResponseEntity = data ? JSON.parse(data) : null;
                        if (subCalendarsResponseEntity.success) {
                            CalUtil.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                        }
                        return subCalendarsResponseEntity;
                    },
                    dataType: "json",
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        callbackHandler.showAjaxUpdateError(XMLHttpRequest, textStatus, errorThrown);
                        subCalendarTypeHandler.onSubmitEnd();
                        $(submitButton).text(AJS.I18n.getText("ok")).prop("disabled", false).removeClass("ui-state-disabled");
                        AJS.trigger("remove-dialog-edit-event.teamcalendar");
                    },
                    success: function (responseEntity) {
                        if (responseEntity.success) {
                            if (subCalendarId) {
                                callbackHandler.setSubCalendar(subCalendarId, responseEntity.payload);
                                callbackHandler.reloadSubCalendar(subCalendarId);
                            }
                            callbackHandler.updateAvailableSubCalendarsInSubCalendarPanel();
                            subCalendarTypeHandler.onSubmitEnd();
                            editDialog.remove();
                            AJS.trigger("show-dialog-edit-event.teamcalendar");
                        }
                    },
                    complete: function(){
                        if (spinnerDefer) spinnerDefer.resolve();
                    },
                    type: "PUT",
                    timeout: CalUtil.ajaxTimeout,
                    url: CalUtil.getCalendarServiceBaseUrl("/eventtype/disable.json")
                });
                return false;
            },
            _getEventTypeData: function (eventTypeEditForm) {
                var listDisableEventTypes = this.eventTypesEditDialogView.getDisableEventTypes();

                return {
                    subCalendarId: $("input[name='subCalendarId']", eventTypeEditForm).val(),
                    disableEventTypes: listDisableEventTypes
                };
            },
            _callBackCancel: function (editDialog, callbackHandler) {
                // Show the tour again if have
                if (this.CalendarTour) {
                    this.CalendarTour.start();
                }

                var spinnerDefer = callbackHandler.setSubCalendarSpinnerIconVisible(true);
                var subCalendarId = $("input[name='subCalendarId']", editDialog.getCurrentPanel().body).val();
                $.ajax({
                    cache: false,
                    converters: {
                        "text json": function (jsonObject) {
                            return jsonObject;
                        }
                    },
                    data: {"subCalendarId": subCalendarId},
                    dataFilter: function (data) {
                        var subCalendarsResponseEntity = data ? JSON.parse(data) : null;
                        if (subCalendarsResponseEntity.success)
                            CalUtil.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                        return subCalendarsResponseEntity;
                    },
                    dataType: "json",
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        callbackHandler.showAjaxUpdateError(XMLHttpRequest, textStatus, errorThrown);
                    },
                    success: function (responseEntity) {
                        if (responseEntity.success) {
                            if (subCalendarId && responseEntity.payload && responseEntity.payload.length) {
                                $.each(responseEntity.payload, function (index, payload) {
                                    if (payload.id === subCalendarId) {
                                        callbackHandler.setSubCalendar(subCalendarId, payload);
                                        callbackHandler.reloadSubCalendar(subCalendarId);
                                    }
                                });
                            }

                            callbackHandler.updateAvailableSubCalendarsInSubCalendarPanel();
                            AJS.trigger("show-dialog-edit-event.teamcalendar");
                        }
                    },
                    complete: function(){
                        spinnerDefer.resolve();
                    },
                    type: "GET",
                    timeout: CalUtil.ajaxTimeout,
                    url: CalUtil.getCalendarServiceBaseUrl("/subcalendars.json")
                });
            },
            _submitRestrictionEdit: function (editDialog) {
                this.restrictionDialog.submitRestrictionsDialog(editDialog);
                return false;
            }
        });
        return CalendarEditDialog;
    }
);
