define("tc/calendar-feature-discovery-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/templates",
        "tc/dialogs",
        "tc/calendar-util",
        "tc/util"
    ], function
    (
        $,
        _,
        Backbone,
        Templates,
        Dialogs,
        CalUtil,
        Util
    )
    {
        "use strict";

        var CalendarFeatureDiscoveryDialog = Backbone.View.extend({
            featureDiscoveryDialog : null,
            _calendarDiv: null,
            subCalendar: null,
            _calendarPlugin : null,
            initialize: function(options){
                this._calendarDiv = options._calendarDiv;
                this.subCalendar = options.subCalendar;
                this._calendarPlugin = options._calendarPlugin;

                this.featureDiscoveryDialog = $('#team-calendars-feature-discovery-dialog');
            },
            render: function() {
                var that = this;

                if (this.featureDiscoveryDialog) {
                    this.featureDiscoveryDialog.remove();
                }

                var height = CalUtil.isPDLEnabled() ? 385 : 340,
                    discoveryDialog = new AJS.Dialog({width: 596, height: height, id: "team-calendars-feature-discovery-dialog"});

                discoveryDialog.addHeader(AJS.I18n.getText("calendar3.featurediscovery.title"));
                discoveryDialog.addPanel(
                    "",
                    Templates.subCalendarFeatures(
                        {
                            "autoConvertSupported" : CalUtil.getParameter(this._calendarDiv, "autoConvertSupported") === "true",
                            "subCalendar" : this.subCalendar
                        }),
                    "setup-calendar-panel"
                );

                var dialogBody = discoveryDialog.getCurrentPanel().body;

                //Add event panel
                $(".add-event", dialogBody).click(function() {
                    discoveryDialog.remove();
                    var dialog = Dialogs.getEditEventDialog(
                        {
                            start : new Date(),
                            localizedStartTime : that._calendarPlugin.getDefaultStartTime(),
                            localizedEndTime : that._calendarPlugin.getDefaultEndTime(),
                            allDay : (that._calendarDiv.data(that._calendarPlugin.PREF_LAST_ALL_DAY_USED) || "true") === "true",
                            subCalendarId : that.subCalendar.id
                        },
                        that.subCalendar,
                        that._calendarPlugin,
                        that._calendarDiv
                    );
                    dialog.show();

                    return false;
                });

                //Restrictions panel
                $(".restrict", dialogBody).click(function() {
                    discoveryDialog.remove();
                    that._calendarPlugin.getSubCalendarRestrictionsDialog(that._calendarDiv, that.subCalendar).show();
                    return false;
                });

                //Share panel
                $(".embed, .embed-or-share, .share", dialogBody).click(function() {
                    discoveryDialog.remove();
                    var shareDialog = that._calendarPlugin.getSubCalendarShareDialog(that._calendarDiv, that.subCalendar);
                    shareDialog.show();
                    $(".share-address-field", shareDialog.getCurrentPanel().body).focus().select();

                    return false;
                });

                discoveryDialog.addLink(AJS.I18n.getText("close.name"), function() {
                    discoveryDialog.remove();
                });

                discoveryDialog.show();
            }
        });

        return CalendarFeatureDiscoveryDialog;
    });
